<?php

namespace Edispatcher\plugins\piwik;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;


class Controller extends BaseController {

   
    //Constructor
    public function __construct(Container $ci) {
        $this->ci = $ci;
    }

    private function getHostnameProvenance($hostname)
    {
        $e = explode('.', $hostname);
        $s = sizeof($e);

        // if extension not correct
        if(($e[0]=="172"&&$e[1]=="30")||($e[0]=="172"&&$e[1]=="16")||($e[0]=="10"&&($e[1]=="77"||$e[1]=="93"||$e[1]=="94")))
        {
            return 'interne';
        }
        else
        {
            return 'externe';
        }
    }

    private function log($query) 
    {
        // Va loguer les accès à app et url =======================================
        $app = null;
        if (array_key_exists("appid",$query)) {
            $app=\R::findOne( 'app','uid = ?',[$query["appid"]]);
        }

        $url = null;
        if (array_key_exists("appid",$query)) {
            $url=\R::findOne( 'url','id = ?',[$query["urlid"]]);
            $app = $url->app;
        }

        if ($url && $app) {
            $rnes=[];

            if ($params["rne"] == "xxx" || $params["rne"] == "GLOBAL" || ! $params["rne"] ) {
            @$rnes=array_unique(GetInfoArray("rne"));
            if (count( $rnes)>=1) $params["rne"] = $rnes[0];
            } else {
            $rnes=[$params["rne"]];
            }
            // fixes #22207 : Erreur remontée sonde piwik si pas de metrics
            $metrics = $this->getMetrics();
            if ($metrics) {
                foreach ($rnes as $rne) {
                $metrics->appAccess($app->id,$url->id,$this->ci["profil"]->getProfil(),$rne);
                }
            }
        }
      // =======================================================================
    }

    private function getArgs($args) {
        // Y a t'il un cookie positionné lors de la redirection ?
        $origin = $_COOKIE["edispatcher_redirect"];
        // oui , on va l'utiliser
        if ($origin && (!isset($args["rne"])) ) {
            $parts = explode("|",$origin);
            if (count($parts)==2) {
                $args["rne"]     = $parts[0];
                if (strpos($parts[1],"http")!==false) {
                    $domain = parse_url($parts[1]);
                    $args["portail"] =  $domain['host'];       
                } else {
                    $args["portail"] = $parts[1];
                }
            }
        }
        // non on se base sur le rne d'affectation 
        else {
            $profil = $this->getProfil();
            $portails = json_decode($profil->getPortails(),true);
            foreach($portails["portails"] as $portail) {
                if ($portail["rne"]!="xxx"){
                    $args["portail"] = $portail["portal"];
                    $args["rne"]     = $portail["rne"];
                    break;
                }
            }
        }

        // Pas de portail renseigné => utilisation de académie et rne affectation;
        if (!isset($args["portail"])) {
            $rnes = GetRne();
            if (count($rnes)) {
                $args["rne"]     = $rnes[0];
            } else {
                $args["rne"]     = "ACADEMIQUE";
            }
            $args["portail"] = str_replace("https://",'',_URL_DISPATCHER);
            
        }

        // Normalisation du dns du portail 
        if (strpos($args["portail"],"http")==0) {
            $domain          = parse_url($args["portail"]);
            $args["portail"] = $domain['host'];  
        }

        return $args;
    }

    public function piwikAcadAction(Request $request, Response $response, $args) {
        
        $args = $this->getArgs($args);
        return $this->piwikAction($request,$response,$args);
    }


    public function piwikAction(Request $request, Response $response, $args) {

        $this->log($request->getQueryParams());

        $queries=$request->getQueryParams();

        // RNE GLOBAL (Ressource ARENA), on va essayer de determiner le rne assosicé
        // au profil
        if ($args["rne"]=="GLOBAL") {
            $args = $this->getArgs($args);
        }

        $params                      = [];
        $params['ELEMENTS_VERSION']  =   VERSION_ELEMENTS;
        $params["appli"]             = $queries["name"];
        $params["profil"]            = $this->getProfil()->getProfil();
        $params["portail"]           = $args["portail"];
        $params["rne"]               = $args["rne"];

        $params["piwik_url"]         = $__PLUGINS['piwik']['url'] ; 
        $params["piwik_id"]          = $__PLUGINS['piwik']['id'] ; 

        $params["PIWIK"]            = ["url"=>_URL_DISPATCHER . "/edispatcher/ng/piwik/envole","name"=> $params["appli"] ];
        $params["edispatcher" ]     = str_replace("https://",'',_URL_DISPATCHER);

        return $this->ci["view"]->render($response, '@piwik/piwik.html.twig',$params);

    }

    public function envoleTrackerAction(Request $request, Response $response, $args) {

        global $__PLUGINS;
        $this->log($request->getQueryParams());

        
        $params = [];
        // On verifie que la conf existe
        if (!isset($__PLUGINS['piwik']))              {
            return $this->ci["view"]->render($response, '@piwik/nopiwik.js.twig',$params);
        }

        if (!isset($__PLUGINS['piwik']['url']) || (!isset($__PLUGINS['piwik']['id'])) )              {
            return $this->ci["view"]->render($response, '@piwik/nopiwik.js.twig',$params);
        }

        
        $queries=$request->getQueryParams();

        $params["appli"]           = $queries["appli"];
        $params["provenance"]      = $this->getHostnameProvenance($_SERVER["REMOTE_ADDR"]);
        $params["profil"]          = $queries["profil"];
        $params["portail"]         = $queries["portail"];
        $params["rne"]             = $queries["rne"];

        $params["piwik_url"]       = $__PLUGINS['piwik']['url'] ; 
        $params["piwik_id"]        = $__PLUGINS['piwik']['id'] ; 

        return $this->ci["view"]->render($response, '@piwik/envoleTrackeur.js.twig',$params);


    }


}
