<?php

namespace Edispatcher\plugins\plog;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;


class Controller extends BaseController {

    private static $baseUrl = "https://portail.ac-reunion.fr/plog";

    private static $MDP_URL="https://portail.ac-reunion.fr/mdp2/login.jsp";
    private static $PLOG_URL="https://sso.ac-reunion.fr/saml?sp_ident=scoweb&RelayState=https://portail.ac-reunion.fr/plog/compte/index";
    private static $ELEVE_URL="http://infometice.ac-reunion.fr/wordpress/utilisateurs/mot-de-passe-oublie/";

    //Constructor
    public function __construct(Container $ci) {
        $this->ci = $ci;
    }

    private function getIP() {
        $ip = isset($_SERVER['HTTP_CLIENT_IP']) 
            ? $_SERVER['HTTP_CLIENT_IP'] 
            : (isset($_SERVER['HTTP_X_FORWARDED_FOR']) 
            ? $_SERVER['HTTP_X_FORWARDED_FOR'] 
            : $_SERVER['REMOTE_ADDR']);
        return $ip;
    }

    protected function setOption($option,$value) {
        curl_setopt($this->client,$option,$value);
    }

    protected static function _OPTION($client,$option,$value) {
        curl_setopt($client,$option,$value);
    }

    protected function getPlogEntry() {
        $profil = $this->getProfil();
        $entry  = \R::findOne( 'plog','user = ? AND intid = ?',[$profil->getUser(),$profil->getIntid()]);
        
        if (!$entry) {
            $entry = \R::dispense('plog');
            $now   = new \DateTime("now");
            $entry->createdAt= $now;
            $entry->user     = $profil->getUser();
            $entry->intid    = $profil->getIntid();
        }
        return $entry;
    }

    protected function setStep($step) {
        $_SESSION["chgmdpAction"] = $step;
        $now                      = new \DateTime("now");
        $entry                    = $this->getPlogEntry();

        if ($step=="step4") {
            $entry->count = $entry->count + 1 ;
        }

        if ($step=="step4") {
            $ips   = explode(",",$entry->ips);
            $ips[] = $this->getIP();
            $entry->ips = implode(",",array_unique($ips));
        }
    
        
        $entry->step        = $step;
        $entry->modifiedAt  = $now;

        \R::store($entry);

        return $entry;
    }

    public function publicMdpAction(Request $request, Response $response, $args) {

        $params=[];

        return $this->ci["view"]->render($response, '@plog/public.html.twig',$params);
    }

    public function publicMdpNoPlogAction(Request $request, Response $response, $args) {

        $params=[];

        return $this->ci["view"]->render($response, '@plog/public-mdp.html.twig',$params);
    }

    public function publicMdpEpleAction(Request $request, Response $response, $args) {

        $params=[];

        return $this->ci["view"]->render($response, '@plog/public-eple.html.twig',$params);
    }

    public function mfaMessageAction(Request $request, Response $response, $args) { 
        $params=[];

        return $this->ci["view"]->render($response, '@plog/mfa.html.twig',$params);
    }


    public function chgmdpAction(Request $request, Response $response, $args) {
        $params= [];
        $now   = new \DateTime("now");
        $entry = $this->setStep("step1");
        $params["chgmdpAction"]   =  $_SESSION["chgmdpAction"];
        $params["entry"]          =  $entry;

        return $this->ci["view"]->render($response, '@plog/chgmdp.html.twig',$params);
    }

    public function nochgmdpAction(Request $request, Response $response, $args) {
        $params=[];
        // Action volontaire de ne pas changer son mot de passe
        if (isset($_SESSION["chgmdpAction"]) && $_SESSION["chgmdpAction"]== "step1") {
            $this->setStep("step2");
            $params["chgmdpAction"]   =  $_SESSION["chgmdpAction"];
            return $this->ci["view"]->render($response, '@plog/nochgmdp.html.twig',$params);
        }
        return $response->withRedirect($this->ci->get('router')->pathFor('hub')); 
    }

    public function nonochgmdpAction(Request $request, Response $response, $args) {
        $params=[];
        // Action volontaire de ne pas changer son mot de passe
        if (isset($_SESSION["chgmdpAction"]) && $_SESSION["chgmdpAction"]=="step2") {
            $this->setStep("step3");
            $params["chgmdpAction"]   =  $_SESSION["chgmdpAction"];
        }
        return $response->withRedirect($this->ci->get('router')->pathFor('hub'));
    }

    public function confirmnochgmdpAction(Request $request, Response $response, $args) {
        $params=[];
        // Action volontaire et confirmé de ne pas changer son mot de passe
        if (isset($_SESSION["chgmdpAction"]) && $_SESSION["chgmdpAction"]=="step2") {
            $this->setStep("step4");
            $params["chgmdpAction"]   =  $_SESSION["chgmdpAction"];
        }
        return $response->withRedirect($this->ci->get('router')->pathFor('hub'));
    }


    public function mdpAction(Request $request, Response $response, $args) {
        global $__PLUGINS;
        // On verifie que la conf existe
        if (!isset($__PLUGINS['plog']))              {
            return $response->withRedirect(self::$ELEVE_URL, 303);
        }

        $profil = $this->getProfil();
        $uid    = $profil->getUser();
        $source = $profil->getSource();

        if ($source != "ACADEMIQUE") {
            return $response->withRedirect(self::$PLOG_URL, 303);
        }

        /*$groupes = (isset($__PLUGINS['plog']['groupes']))?$__PLUGINS['plog']['groupes']:[];
        if (count($groupes)) {
            if ($profil->hasGroupes($groupes)) {
                return $response->withRedirect(self::$PLOG_URL, 303);
            }
        }*/

        return $response->withRedirect(self::$PLOG_URL, 303);

        //return $response->withRedirect(self::$MDP_URL, 303);


    }

    public function statusAction(Request $request, Response $response, $args) {

        global $__PLUGINS;
        // On verifie que la conf existe
        if (!isset($__PLUGINS['plog']))              {return $response->withJson(["success"=>false,"status"=>false,"nb"=>0]);}


        $profil = $this->getProfil();
        $uid    = $profil->getUser();
        $source = $profil->getSource();

        if ($source != "ACADEMIQUE") {
            return $response->withJson(["success"=>true,"status"=>"n/a"]);
        }

        $groupes = (isset($__PLUGINS['plog']['groupes']))?$__PLUGINS['plog']['groupes']:[];
        if (count($groupes)) {
            if (!$profil->hasGroupes($groupes)) {
                return $response->withJson(["success"=>true,"status"=>"n/a","message"=>"hors scope"]);
            }
        }

        $data = self::getPlogStatus($uid); 

        return $response->withJson($data);
    }

    public static function  getPlogStatus($uid) {
        global $__PLUGINS;

        $client = curl_init();
        self::_OPTION($client,CURLOPT_RETURNTRANSFER, false);
        self::_OPTION($client,CURLOPT_RETURNTRANSFER, true);
        self::_OPTION($client,CURLOPT_BINARYTRANSFER, true);
        self::_OPTION($client,CURLOPT_SSL_VERIFYPEER, false);
        self::_OPTION($client,CURLOPT_SSL_VERIFYHOST, false);
        self::_OPTION($client,CURLOPT_FOLLOWLOCATION, true);
        self::_OPTION($client,CURLOPT_CONNECTTIMEOUT ,0);
        self::_OPTION($client,CURLOPT_TIMEOUT, 60);
        self::_OPTION($client,CURLOPT_COOKIESESSION, true);
        self::_OPTION($client,CURLOPT_POST, 0);

        self::_OPTION($client,CURLOPT_URL, self::$baseUrl . "/api/getnbsolsec/" . $uid );
        $data = curl_exec ($client);
        $status= curl_getinfo($client,CURLINFO_HTTP_CODE);
        if ($status!="200") {
            return ["success"=>false,"status"=>$status,"nb"=>"0"];
        }

        $data   = trim($data);
        $status = "OK";
        if ($data == "{}") {$data="0";}
        if ($data == "0")  {$status="KO";}
        
        $message="";
        if (isset($__PLUGINS['plog']['message'])) {
            $message = $__PLUGINS['plog']['message'];
        }

        return ["success"=>true,"status"=>$status,"nb"=>$data,"message"=>$message];
    }

}
