// Extraction d'un noeud dans un flux xml
function xmlText(node,item) {return $(node).find(item).text()}
function xmlHtml(node,item) {return $(node).find(item).html()}

xdesktop={

createApp: function(attributs) {

    // Si pas de libelle ou pas de nom on ne va pas créer d'application
    attributs.libelle = attributs.libelle || attributs.nom

    if ( !attributs.libelle || !attributs.icon) return null;


   // Si url commence par / on préfix par l'url de l'établissement
   var urlBase=attributs.url
   if (attributs.url.indexOf("/")==0 && !attributs.source && attributs.etab ) {
       attributs.url="https://"+attributs.etab.url+attributs.url
   }

    // Si url commence par / on préfix par l'url de la source si elle existe
   if (attributs.url && attributs.url.indexOf("/")==0 && attributs.source && attributs.source.baseurl != undefined) {
        urlBase=attributs.url;
        attributs.url=attributs.source.baseurl+attributs.url;
   }

   if (!attributs.categorie) attributs.categorie=""
   attributs.categorie=attributs.categorie.normalize()

   if (!attributs.piwik_marker) {attributs.piwik_marker = "SANSCATEGORIE/"+attributs.libelle}

   app= new App({libelle:attributs.libelle,
           libellecours:attributs.libellecours || attributs.libelle,
           icon:attributs.icon,
           etab: attributs.etab,
           url:attributs.url,
           urlBase:urlBase,
           favurl:attributs.favurl || attributs.url,
           resarena:attributs.resarena,
           listesDesUrl:[],
           source:attributs.source,
           nom:attributs.nom,
           server:attributs.server,
           infos:attributs.infos,
           piwik_marker: attributs.piwik_marker,
           infosChecked:[],
           favoris:false,
           visible: true,
           hasBadge: false,
           external:attributs.external || false,
           categorie:attributs.categorie})
   return app;
},


extractAppFromXml: function(xml) {

    // Récupération des infos
    infos={url:xmlText(xml,'infos_url'),
           type:xmlText(xml,'infos_type'),
           message:xmlHtml(xml,'infos_message')}

     // Les balises & sont transformés en &amp; , on fait donc l'inverse
     if (infos.message!=undefined) infos.message=infos.message.replace( /\&amp;/g, '&' );
     if (infos.url!=undefined) infos.url=infos.url.replace( /\&amp;/g, '&' );

     categorie=xmlText(xml,'categoriename');
     nom=xmlText(xml,'nom')
     libelle=xmlText(xml,'libelle')
     piwik_marker=xmlText(xml,'piwik_marker')
     url=xmlText(xml,'url')
     favurl=xmlText(xml,'favurl') || url // Url pour stocker dans favoris
     resarena=xmlText(xml,'resarena')
     libellecours=xmlText(xml,'libellecours') || libelle;

     if (url == 'nonAccessible' ) {
         return null;
     }

     nom=nom || libelle
     if (nom==undefined) nom="Aucun nom";

     // Determine la categorie a partir du nom (cf ancienne nomenclature)
     if ((categorie==undefined || categorie=="") && nom.indexOf("/")!=-1) {
                categorie=nom.split("/")[0];
                libelle=nom.split("/")[1];
                if (libelle=="") libelle=categorie
     }

     return  {
                 libelle:libelle,
                 libellecours:libellecours,
                 icon:xmlText(xml,'icon'),
                 server:xmlText(xml,'server'),
                 baseurl:xmlText(xml,'baseurl'),
                 url:url,
                 hidden:xmlText(xml,'hidden'),
                 external:xmlText(xml,'external')=="true",
                 nom:nom,
                 piwik_marker:piwik_marker,
                 favurl:favurl,resarena:resarena,
                 infos:infos,
                 infosChecked:[],
                 favoris:false,
                 categorie:categorie.normalize()}
     }


}
