<?php

$CORRESPONDANCE_GENXML = [
    "Scolarité du 1er degré" => "Élèves",
    "Scolarité du 2nd degré" => "Élèves",
    "Gestion des personnels" => "Structure et personnels",
    "Formation et Ressources" => "Espace personnel",
    "Outils" => "Ressources et outils",
    "Intranet, Référentiels et Outils" => "Ressources et outils",
    "Enquêtes et Pilotage" => "Enquêtes et signalements",
    "Examens et concours" => "Élèves",
    "Gestion de la Paie" => "Structure et personnels",
    "Administration financière et comptable" => "Structure et personnels",
];

$URL_TO_HIDE = [
    "https://accueil.in.ac-reunion.fr:443/redirectionhub/redirect.jsp?applicationname=filesender_renater_in" => true,
    "https://accueil.in.ac-reunion.fr:443/redirectionhub/redirect.jsp?applicationname=folios_in" => true ,
    "https://accueil.in.ac-reunion.fr:443/nextcloud/"   => true
];


function getGenXmlFromCsv() {

    $data = [];
    $data2 = [];
    if (!isset($_SESSION['genxml_data_extra3'])) {

        $csvFile = fopen(__DIR__ . "/../include/genxml2.csv", 'r');
        if ($csvFile !== false) {
            // Lire la première ligne comme en-têtes (optionnel)
            $headers = fgetcsv($csvFile);

            while (($row = fgetcsv($csvFile)) !== false) {
                $data[$row[3]] = array_combine($headers, $row);


                if (strpos($row[3],"applicationname=") !== false) {
                    $aurl=explode("=",$row[3]);
                    $app=explode("_",$aurl[1]);
                    $data2[$app[0]] =  $data[$row[3]];
                }



            }

            fclose($csvFile);

            $_SESSION['genxml_data'] = $data;
            $_SESSION['genxml_data_extra3'] = $data2;
            $_SESSION['genxml_parsed'] = true;
        }
    } else {
        $data = $_SESSION['genxml_data'];
    }

    return $data;
}

function getGenXmlFromCsvExtra() {

    if (!isset($_SESSION['genxml_data_extra3'])) {
        getGenXmlFromCsv();
    }
    return $_SESSION['genxml_data_extra3'];
}

function updateCategories()
{
    global $CORRESPONDANCE_GENXML;
    global $categories;


    $result = [];
    foreach ($categories as $category) {

        if (isset($CORRESPONDANCE_GENXML[$category->nom])) {
            $category->nom = $CORRESPONDANCE_GENXML[$category->nom];
        }

        $result[] = $category;

    }

    return $result;
}

function renameDomaineFromUrl($url,$domaine="") {
    $data = getGenXmlFromCsv();

    // L'url est dans le tableau des correspondances genxml
    if (isset($data[$url])) {
        return $data[$url]['Domaine'];
    }

    $data2 = getGenXmlFromCsvExtra();

    // L'url est dans le tableau des correspondances genxml
    if (isset($data2[$url])) {
        return $data2[$url]['Domaine'];
    }

    // On va regarder si c'est dans la correspondance des domaines
    global $CORRESPONDANCE_GENXML;
    if (isset($CORRESPONDANCE_GENXML[$domaine])) {
        return $CORRESPONDANCE_GENXML[$domaine];
    }

    return $domaine;
}

function getDataFromGenXML2($url) {
    $data = getGenXmlFromCsv();

    // L'url est dans le tableau des correspondances genxml
    if (isset($data[$url])) {
        return $data[$url];
    }


    return null;
}

function hideUrl($url)
{
    global $URL_TO_HIDE;
    return isset($URL_TO_HIDE[$url]);
}

