<?php

namespace Edispatcher\Bot;

use GuzzleHttp\Client as GuzzleClient;

class RocketchatClient
{

    const HOOK_URI = '/hooks';

    /**
     * @var string The server to connect to.
     */
    private $server;

    /**
     * @var string The token for the webhook.
     */
    private $token;


    /**
     * @var string Option pour http.
     */
    private $httpOptions;

    /**
     * Client constructor.
     * @param string $server
     * @param string $token
     */
    public function __construct($server, $token)
    {
        $this->server = $server;
        $this->token = $token;
        $this->httpSettings= [];
    }

    public function setHttpOptions($options) {
      $this->httpOptions=$options;
    }

    /**
     * Sends a payload to the server.
     * @param array $payload
     */
    public function payload(array $payload)
    {

        $config=$this->httpOptions;
        $config['base_uri'] = $this->server;


        $client = new GuzzleClient($config);
        return $client->post( $this->getUri(), [
            'form_params' => [
                'payload' => json_encode($payload)
            ]
        ]);
    }

    /**
     * Returns the webhook URI.
     * @return string
     */
    private function getUri()
    {
        return sprintf('%s/%s', self::HOOK_URI, $this->token);
    }
}
