String.prototype.normalize = function () {
    return this.replace(/[^a-zA-Z0-9 \s]/g,'');
};

String.prototype.ColorLuminance = function(lum) {

	// validate hex string
	hex = this.replace(/[^0-9a-f]/gi, '');
	if (hex.length < 6) {
		hex = hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2];
	}
	lum = lum || 0;

	// convert to decimal and change luminosity
	var rgb = "#", c, i;
	for (i = 0; i < 3; i++) {
		c = parseInt(hex.substr(i*2,2), 16);
		c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
		rgb += ("00"+c).substr(c.length);
	}

	return rgb;
}

function shadeColor2(color, percent) {
    if (!color) return "white";
    var f=parseInt(color.slice(1),16),t=percent<0?0:255,p=percent<0?percent*-1:percent,R=f>>16,G=f>>8&0x00FF,B=f&0x0000FF;
    return "#"+(0x1000000+(Math.round((t-R)*p)+R)*0x10000+(Math.round((t-G)*p)+G)*0x100+(Math.round((t-B)*p)+B)).toString(16).slice(1);
}


_BOOKMARK_ADD="BOOKMARK_ADD";
_BOOKMARK_DEL="BOOKMARK_DEL";

// ===== APP =================================================================================

function App(data) {
    for (key in data) {
        this[key]=data[key];
    }
    this.others=[];
    this.hasOthers=false;
    this.isSubApp=false;
    this.favoris=false;
    this.isHidden=false;
    this.nbFavUrl = 0;
    this.tags = []

    // ref #25844 ByPasser la réorg
    this.gestionLocal = this.url.indexOf("gestion_edispatcher=local")!=-1;
    this.iconeLocal   = this.url.indexOf("icone=local")!=-1;

    // Normalisation des URL
    this.url      = this.normalizeUrl(this.url)
    this.favurl   = this.normalizeUrl(this.favurl)
    this.urlBase  = this.normalizeUrl(this.urlBase)

    // ref #19908 use etab.url for id of app ( app avec même url /grr par ex )
    var u=this.url
    if (this.etab) u=this.etab.url+this.url
    this.id="Z"+md5(u);
    this.key = this.id

    if (__ZONES[this.server]) {
        this.oZone=__ZONES[this.server]
        this.oZone.nbApps++
    }

    if (!this.icon.startsWith("http") && !this.icon.startsWith("//")) {
        if (this.etab) {
           this.icon=this.etab.getSchemeAndHost()+this.icon;
        }
    }

    if (this.etab) {
        this.etab.nbApps++;
    }

    /*if (!this.description) {
         var lorem = new Lorem;
         lorem.query="10-15w"
         this.description=lorem.createLorem();
    }*/

    this.setLibelle(this.libelle || "")

    this.nom             = this.nom || ""
    this.description     = this.description || ""
    this.color           = false

    if (_CONFIG["samples/x25_hidden_apps"]) {
        this.isHidden = _CONFIG["samples/x25_hidden_apps"]["hide."+this.favurl] ? true : false;
        let style     = _CONFIG["samples/x25_hidden_apps"]["style."+this.favurl]
        if (style) {
            this.color = style.color
        }
    } else {
        this.isHidden = false;
    }



    this.x25 = __TEMPLATE.indexOf("samples/x25") !== -1





}

// Enleve les specificités sur l'url
App.prototype.normalizeUrl = function(url) {
  if (!url) return url;
  if (this.etab && this.etab.ninegate) {return url;}
  return url.replace("icone=locale","")
            .replace("icone=local","")
            .replace("gestion_edispatcher=locale","")
            .replace("gestion_edispatcher=local","")
}

App.prototype.toogleHidden = function() {
    this.isHidden = !this.isHidden;
}

App.prototype.setLibelle = function(libelle) {
  if (libelle.indexOf("<span") == -1 ) {
    this.libelle = "<span class='app-libelle'>" + libelle + "</span>";
  } else {
    this.libelle = libelle;
  }

  this.libelleLower    = $(this.libelle.toLowerCase()).text();
}



App.prototype.open=function() {

  // Piwik tracker
  $iframe=$("#iframePiwik")
  if ($iframe.length==0) {
      $iframe=$("<iframe>").css("display","none").attr("id","iframePiwik");
      $("body").append($iframe);
  }

  var details = "";
  if (this.refid && this.urlid) {
      details="&appid="+this.refid+"&urlid="+this.urlid
  }

  // Parametre pour un piwik global
  var uaj    = "GLOBAL"
  var portal = $('<a>').prop('href', _HOST).prop('hostname')

  // Ressource de l'établissement
  if (this.etab && this.etab.uaj) {
      uaj    =  this.etab.uaj
      portal =  this.etab.url
  }
  // Sinon UAJ est défini, on va l'utiliser ( App académique )
  else if (typeof __UAJ  != "undefined" && __UAJ) {
      uaj   = __UAJ
      portal= $("edispatcher-etab[uaj='"+__UAJ+"']").attr("url")
  }

  // Log PIWIK
  // suppression du http[s]://
  if (portal.indexOf("http")==0) {
    portal = portal.split("://")[1];
  }
  // suppression du path si il y en a
  if (portal.indexOf("/")!=-1) {
    portal = portal.split("/")[0];
  }

  // Pas d'url de piwik , on va utiliser celle de edispatcher
  if (!_PIWIK_URL && _EDISPATCHER) {
    _PIWIK_URL = _EDISPATCHER + "/ng/piwik";
  }

  // Pas de portail
  if (!portal) {
    $iframe.attr("src",_PIWIK_URL+"/academique?name="+this.piwik_marker+details);
  } else {
    $iframe.attr("src",_PIWIK_URL+"/"+uaj+"/"+portal+"?name="+this.piwik_marker+details);
  }

  

  var self = this
  var name = this.key;

  if (this.wnd) {
    this.wnd.focus();
  } else {

    if (this.oZone && this.oZone.libelle) {
      let service = "scoweb" 
      fedeLink=_SSO+'/saml?sp_ident='+service+'&RelayState='  + encodeURIComponent(this.getUrl())+"&css=federation_"+_PROFIL
      console.log("OPEN FEDE " + fedeLink )
      this.wnd = window.open(fedeLink,name);
    } else {
      this.wnd = window.open(this.getUrl(),name);
    }


    
    $("edispatcher-applications-opened").trigger("edispatcher_app_opened",{app:this});
    this.checkCloseInterval= setInterval(function(app){
      if ( (app.wnd && app.wnd.closed) || (!app.wnd)) {
        app.checkInfos();
          $("edispatcher-applications-opened").trigger("edispatcher_app_closed",{app:app});
        app.wnd = null;
        clearInterval(app.checkCloseInterval);
      }
    },3000,this)
  }

}

App.prototype.export=function() {
  var data = {
    "libelle": $(this.libelle).text(),
    "libelleComplet": this.libelle,
    "icon":    this.icon,
    "uaj":     this.etab?this.etab.uaj:"",
    "portal":  this.etab?this.etab.url:"",
    "id" :     this.id,
    "favoris": this.favoris?"yes":"no",
    "resarena": this.resarena || "",
    "ssdomaine": this.ssdomaine || "",
    "url":     this.getUrl(),
    "infosUrl": (this.infos && this.infos.url)?this.infos.url:"",
    "categorie" : this.oCategorie?this.oCategorie.key:"",
  }

  if (this.source && this.source.url ) {
    data.source = this.source.url;
  }

  if (this.oZone) {
    data.zone = this.oZone.name;
  }

  return data;

}

App.prototype.getUrl = function() {
  // url ne commencant pas par http avec une source.url 
  if ( (this.url.indexOf("http")!=0) && (this.source) && (this.source.url) ) {
    return "https://" + this.source.url + this.url;
  }
   // url ne commencant pas par http de type etab
  if ( (this.url.indexOf("http")!=0) && (this.etab) && (this.etab.url) ) {
    var hostname =  this.etab.url
    // portail etab qui commence par http => on essaie de récupèrer le hostname 
    if (this.etab.url.indexOf("http")==0) {
      try {
        var u=new URL(this.etab.url); 
        hostname = u.hostname
      } catch(e) {}
    }
    return "https://" + hostname + this.url;
  }

  return this.url;
}

App.prototype.checkInfos=function() {
  if (this.infos==undefined  || this.infos.url==undefined || this.infos.url=="")
  {
    return
  }

  if (this.infos.url.indexOf(":")!=0 ) {
    var self=this;
    setTimeout(function(){self.loadInfosFromUrl()},10);
  } else {

  }
}


App.prototype.loadInfosFromUrl=function() {


  // Check déja effectué il y a moins de 10s, on ne fait rien
  if (eStorage.get("check_"+this.id,10*EStorage.SECONDS)) {
    //console.log("CheckInfos : "+this.infos.url +" => already send, nothing todo")
    return;
  }
  //console.log("CheckInfos : "+this.infos.url)
  eStorage.set("check_"+this.id,true);

  var app=this
  //a=window.location.href.split("/");a[a.length-1]="callback.php";
  var callbackUrl=_CALLBACK_URL;
  sep="?"
  if (app.infos.url.indexOf("?")!=-1) sep="&"

  if (!app.source) {
      console.log(" => app with no source ???")
      console.error(app);
      return;
  }



  if (app.infos.url.indexOf("http")!=0) {
     if (app.etab) app.infos.url=app.etab.getSchemeAndHost()+app.infos.url;
     else app.infos.url=app.source.getSchemeAndHost()+app.infos.url;
  }

  if (app.infos.url.indexOf(_EDISPATCHER)!=0) {
    services=_FEDERATION+encodeURIComponent(app.infos.url+sep+"callback="+callbackUrl+"&id="+app.id);
  } else {
    services=app.infos.url+sep+"callback="+callbackUrl+"&id="+app.id;
  }
  //console.log(" => with service "+services)

  iframe=$('<iframe id="ipFrame'+app.id+'" src="'+services+'" width=0 height=0 style="display:none;"></iframe>');
  iframe.attr("appid",app.id)
  $("body").append(iframe)
  try {
      var event = new CustomEvent("startinfosplusEvent", {detail: {id: app.id,app:app}});
      window.document.dispatchEvent(event);
  } catch (e) {}

  /*iframe.load(function() {
      appid=$(this).attr("appid")
      var event = new CustomEvent("stopinfosplusEvent",
    {
      detail: {id: appid},
      bubbles: true,
      cancelable: true
    });
      window.document.dispatchEvent(event);
  })*/
}

App.prototype.match=function(search) {
    var reg=new RegExp(search, "i");
    return this.libelle.search(reg)!=-1     ||
           this.nom.search(reg)!=-1         ||
           this.ssdomaine.search(reg)!=-1  ||
           this.description.search(reg)!=-1

}

App.prototype.toggleFavoris=function(source) {
    if (!this.etab) return ;
    this.etab.toggleFavoris(this,source);
}

App.prototype.json=function() {
    return {id:this.id,libelle:$(this.libelle).text(),icon:this.icon,
            favurl:encodeURIComponent(this.favurl),url:encodeURIComponent(this.url),nom:this.nom,
            categorie:this.categorie}
}

App.prototype.matchUrl=function(url) {

    if (!url || url.length<3) return false;

    if (this.url.indexOf(url)!=-1) {
        return true
    }
    return false
}


// ============================================================================================

function Categorie(data) {
  for (key in data) {
      this[key]=data[key];
  }
  this.apps= [];
  this.maximized=false;
  this.id=md5(this.key)

}

Categorie.prototype.export=function() {
  return {
    key: this.key
  }
}

Categorie.prototype.info=function() {
  return {
    name: this.name,
    color: this.color,
    indice: this.indice,
    icone: this.icone
  }
}

// Chargement de la configuration
Categorie.prototype.addApp=function(app) {
  this.apps.push(app);
}

Categorie.prototype.comp=function(b) {
     return this.indice>b.indice?1:this.indice<b.indice?-1:this.name.localeCompare(b.name);
}

Categorie.prototype.hasApps=function() {
  return this.apps.length>0;
}
