<?php

// Classe de Base
class Model_First extends RedBean_SimpleModel {

    public static $RIGHT_FORBIDEN=0;
    public static $RIGHT_READ=100;
    public static $RIGHT_WRITE=200;
    public static $RIGHT_EDIT=300;
    public static $RIGHT_DELETE=400;

    public $rights="[]";

    public function isContextuable() {return false;}

     public function isOwner() {
        if (!$this->user) $this->user=USER();
        return $this->user->id==USER()->id;
    }

    public function isEditable() {
        return ($this->isOwner() || USER()->isAdmin());
    }

    public function isDeletable() {
        return ($this->isOwner() || USER()->isAdmin()) ;
    }

    public function isVisible() {
        return ($this->isOwner() || USER()->isAdmin()) ;
    }

    public function importProperty($data,$prop,$boolean=false) {
        if (property_exists($data, $prop)) {
            $this->{$prop}=$data->{$prop};
            if ($boolean) $this->{$prop}=(boolean)$data->{$prop};
        }
    }

    public function isLocked() {return ($this->locked!=null)?$this->locked:false;}

    public function hasRight($val) {
        global $config;
        $bContextOK=true;

        // Pas de user encore, par défaut c'est admin
        if (!$this->user) { return true; }

        // Si l'item dispose d'un contexte, on va vérifier que le contexte est dispo pour
        // le USER
        if ($this->isContextuable() && is_array($this->sharedContextList)) {
            $bContextOK=false;
            foreach ($this->sharedContext as $context)
            {
               if ($context->tag=="GLOBAL" || USER()->hasContext($context)) {
                 $bContextOK=true;
                 break;
               }
            }
        }

        // Context non OK -> return false
        if (!$bContextOK)               {return false;}

        if ($this->isOwner() || USER()->isAdmin())          return true;

        // Pas de droit positionné rettourne true si on vérifie les droits en lecture , faut sinon
        // (Si aucun droit positionné par défaut c'est visible)
        if (!is_array($this->rights))   {return $val==self::$RIGHT_READ;}
        if (count($this->rights)==0 )   {return $val==self::$RIGHT_READ;}

        // Pour chacun des droits on vérifie si le USER a le profil associé
        foreach ($this->rights as $right) {
            if (USER()->hasProfil($right->{'profil'})) {
                return intval($right->{'right'})>=$val  ;
            }
        }
        return $val==self::$RIGHT_READ;
    }

    public function checkAction($data) {
        if (property_exists($data, 'action')) {
            if ($data->{'action'} == "delete" && $this->isDeletable() ) {
                R::trash($this);
                return false;
            }
        }

        return true;
    }

    public function importAutorisations($data) {
        if (property_exists($data, 'rights')) {
            $autorisations=array();
            $a=Model_Base::RIGHTS();
            foreach($data->{'rights'} as $r) {
                $profil= R::findOne('profil', 'tag = ?',array($r->{'profil'}));
                if (!$profil) continue;
                $right=$a[$r->{'right'}];
                $autorisations[]=array("profil"=>$profil->id,"right"=>$right);
            }
            $this->autorisations=json_encode($autorisations);
        }

        if ($this->isContextuable() && property_exists($data, 'contexts')) {

        }

        // Lors d'une importation lock la donnée, sauf si locked est precisé
        // évite la modification par l'ui
        if (property_exists($data, 'locked')) {
            $this->locked=(boolean)$data->{'locked'};
        } else {
            $this->locked=true;
        }

    }

    public function open(){
           $this->rights=json_decode($this->autorisations);
           if (!$this->user) {
               $this->user=ADMIN();
           }
    }

    public function update(){
            if (!$this->user)       $this->user=USER();
            if (!$this->created)    $this->created=new DateTime("now");
            if (!$this->updated)    $this->created=$this->created;

            // Supprime tous les caractères spéciaux du tag
            // ne garde que les chiffres et lettres
            if ($this->tag) {
                $this->tag = normalizeTag($this->tag);
            }

            // On met a jour la date de modification si la ressource n'est pas locké
            // si locké, il est impossible de mettre a jour depuis l'interface web
            // donc si locké cela vient d'une importation CLI, il ne s'agit donc pas d'un
            // update
            if (!$this->isLocked() || !$this->updated) {
                $this->updated=new DateTime("now");
            }

            if (!$this->description)$this->description="Aucune description";

            // Si est contextuable, et pas de context on va en ajouter un
            if ($this->isContextuable() && count($this->sharedContext)==0) {
                $arr=USER()->getContext();
                if (count($arr)!=0) {
                     $this->sharedContextList=array($arr[0]);
                }
                else $this->sharedContextList=array(GLOBAL_CONTEXT());
            }
    }

}


class Model_Base extends Model_First {




    public $profil=array();
    public $cas=array();

    // Attention : Pour le moment la cohérence id<->libelle avec le client
    // doit se faire manuellement dans le fichier profils.js
    public static function RIGHTS()
    {
        return array("DENY"=>self::$RIGHT_FORBIDEN,
                     "READ"=>self::$RIGHT_READ,
                     "WRITE"=>self::$RIGHT_WRITE,
                     "EDIT"=>self::$RIGHT_EDIT,
                     "DELETE"=>self::$RIGHT_DELETE);
    }



    public function getContext() {
        $arr=array();
        if (is_array($this->sharedContext))
        {
            foreach ($this->sharedContext as $context)
            {
                $arr[]=$context->json();
            }
        }else
        {
            $arr[]=GLOBAL_CONTEXT();
        }
        return $arr;
    }

    public function json() {

         // export des caractéristiques générales
         $a=array("id"=>$this->id,"name"=>$this->name,"description"=>$this->description,
                    "autorisations"=>$this->autorisations,"context"=>$this->getArrContext(),
                    "tag"=>$this->tag,
                    "locked"=>$this->isLocked(),
                    "writable"=>$this->isWritable(),
                    "deletable"=>$this->isDeletable(),
                    "editable"=>$this->isEditable());
         if ($this->user) $a["user"]=$this->user->json();

        // récupération de la date de modification
        $d=new DateTime($this->updated);
        $st=$d->getTimestamp();
        $a["timestamp"]=$st;
        $a["since"]=TIMESTAMP()-$st;
        $a["iso8601"]=$d->format('c');

         return $a;

    }

    function getArrContext() {
        $ret=array();
        if (is_array($this->sharedContext)) {
            foreach ($this->sharedContext as $c){$ret[]=$c->json();}
        }
        return $ret;

    }

    public function dispense(){
           $this->name="";
           $this->description="";
    }




    public function isEditable()  {return $this->hasRight(self::$RIGHT_EDIT);}
    public function isVisible()   {return $this->hasRight(self::$RIGHT_READ);}
    public function isWritable()  {return $this->hasRight(self::$RIGHT_WRITE);}
    public function isDeletable() {return $this->hasRight(self::$RIGHT_DELETE);}

}




// ======
class Model_Eval extends Model_Base {

    public function json() {

        $arr=array();
        $arr["id"]=$this->id;
        $arr["comment"]=$this->comment;
        $arr["user"]=$this->user->fullname;
        $arr["vote"]=$this->vote;
        $d=new DateTime($this->created);
        $st=$d->getTimestamp();
        $arr["created"]=strftime("%A %e %B %Y à %H:%M",$st);
        return $arr;
    }

    public function update() {
        $this->created=new DateTime("now");
        if (!$this->user) $this->user=USER();
    }

}

class Model_Category extends Model_First {

    public static function import($datas,$app) {

        $app->requireAdmin();

        foreach ($datas as $data)
        {
            echo $data->{'tag'};
            $category= $app->createIfNotExist('category',$data->{'tag'});
            if (!$category->checkAction($data)) continue;
            $category->tag=$data->{'tag'};
            $category->name=$data->{'name'};
            $category->importProperty($data,'color');
            R::store($category);
        }
    }

    public function json() {
        $arr=array();
        $arr["id"]=$this->id;
        $arr["tag"]=$this->tag;
        $arr["name"]=$this->name;
        $arr["color"]=$this->color?$this->color:"#000";
        return $arr;
    }


    public function isVisible() {
       return true;
    }

}

// ======
class Model_Catalogue extends Model_Base {

    public function isContextuable() {return true;}

    public static function import($datas,$app) {
        foreach ($datas as $data)
        {
                $catalogue = R::findOne('catalogue', 'tag = ?',array(normalizeTag($data->{'tag'})));
                if (!$catalogue) {
                    $app->requireAdmin();
                    $catalogue=R::dispense('catalogue');
                    $catalogue->tag=$data->{'tag'};
                }

                if (!$catalogue->checkAction($data)) continue;

                if (!$catalogue->isEditable()) {
                    $app->info("catalogue tag=".$catalogue->tag." non editable");
                    continue;
                }

                $catalogue->name=$data->{'name'};
                $catalogue->description=$data->{'description'};

                $catalogue->importAutorisations($data);

                R::store($catalogue);
        }
    }

    public function json() {
        $a=parent::json();
        try {
            $a["recordsTotal"]=$this->bean->countOwn( 'ressource' );
        } catch (Exception $e) {}
        return $a;
    }
}

class Model_Parameter extends Model_Base {

    public function json() {
        $a=parent::json();
        $a["value"]=$this->value;
        return $a;
    }

    public static function get($name,$default) {
        $parameter = R::findOne('parameter', 'name = ?',array($name));
        if (! $parameter ) {  return $default ;}
        return $parameter->value;
    }

    public static function set($name,$value) {
        $parameter = R::findOne('parameter', 'name = ?',array($name));
        if (! $parameter )               {
            $parameter=R::dispense('parameter');
            $parameter->tag=$name;
            $parameter->name=$name;
        }
        $parameter->value=$value;
        R::store($parameter);
    }

}

class Model_Context extends RedBean_SimpleModel {

    public function json() {
        $a=array();
        $a["id"]=$this->id;
        $a["name"]=$this->name;
        $a["tag"]=$this->tag;
        return $a;
    }

     public function isVisible() {
        if ($this->tag==GLOBAL_CONTEXT()->tag) return true;

        return USER()->hasContext($this);
    }

}


// ======
class Model_Ressource extends Model_Base {

    public static $LOGO_PATH="../logos/";

    public static function import($datas,$app) {
        if (!is_array($datas)) {
            $app->sendError("Format de données incorrect");
        }
        $all=array();
        foreach ($datas as $data)
        {
                $ressource = R::findOne('ressource', 'tag = ?',array(normalizeTag($data->{'tag'})));
                if (!$ressource) {
                    $ressource=R::dispense('ressource');
                    $ressource->actif=false;
                }
                if (!$ressource->isEditable()) continue;
                $ressource->tag=$data->{'tag'};
                $ressource->name=$data->{'name'};
                $ressource->url=$data->{'url'};

                $ressource->importProperty($data,'description');
                $ressource->importProperty($data,'note');
                $ressource->importProperty($data,'subscribe');
                $ressource->importProperty($data,'actif',true);

                $ressource->importAutorisations($data);


                if (!$ressource->importProperty($data,'logo')) {
                    if (file_exists(self::$LOGO_PATH.$ressource->tag.".png")) {
                       $ressource->logo=$ressource->tag.".png";
                    }
                }

                $ressource->importProperty($data,'urlaccess');

                if (property_exists($data, 'ressource')) {
                    $ressourceDep = $app->mustExistAndVisible('ressource',$data->{'ressource'});
                    $ressource->ressource=$ressourceDep;
                }

                $catalogue=null;
                if (property_exists($data, 'catalogue')) {
                    $catalogue = $app->mustExistAndWritable('catalogue',$data->{'catalogue'});
                    $ressource->catalogue=$catalogue;
                }

                if (property_exists($data, 'category')) {
                    $category = $app->mustExistAndVisible('category',$data->{'category'});
                    $ressource->category=$category;
                }

                if (property_exists($data, 'sso_attr')) {
                    $ressource->sso_attr=$data->{'sso_attr'};
                } else {
                    $ressource->sso_attr=" ";
                }

                R::store($ressource);

                if (property_exists($data, 'library')) {
                    $library = $app->mustExistAndWritable('library',$data->{'library'});
                    $ressource->instantiate($library,$app);
                }

                /*if ($catalogue) {
                    $catalogue->ownRessourceList[]=$ressource;
                    R::store($catalogue);
                }*/
        }
    }


    public function dispense(){
           parent::dispense();
           $this->icon="";
           $this->url="http://";
    }

    public function hasSso() {
        return   $this->sso_attr != null && trim($this->sso_attr)!="";
    }

    public function isActif() {
        return $this->actif;
    }

    public function isVisible() {
        if (!$this->actif && ! USER()->isAdmin()) {return false;}
        return parent::isVisible();
    }

    public function sso() {
        $tag=$this->tag;

        list($error,$url,$message,$arrCode)=$this->getAccessUrl();;
        if ($error) return null;

        if (!$url) $url= $this->url;
        $url=str_replace("https://".PARAM("SERVEUR_SSO","").":".PARAM("PORT_SSO","")."/?service=","",$url);
        $url=urldecode($url);
        $parse = parse_url($url);

        $a=array("name"=>$tag,
                        "baseurl"=>($parse["path"]!=null)?$parse["path"]:"/",
                        "scheme"=>"both",
                        "addr"=>$parse["host"],
                        "typeaddr"=>"dns",
                        "filter"=>$this->sso_attr);
        return $a;

    }

    public function json() {
        $a=parent::json();
        $a["logo"]=$this->getLogoUrl();
        if (!$this->urlaccess) $this->urlaccess=$this->url;
        $a["urlaccess"]=$this->urlaccess;
        list($error,$urlaccess,$message,$arrCode)=$this->getAccessUrl();
        $a["urlaccess_eval"]=$urlaccess;
        $a["error"]=$error;
        if ($this->actif==null) $this->actif=false;
        $a["actif"]=$this->actif;
        $a["msgerror"]=$message;
        $a["sso_attr"]=$this->sso_attr;
        $a["code_in_error"]=$arrCode;
        $a["url"]=$this->url;
        $a["subscribe"]=($this->subscribe!=null)?$this->subscribe:false;
        if ($this->catalogue) $a["catalogue_id"]=$this->catalogue->id;
        if ($this->ressource) $a["ressource_id"]=$this->ressource->id;
        if ($this->category)  $a["category_id"]=$this->category->id;

        // Si la ressource est lié a une autre
        if ($this->ressource) {
            list($err,$ressource_urlaccess,$m,$c)=$this->ressource->getAccessUrl();
            if (!$err) {
                $a["ressource_urlaccess"]=$ressource_urlaccess;
                $a["ressource_name"]=$this->ressource->tag;
                $a["ressource_url"]=$this->ressource->url;
                $a["ressource"]=$this->ressource->id;
            }
        }

        $a["count"]=intval($this->count);
        $a["points"]=intval($this->points);
        if ($a["count"]!=0)
            $a["rate"]=$a["points"]/$a["count"];
        else
            $a["rate"]=0;

        return $a;
    }

    public function getLogoUrl() {
        $d=new DateTime($this->updated);
        $st=$d->getTimestamp();
        return "api/ressource/logo/".$this->id."/".$st;
    }

    public function instantiate($library,$app,$params=null) {
        // Vérification des droits d'accès sur la library
        if (! $library || ! $library->isWritable() )
        { $app->sendError("Bibliothèque #${library_id} introuvable où droit insuffisant pour y ajouter des ressources"); }

        $all = R::find( 'instance', ' ressource_id = ? and library_id = ? ', array( $this->id,$library->id ) );
        if (count($all)!=0) return null;

        // Mise à jour de l'instance
        $instance=R::dispense("instance");
        $instance->ressource=$this;

        // Mise a jour des paramètres
        if ($app->request()->post("params")) {
            $instance->params=json_encode($app->request()->post("params"));
        } else if ($params != null )
        {
           $instance->params=json_encode( $params );
        } else
        {
           $instance->params=json_encode(array());
        }
        R::store($instance);


        // Ajout de l'instance dans la library
        $library->ownInstanceList[] = $instance;
        R::store($library);

        return $instance;
    }

    public function getAccessUrl() {
            $urlaccess=$this->url;
            if ($this->urlaccess) {
                $urlaccess=$this->urlaccess;
            }

            // Remplacement des paramètres
            $message="";$bError=false;$arrCode=array();
            $pattern = '/\[(.*?)\]/';
            preg_match_all($pattern, $urlaccess, $matches, PREG_OFFSET_CAPTURE);
            foreach($matches[1] as $match) {
                $pat=$match[0];
                $param= R::findOne('parameter', 'name = ?',array($pat));
                if ($param) $urlaccess=str_replace("[$pat]",$param->value,$urlaccess);
                else {$bError=true;$message="$message $pat:non renseigné<br/>";$arrCode[]=$pat;}
            }

            return array($bError,$urlaccess,$message,$arrCode);

    }
}

// ======
class Model_Instance extends Model_Base {


   public function json() {
        $a=parent::json();
        $ressource=$this->ressource;

        $a["logo"]=$ressource->getLogoUrl();
        $a["name"]=$ressource->name;
        $a["ress"]=$ressource->id;
        $a["library"]=$this->library->id;
        $a["libraryName"]=$this->library->name;
        $a["score"]= 0;
        $a["description"]=$ressource->description;
        if ($ressource->catalogue) {
            $a["catalogue"]=$ressource->catalogue->id;
        }
        if ($ressource->category) {
            $a["category"]=$ressource->category->id;
        } else
        {
            $a["category"]=CATEGORY_NONE()->id;
        }

        $url=$ressource->url;
        list($error,$urlaccess,$message,$arrCode)=$ressource->getAccessUrl();;
        $a["error"]=$error;
        $a["msgerror"]=$message;

        // Si la ressource est lié a une autre
        if ($ressource->ressource) {
            list($err,$ressource_urlaccess,$m,$c)=$ressource->ressource->getAccessUrl();
            if (!$err) {
                $a["ressource_urlaccess"]=$ressource_urlaccess;
                $a["ressource_name"]=$ressource->ressource->tag;
                $a["ressource"]=$ressource->ressource->id;
            }
        }

        $a["count"]=intval($this->count);
        $a["points"]=intval($this->points);
        if ($a["count"]!=0)
            $a["rate"]=$a["points"]/$a["count"];
        else
            $a["rate"]=0;

        $a["access"]=intval($this->access);

        // Si il s'agit d'une url paramétrée, on va renseigner les paramètres
        $params=json_decode($this->params);
        if ($ressource->urlaccess && is_array($params)) {
            foreach ($params as $param) {
                $urlaccess=str_replace("(".$param->{'libelle'}.")",$param->{'valeur'},$urlaccess);
            }
            $a["params"]=$params;
        }

        $a["url"]=$url;
        $a["urlaccess"]=$urlaccess;
        return $a;
    }

    /*public function isEditable() {
        return true;
    }*/
}

// ======
class Model_Library extends Model_Base {

    public function isContextuable() {return true;}

    public static $FLAG_PERSONEL='P';
    public static $FLAG_CONTEXT='C';

    public static function import($datas,$app) {
        foreach ($datas as $data)
        {
            $library = R::findOne('library', 'tag = ?',array(normalizeTag($data->{'tag'})));
            if (!$library)               {$library=R::dispense('library');   }
            if (!$library->isEditable()) continue;
            $library->tag=$data->{'tag'};
            $library->name=$data->{'name'};
            $library->description=$data->{'description'};
            R::store($library);
        }
    }

    public function isDeletable() {
        if ($this->flag==self::$FLAG_PERSONEL && $this->isOwner()) return false;
        if ($this->flag==self::$FLAG_PERSONEL)                     return USER()->isAdministrateur();
        return parent::isDeletable();
    }

    public function isVisible() {
        if ($this->flag==self::$FLAG_PERSONEL) {
            return  $this->isOwner();
        }
        return parent::isVisible();
    }

    public function isWritable() {
        if ($this->flag==self::$FLAG_PERSONEL) {
            return  $this->isOwner();
        }
        return parent::isWritable();
    }

    public function isEditable() {
        if ($this->flag==self::$FLAG_PERSONEL) return false;
        return parent::isEditable();
    }

    public function update(){
        parent::update();
        if ($this->flag==self::$FLAG_PERSONEL) {
            $this->sharedContextList=array();
        }
    }

    public function jsonWithOrder($order) {
        $a=parent::json();
        $arr=array();
        if ($this->ownInstance) {
            foreach($this->ownInstance as $instance)
            {
                if (!$instance->isVisible()) continue;

                $ressource=$instance->ressource;
                if (!$ressource) {
                   // Il n'y a plus de ressource associé à l'instance
                   // On va donc supprimer l'instance
                   R::trash($instance);
                } else
                {
                    if ($instance->isVisible())  $arr[]=$instance->json();
                }
            }
        }
        if ($this->contextual) $a["contextual"]=true;
        $a["personnal"]=$this->flag==self::$FLAG_PERSONEL;
        $a["instances"]=$arr;
        $a["count"]=count($arr);
        $a["order"]=$order . $this->name;
        try {
            $a["recordsTotal"]=$this->bean->countOwn( 'instance' );
        } catch (Exception $e) {}
        return $a;
    }


}

// ===== PROFIL =======================================
class Model_Profil extends Model_First {

    public function isContextuable() {return true;}
    public function isVisible()      {return $this->hasRight(self::$RIGHT_READ);}

    public function json() {
         $a=array("id"=>$this->id,"name"=>$this->name,"description"=>$this->description,
                    "tag"=>$this->tag,"context"=>$this->context,"text"=>$this->text,
                    "expression"=>$this->expression,
                    "human" => ($this->human?$this->human:$this->text),
                    "writable"=>false,"locked"=>$this->isLocked(),
                    "deletable"=>$this->isDeletable(),
                    "editable"=>$this->isEditable());

         if ($this->user) $a["user"]=$this->user->json();

         return $a;

    }

    public function isDeletable() {
        if ($this->id==PROFIL_ADMIN()->id) return false;
        if ($this->id==PROFIL_ADMINLOCAL()->id) return false;
        if ($this->id==PROFIL_ALL()->id) return false;
        return parent::isDeletable();
    }

    // Importation d'un profil
    public static function import($datas,$app) {
        foreach ($datas as $data)
        {
                $profil = R::findOne('profil', 'tag = ?',array(normalizeTag($data->{'tag'})));
                if (!$profil)               {$profil=R::dispense('profil');   }
                if (!$profil->isEditable()) continue;
                $profil->tag=$data->{'tag'};
                $profil->name=$data->{'name'};
                $profil->description=$data->{'description'};
                $profil->expression=$data->{'expression'};
                $profil->text=$data->{'text'};
                $profil->importAutorisations($data);
                R::store($profil);
        }
    }

}
//===========================================================




class Model_User extends RedBean_SimpleModel {

    public function load(){
          $this->profil=array();
    }

    // Permet d'importer des administrateurs
    public static function import($datas,$app) {
        if (!is_array($datas)) {
            $app->sendError("Format de données incorrect");
        }
        foreach ($datas as $data)
        {
            if (property_exists($data, 'email')) {$field='email';}
            if (property_exists($data, 'uid'))   {$field='uid';}
            if (property_exists($data, 'user'))  {$field='user';}

            $users = R::find('user', "$field = ?",array($data->{$field}));
            foreach($users as $user) {
                if (property_exists($data, 'admin'))   {$user->admin=strtoupper($data->{'admin'});}
            }
            R::storeAll($users);
        }
    }

    public function update(){
           if (!$this->token) {
                $this->token=uniqid('',true);
           }
    }

    public function isAdmin() {
        return $this->uid=="admin" || $this->admin=="GLOBAL" ||
               array_key_exists(PROFIL_ADMIN()->id,$this->getProfils());
    }

    public function isAdminLocal() {
        return $this->admin=="LOCAL" || array_key_exists(PROFIL_ADMINLOCAL()->id,$this->getProfils());
    }

    public function isAdministrateur() {
        return $this->isAdmin() || $this->id==ADMIN()->id;
    }

    public function json() {
        return array("id"=>$this->id,"fullname"=>$this->fullname);
    }

     public function me() {


        $data=array();
        $data["id"]=$this->id;
        $data["fullname"]=$this->fullname;
        $data["context"]=$this->getArrContext();
        $data["admin"]=$this->isAdmin();
        $data["adminlocal"]=$this->isAdminLocal();

        $data["canfetchimage"]=(PARAM("API_SCREENSHOT","")!="");

        $data["droits"]=array("admin"=>$this->isAdmin(),"adminlocal"=>$this->isAdminLocal());

        foreach ($this->getProfils() as $profil) {
            $data["profils"][]= $profil->name;
        }

        foreach ($this->getAttributes() as $key=>$attribute) {
            $data["attributes"][]= array("key"=>$key , "value" => $attribute);
        }

        return $data;

    }

    public function getProfils()    {return PROFILS_USER();}

    public function getAttributes() {return CAS_ATTRIBUTES();}

    public function getContext()    {return USER_CONTEXT(); }

    public function getArrContext() {
        $all=$this->getContext();
        $ret=array();
        foreach ($all as $c)
        {
            $ret[]=$c->json();
        }
        return $ret;
    }

    public function hasContext($context) {
        $all=$this->getContext();
        foreach ($all as $c)
        {
            if ($c->id==$context->id) return true;
        }
        return false;
    }

    public function hasProfil($profilid) {
        return array_key_exists($profilid,$this->getProfils()) ;
    }

    public function matchProfil($profil) {
        $rep=preg_replace('/{([a-z]*)}/i','$this->${1}',$profil->text );
        /*if (strpos($profil->text,"preg_grep") !== false) {
            print_r(CAS_ATTRIBUTES());
            echo "[".$this->email."]\n";
            die($rep);
        }*/
        try {
            return eval(' try { return '.$rep.'; } catch (Exception $ex) { return false;}');
        } catch (Exception $ex) {
            return false;
        }
    }
}




?>
