<?php

// Timestamp actuel
$d=new DateTime();
$_SESSION["timestamp"]=$d->getTimestamp();

function startsWith($haystack, $needle)
{
     $length = strlen($needle);
     return (substr($haystack, 0, $length) === $needle);
}

function getProfil() {
  $user=USER();
  if (!$user) return "";
  return $user->profil;
}

function CONFIG($key,$default=false) {
    global $config;
    if (isset($config[$key])) return $config[$key];
    return $default;
}

function USER() {
    return $_SESSION["user"];
}

function ADMIN() {
    return $_SESSION["admin"];
}

function PROFIL_ADMIN() {
    return $_SESSION["profil_admin"];
}

function CAS_ATTRIBUTES() {
    return $_SESSION["cas_attributes"];
}

function PROFIL_ALL() {
    return $_SESSION["profil_all"];
}

function PROFILS_USER() {
    if (isset($_SESSION["profils_user"])) return $_SESSION["profils_user"];
    return array();
}

function PROFIL_ADMINLOCAL() {
    return $_SESSION["profil_adminLocal"];
}

function GLOBAL_CONTEXT() {
    return $_SESSION["global_context"];
}

function CATEGORY_NONE() {
    return $_SESSION["category_none"];
}

function USER_CONTEXT() {
    if (isset($_SESSION["user_context"])) return $_SESSION["user_context"];
    return array();
}

function LIBRARIES_CONTEXT() {
    return $_SESSION["libraries_context"];
}

function PARAM($name,$default=false) {
    return Model_Parameter::get($name,$default);
}

function setPARAM($name,$val) {
    Model_Parameter::set($name,$val);
}

function TIMESTAMP() {
    return $_SESSION["timestamp"];
}

$globalContext=R::findOne('context', 'tag = ?',array("GLOBAL"));
if (!$globalContext) {
    $globalContext = R::dispense("context");
    $globalContext->tag="GLOBAL";
    $globalContext->name="Tous les établissements";
    R::store($globalContext);
}
$_SESSION["global_context"]=$globalContext;

function getJsonLastError() {
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            return ' - Aucune erreur';
        break;
        case JSON_ERROR_DEPTH:
            return ' - Profondeur maximale atteinte';
        break;
        case JSON_ERROR_STATE_MISMATCH:
            return ' - Inadéquation des modes ou underflow';
        break;
        case JSON_ERROR_CTRL_CHAR:
            return ' - Erreur lors du contrôle des caractères';
        break;
        case JSON_ERROR_SYNTAX:
            return ' - Erreur de syntaxe: JSON malformé';
        break;
        case JSON_ERROR_UTF8:
            return ' - Caractères UTF-8 malformés, probablement une erreur d\'encodage';
        break;
        default:
            return ' - Erreur inconnue';
        break;
    }
    return "Aucune erreur";
}

function normalizeTag($tag) {
    if ($tag=="local") $tag="xlocal";
    return preg_replace('/[^A-Za-z0-9]/', '', $tag);
}


?>
