<?php

// Récupération des attributs
$attributes=$user_datas["details"];

// Est-ce que la clef permettant de retrouver l'utilisateur est présente ?
if (!isset($attributes[$config['cas_uid']]))
{
    die("Attribut CAS ".$config['cas_uid']." non retrouvé");
}

// Récupération de l'utilisateur
$user=$attributes[$config['cas_uid']][0];
if (!$user) {
    die("CAS user not found");   
}

// On va rechercher l'utilisateur
$USER = R::findOne('user', 'uid = ?',array($user));
if (!$USER) {
    $USER = R::dispense("user");
    $USER->uid=$user;
}

// Met en paramètre la conf SSO
$attributessso=PARAM("ATTRIBUTSSSO");
if (!$attributes) {
    $attributessso=CONFIG("attributs_sso");
    setPARAM("ATTRIBUTSSSO",$attributessso);  
}

// Construction des attributs CAS pour la gestion des profils
$attrs=explode("\n",$attributessso);
$_SESSION['profil_attributes']=array();
foreach( $attrs as $attr ) {
    if (strpos($attr,"=")!==false) {
        $a=explode("=",$attr);
        $_SESSION['profil_attributes'][]=$a[0];
        // Initialisation du profil de l'utilisateur a false (sauf si uid=admin)
        // Le traitement des attributs CAS, les mettra à jour.
        if ($USER->uid != "admin" ) $USER[$a[0]]=false;
    }
}

// Modification du user avec les infos CAS
$USER->username=$attributes[$config['cas_username']][0];
$USER->lastname=$attributes[$config['cas_lastname']][0];
$USER->firstname=$attributes[$config['cas_firstname']][0];


// Si pas de fullname on va en fabriquer un avec le last et first
if (!isset($attributes[$config['cas_fullname']])) 
{
    $USER->fullname=$USER->firstname . " " . $USER->lastname;
} else {
    $USER->fullname=$attributes[$config['cas_fullname']][0];
}

// Sauvegarde
$_SESSION["user"]=$USER;


// Récupération et/ou création des groupes principaux ------------------------------------------
$admin=R::findOne('user', 'uid = ?',array("admin"));
if (!$admin) {
    $admin = R::dispense("user");
    $admin->uid="admin";
    $admin->fullname="administrateur";
    $admin->profil="admin";
    $admin->admin="global";
    $admin->locked="1";
    R::store($admin);
}
$_SESSION["admin"]=$admin;

$profil_all = R::findOne('profil', 'tag = ?',array("TOUS"));
if (!$profil_all) {
    $profil_all = R::dispense("profil");
    $profil_all->tag="TOUS";
    $profil_all->name="Tout le monde";
    $profil_all->text="true";
    $profil_all->human="aucun filtrage";
    $profil_all->user=ADMIN();
    $profil_all->locked="1";
    R::store($profil_all);
}
$_SESSION["profil_all"]=$profil_all;

$profil_admin = R::findOne('profil', 'tag = ?',array("ADMIN"));
if (!$profil_admin) {
    $profil_admin = R::dispense("profil");
    $profil_admin->tag="ADMIN";
    $profil_admin->name="administrateurs";
    $profil_admin->text="{uid} == 'admin'";
    $profil_admin->user=ADMIN();
    $profil_admin->autorisations=json_encode(array(array("profil"=>PROFIL_ALL()->id,"right"=>Model_Base::$RIGHT_FORBIDEN)));
    $profil_admin->expression='{"operator":"ET","children",[{"type":"condition","comparator":"égal","field":"uid","value":"admin"}]}';
    R::store($profil_admin);
}
$_SESSION["profil_admin"]=$profil_admin;

$profil_adminLocal = R::findOne('profil', 'tag = ?',array("ADMINLOCAL"));
if (!$profil_adminLocal) {
    $profil_adminLocal = R::dispense("profil");
    $profil_adminLocal->tag="ADMINLOCAL";
    $profil_adminLocal->name="administrateurs locaux";
    $profil_adminLocal->text="{uid} == 'admin'";
    $profil_adminLocal->user=ADMIN();
    $profil_adminLocal->autorisations=json_encode(array(array("profil"=>PROFIL_ALL()->id,"right"=>Model_Base::$RIGHT_FORBIDEN)));
    $profil_adminLocal->expression='{"operator":"ET","children",[{"type":"condition","comparator":"égal","field":"uid","value":"admin"}]}';
    R::store($profil_adminLocal);
}
$_SESSION["profil_adminLocal"]=$profil_adminLocal;

$none=R::findOne('category', 'tag = ?',array("NONE"));
if (!$none) {
    $none= R::dispense("category");
    $none->tag="NONE";
    $none->name="Non catégorisé";
    $none->user=ADMIN();
    R::store($none);
}
$_SESSION["category_none"]=$none;

//--------------------------------------------------------------------------------


// Paramètre de proxy
$proxy=PARAM("proxy");
if ($proxy) {
    stream_context_set_default(
     array(
      'http' => array(
       'proxy' => "tcp://$proxy",
       'request_fulluri' => true
      ),
     'https' => array(
       'proxy' => "tcp://$proxy",
       'request_fulluri' => true
      )
     )
    );
}

// CAS Attributes
$cas=array();
foreach($attributes as $key => $value)
{
    if (startsWith($key,$config['cas_prefix']))
    {
        $attribute=str_replace($config['cas_prefix'],"",$key);
        if ($attribute=="") continue;
        $val=strtolower(implode("|",$value));
        $cas[$attribute]=$val;
        $USER[$attribute]=$val;
    }  
}
R::store($USER);
$_SESSION["cas_attributes"]=$cas;

// Context -----------------------------------------------------------------------
$context=array();
$contextLibraries=array();
if ($USER->isAdmin()) {
    $context[]=GLOBAL_CONTEXT();
}

$fichier_etabs_ini = "api/utils/etabs.ini";
$ETABS=null;
$rnes=explode("|",strtoupper($USER->rne));
// Si le user est admin et la requete precise des rnes, on va les ajouter
// a la liste des rnes pour le user 
if ($USER->isAdmin() && isset($_GET["rne"])) {
 $all=explode(",",$_GET["rne"]);
 foreach ($all as $a) {
    $rnes[]=strtoupper($a);  
 }
}

// Le rne doit être unique
$rnes=array_unique($rnes);

foreach ($rnes as $rne )
{
    if ($rne=="") continue;
    
    // Récurépation du context
    $etab=R::findOne('context', 'tag = ?',array($rne));
    if (!$etab) {
        $etab=R::dispense('context');
        $etab->tag=$rne;
        $etab->name=$rne;
    }
      
    if (!$ETABS && file_exists($fichier_etabs_ini)) {
            $ETABS = parse_ini_file($fichier_etabs_ini,true,INI_SCANNER_RAW );
    }
        
    if (!file_exists($fichier_etabs_ini)) $ETABS=array();
        
    if (isset($ETABS[$rne])) {
            $etab->portail=$ETABS[$rne]["portail"];
            $etab->name=$ETABS[$rne]["libelle"];
    } 

    R::store($etab);
    $context[]=$etab;
    
    
    $nb=$etab->withCondition(' flag = ?  ', array(Model_Library::$FLAG_CONTEXT) )->countShared('library');

    if ($nb==0) {
        $lib=R::dispense("library");
        $lib->flag=Model_Library::$FLAG_CONTEXT;
        $lib->name=$etab->name;
        // Droits par défaut: Admin local en edittion et les autres en lecture
        $lib->autorisations=json_encode(array(array("profil"=>PROFIL_ADMINLOCAL()->id,"right"=>Model_Base::$RIGHT_WRITE),
                                              array("profil"=>PROFIL_ALL()->id,"right"=>Model_Base::$RIGHT_READ)
                                             ));
        $lib->sharedContext=array($etab);  
        $lib->user=ADMIN();
        // Mise à jour du nom
        $lib->name=$etab->name;
        R::store($lib);
        
        
    } else {
        $all=$etab->withCondition(' flag = ?  ', array(Model_Library::$FLAG_CONTEXT) )->sharedLibrary;
        // reset: permet de récupérer le premier élément
        $lib=reset($all); 
        $lib->name=$etab->name;
        R::store($lib);
    }
    

    $contextLibraries[]=$lib;
    
}

// L'utilisateur doit disposer d'au moins un établissement
if (count($context)==0)
{
    die("Aucun établissement (context) trouvé, contacter l'administrateur");   
}

$_SESSION["user_context"]=$context;
$_SESSION["libraries_context"]=$contextLibraries;
//---------------------------------------------------------------------------------------

// ===== Gestion de la bibliothèque personnelle (tout le monde en dispose d'une)
$library=R::findOne('library', 'user_id = ? and flag = ? ',array($USER->id,Model_Library::$FLAG_PERSONEL));
if (!$library) {
    $library=R::dispense("library");
    $library->flag=Model_Library::$FLAG_PERSONEL;
    $library->user=$USER;
    $library->name="Mes ressources";
    $library->description="Bibliothèque personnelle, les ressources ne sont visibles que par vous.";
    R::store( $library );  
}
// ===================================================================================

// Création parametre SSO
if (defined('__CAS_SERVER')) {
    $param = R::findOne("parameter", 'name = ?',array("SERVEUR_SSO"));
    if (!$param) {
            $param=R::dispense("parameter");     
            $param->name="SERVEUR_SSO";$param->value=__CAS_SERVER;
            $param->locked="1";
            R::store($param);
    }
}

if (defined('__CAS_PORT')) {
    $param = R::findOne("parameter", 'name = ?',array("PORT_SSO"));
    if (!$param) {
            $param=R::dispense("parameter");     
            $param->name="PORT_SSO";$param->value=__CAS_PORT;
            $param->locked="1";
            R::store($param);
    }
}



// Calcul des profils
$profils=R::findAll("profil");
$arrProfils[PROFIL_ALL()->id]=PROFIL_ALL();
foreach ($profils as $profil) 
{
    if ($USER->matchProfil($profil)) $arrProfils[$profil->id]=$profil;
}
$_SESSION["profils_user"]=$arrProfils;


   

?>