<?php

    error_reporting(-1);
    ini_set('display_errors', 'On');

    // Ajout du framework slim 
    require 'include/include.php';
    require 'Slim/Slim.php';
    \Slim\Slim::registerAutoloader();

    // Un peu de customisation de slim -------------------------------------------------------
    class mySlim extends Slim\Slim {

        private static $cache;
        
        public function __construct() { 
            parent::__construct();
            self::$cache = array(); 
        } 
        
        function sendError($message)    {$this->halt(500,$message);}
        function sendForbiden($message) {$this->halt(403,$message);}
        function sendNotFound($message) {$this->response->write($message);$this->stop();}
        
        function requireAdmin() {
             if (! USER()->isAdmin() ) { 
                $this->sendError("Profil Administrateur Obligatoire"); 
             }
        }
        
        function json($obj) {
            $this->response->headers->set('Content-Type', 'application/json');
            if (is_array($obj))  $this->response->setBody(json_encode($obj));
            else $this->response->setBody( json_encode($obj->json())); 
        }
        
        function info($msg) {
            $this->response->write($msg."\n");
        }
        
        function sendAll($element) {
            $elements=R::findAll($element,' ORDER BY name ASC ');
            $a=array();
            foreach ($elements as $e) {if ($e->isVisible()) $a[]=$e->json();    }
            $this->outputArray($a);   
        }
        
        // Crée un élément s'il n'est pas retrouvé par son id ou tag
        function createIfNotExist($element,$id)
        {
            if (is_numeric($id)) $item = R::findOne($element, 'id = ?',array($id));
            else $item = R::findOne($element, 'tag = ?',array($id));
            if (! $item ) { $item=R::dispense($element); } 
            return $item;
        }
        
        // L'élément doit exister et être supprimable
        function mustExistAndDeletable($element,$id)
        {
            $item=$this->getOne($element,$id);
            if (!$item->isDeletable()) {$this->sendForbiden("Droit insuffisant pour supprimer ".$item->name);return null; }
            return $item;
        }
        
        // L'élément doit exister et être writable
        function mustExistAndWritable($element,$id)
        {
            $item=$this->getOne($element,$id);
            if (!$item->isWritable()) 
            {
                $this->sendForbiden("Droit insuffisant pour ajouter des éléments dans ".$item->name. " ($element)");
                return null; 
            }
            return $item;
        }
        
        
        // L'élément doit exister et être editable
        function mustExistAndEditable($element,$id)
        {
            $item=$this->getOne($element,$id);
            if (!$item->isEditable())   {$this->sendForbiden("Droit insuffisant pour modifier"); }
            return $item;
        }
        
        // L'élément doit exister et être visible
        function mustExistAndVisible($element,$id)
        {
            $item=$this->getOne($element,$id);
            if (!$item->isVisible())   {$this->sendForbiden("Droit insuffisant pour voir"); }
            return $item;
        }
        
        function getOne($element,$id) 
        {
            $key=$element."_".$id;
            if (array_key_exists($key,self::$cache)) {
                return self::$cache[$key];   
            }
            
            if (is_numeric($id)) 
                $item = R::findOne($element, 'id = ?',array($id));
            else {
                $id=preg_replace('/[^A-Za-z0-9]/', '', $id); 
                $item = R::findOne($element, 'tag = ?',array($id));
            }
            
            if (!$item) {$this->sendNotFound("$element '$id' introuvable");return null;}
            
            self::$cache[$key]=$item;
            return $item;
        }
        
        // Retourne les contextes (établissements) à partir d'un tableau d'id
        // vérifie la visibilité du context d'abord 
        function getContexts($arrContext)
        {
           $ret=array();
           // Pas de context, on va prendre le premier de l'utilisateur
           if (!is_array($arrContext)) {
              $a=USER_CONTEXT();
              $arrContext=array($a[0]->id);  
           }
           foreach ( $arrContext as $id)
           {
               $context = $this->mustExistAndVisible("context",$id);
               $ret[]=$context;  
           }
           return $ret;
        }
        
        function requireAdminLocal() {
             if (! USER()->isAdminLocal() && ! USER()->isAdmin() ) { 
                $this->sendForbiden("Profil Administrateur Local Obligatoire"); 
             }
        }
        
        // Permet de dire si nous sommes en mode 'Importation'
        function setImportation($val) {$this->importation=$val;}
        function isImportation()      {return $this->importation;}


        function outputArray($data) {
            switch($this->request->headers->get('Accept')) {
                case 'application/json':
                default:
                    $this->response->headers->set('Content-Type', 'application/json');
                    $json=json_encode($data);
                    header("Content-Type:application/json");
                    die($json);
                    // TODO: voir pourquoi lorsque la taille est importante
                    // slim affiche un nombre avant la reponse
                    //$this->response->setBody($json); 
            }       
        } 
    }
    // ---------------------------------------------------------------------------------------
    
    // Creation de l'api
    $app = new mySlim();
    $app->setImportation(false);

    include_once("routes/catalogues.php");
    include_once("routes/ressources.php");
    include_once("routes/libraries.php");
    include_once("routes/profils.php");
    include_once("routes/parameters.php");
    include_once("routes/context.php");

    // Importation de données
    $app->post('/import', function () use ($app) {
       if(isset($_FILES)){
            $content=file_get_contents($_FILES['file']['tmp_name']); 
            $datas=json_decode($content);
            if (!$datas) {
                $err=getJsonLastError();
                $app->sendError("\nFormat de données incorrect:$err\n"); 
            }
            set_time_limit(120); // 2min max
            $app->setImportation(true);
           
            // Mode frozen, permet d'optimiser les updates
            $freeze=TRUE;
            if (property_exists($datas, 'fluid')) $freeze=FALSE;
           
            R::freeze($freeze);
           
            try {
            
                if (property_exists($datas, 'admins')) {
                    Model_User::import($datas->{'admins'},$app);
                }
                if (property_exists($datas, 'catalogues')) {
                    $app->info("Importation de catalogues");
                    Model_Catalogue::import($datas->{'catalogues'},$app);
                }
                if (property_exists($datas, 'categories')) {
                    Model_Category::import($datas->{'categories'},$app);
                }
                if (property_exists($datas, 'profils')) {
                    Model_Profil::import($datas->{'profils'},$app);
                }
                if (property_exists($datas, 'libraries')) {
                    Model_Library::import($datas->{'libraries'},$app);
                }
                if (property_exists($datas, 'ressources')) {
                    if ($freeze) R::begin();
                    $app->info("Importation des ressources");
                    Model_Ressource::import($datas->{'ressources'},$app);
                    if ($freeze) R::commit();
                }
            } catch ( Exception $e ) {
                 $app->sendError("\nErreur lors de l'importation:$e\n");     
            }
            
            R::freeze(FALSE);
            
        }
    });
    

    $app->run();

?>
