<?php

    // Gestion des catalogues ================================= 

    // Get all catalogues
    $app->get('/catalogues', function () use ($app) {$app->sendAll("catalogue");});

    // Get all categories
    $app->get('/categories', function () use ($app) {$app->sendAll("category");});

    // lib json
    $app->get('/catalogue/:id/json', function ($id) use ($app) {
        $catalogue = $app->mustExistAndVisible("catalogue",$id);
        echo json_encode($catalogue->json());
    });

    // Edit catalogue
    $app->get('/catalogue/:id', function ($id) use ($app) {
        $catalogue = $app->createIfNotExist("catalogue",$id);
        $app->render('catalogue-edit.php', array('catalogue' => $catalogue));
    });

    // Get catalogue ressources
    $app->get('/catalogue/ressources/:id', function ($id) use ($app) {

        $catalogue = $app->mustExistAndVisible("catalogue",$id);
        
        $req = $app->request();
        $bLatestOnly=$req->get("latest")=="true";
        
        // Limit le nomdre de résultat
        $max=100;
        if ($bLatestOnly) $max=10;
        
        // Total de la base
        try {
            $nb = $catalogue->countOwn( 'ressource' );
        } catch (Exception $e) {
            $nb=0;
        }
        
        // Trier du plus récent au plus vieux
        $order='ORDER BY updated DESC LIMIT  '. $max;
        
        $filter="";
        // Récupération des éléments
        if ($req->get("filter") && trim($req->get("filter"))!="" ) {
            $filter="%".$req->get("filter")."%"; 
            $elements=$catalogue->withCondition(" name like ? OR url like ? or description like ? $order",
                                                 array($filter,$filter,$filter) )->ownRessource;
            
        } else
        {
            $elements=$catalogue->with($order)->ownRessource;
        }
        
        // Liste les ressources du catalogue
        // il n'y a pas pour le moement des droits sur une ressources dans un catalogue
        // la visibilité des ressources dans un catalogue est lié à la visibilité du catalogue
        $a=array();
        foreach ($elements as $ressource) 
        {
            /*if ($ressource->isVisible())*/ $a[]=$ressource->json();    
        }
        
        $ret=array();
        $ret["recordsTotal"]=$nb;                   // Nombre total d'éléments
        $ret["data"]=$a;                            // Elements récupérés
        if ($filter!="") $ret["filter"]=$filter;    // Filtre appliqué
        $app->outputArray($ret); 

    });

    // Delete catalogue
    $app->delete('/catalogue/:id', function ($id) use ($app) {
        $catalogue = $app->mustExistAndDeletable("catalogue",$id);
        R::trash( $catalogue );      
    });

    // Sauvegarde 
    $app->post('/catalogue/:id', function ($id) use ($app) {

        $catalogue = R::findOne('catalogue', 'id = ?',array($id));
        if (! $catalogue ) {  $catalogue=R::dispense('catalogue');}

        if (!$catalogue->isEditable()) return;
        
        $req = $app->request();
        $catalogue->name=$req->post("name");
        $catalogue->sharedContext=$app->getContexts($req->post("context"));
        $catalogue->description=$req->post("description");   
        $catalogue->autorisations=$req->post("autorisations");    
        R::store($catalogue);         

    });

    // ========================================================

?>
