<?php


    // Gestion des bibliotheques ================================= 

    // Get all libraries
    $app->get('/libraries', function () use ($app){
        $all = R::find( 'library', ' flag is NULL ', array() );
        $a=array();
        
        // Lib perso
        $library=R::findOne('library', 'user_id = ? and flag = ? ',array(USER()->id,Model_Library::$FLAG_PERSONEL));
        $library->personnal=true;
        $a[]=$library->jsonWithOrder(0);
        
        // Lib du context
        foreach (LIBRARIES_CONTEXT() as $e) {
            $lib=R::findOne('library','id = ?',array($e->id));
            $lib->contextual=true;
            if ($lib->isVisible()) $a[]=$lib->jsonWithOrder(1);    
        }
        
        // Toutes les autres libs
        foreach ($all as $e) {if ($e->isVisible()) $a[]=$e->jsonWithOrder(2);    }
        
        $app->outputArray($a);   
    });

    // lib json
    $app->get('/library/:id/json', function ($id) use ($app) {
        $lib = $app->mustExistAndVisible("library",$id);
        echo json_encode($lib->json());
    });

    // Edit lib
    $app->get('/library/:id', function ($id) use ($app) {
        $app->render('common-edit.php');
    });


    // Boite de dialogue pour ajouter des ressources a une library
    $app->get('/library/:id/select', function ($id) use ($app) {
        $library = $app->mustExistAndWritable("library",$id);
        $app->render('ressources-select.php');
    });

    // Ajout de ressources a une lib
    $app->post('/library/:id/add', function ($id) use ($app) {

        $library = $app->mustExistAndWritable("library",$id);
        
        $req = $app->request();
        
        // Liste des ressources
        $ress=$req->post("ressources");
        $parameters=$req->post("parameters"); // Parametres 
        
        foreach( $ress as $res) {
            
            $ressource = $app->mustExistAndVisible("ressource",$res);
            
            // récupération des paramètres si existent pour la ressource
            $params=null;
            if (isset($parameters[$res])) $params=$parameters[$res];
            
            $instance=$ressource->instantiate($library,$app,$params);
            if ($instance==null) {
                $app->sendError("Cette Ressource existe déja dans '".$library->name."'");
            }
            
        }
        R::store($library);
    });

    // Supression des instances a une lib
    $app->delete('/library/:id/delete', function ($id) use ($app) {

        $library = $app->mustExistAndWritable("library",$id);
  
        // Liste des ressources
        $instances=$app->request()->post("instances");
        
        // Vérifie que toutes les instances sont supprimables
        foreach( $instances as $ins) {
            $instance = $app->mustExistAndDeletable("instance",$ins);
        }
        
        // Suppression des instances
        foreach( $instances as $ins) {
            $instance = $app->getOne("instance",$ins);
            R::trash($instance);
            unset( $library->ownInstanceList[$id] );
        }
        R::store($library);
        
        // TODO supprimer les commentaires associés
        
    });

    // Get all instance in a library
    $app->get('/library/instances/:id', function ($id) use ($app) {
        
        if ($id==0) return;
        
        $library = $app->mustExistAndVisible("library",$id);
        
        $arr=array();
        
        // Chaque instance
        if ($library->ownInstance) {
            foreach($library->ownInstance as $instance)
            {
                if (!$instance->isVisible()) continue;
                    
                $ressource=$instance->ressource;
                if (!$ressource) {
                   // Il n'y a plus de ressource associé à l'instance
                   // On va donc supprimer l'instance
                   R::trash($instance);
                } else
                {
                    if ($instance->isVisible())  $arr[]=$instance->json(); 
                }

            }
        }
        
        $app->outputArray($arr);

    });


    // Sauvegarde 
    $app->post('/library/:id', function ($id) use ($app) {

        $req = $app->request();
        
        $library = R::findOne('library', 'id = ?',array($id));
        if (! $library ) {  $library=R::dispense('library');$library->user=USER();}
        
        $library->sharedContext=$app->getContexts($req->post("context"));
        if (! $library->isEditable() ) { 
            $app->sendError("Bibliothèque #${id} introuvable où droit insuffisant"); 
        }

        
        $library->name=$req->post("name");
        $library->description=$req->post("description");   
        $library->autorisations=$req->post("autorisations");    
        R::store($library);         

    });

    // Sauvegarde 
    $app->delete('/library/:id', function ($id) use ($app) {

        $library = R::findOne('library', 'id = ?',array($id));
        if (! $library || ! $library->isDeletable() ) { 
            $app->sendError("Bibliothèque #${id} introuvable où droit insuffisant"); 
        }

        R::trash($library);         

    });

    // 
    $app->get('/instance/:id', function ($id) use ($app) {

        $instance = R::findOne('instance', 'id = ?',array($id));
        if (! $instance || ! $instance->isVisible() ) { 
            $app->sendError("Instance #${id} introuvable où droit insuffisant"); 
        }

        $app->render('instance-edit.php',array("ressource"=>$instance->ressource));

    });

    // Instantiate save -> creation d'une instance
    $app->post('/instance/:id', function ($id) use ($app) {

        $instance=$app->mustExistAndEditable('instance',$id);
        
        /*$libid=$app->request()->post("library");
        $library=$app->mustExitAndWritable('library',$libid);*/
        
        // Mise a jour des paramètres
        if ($app->request()->post("params")) {
            $instance->params=json_encode($app->request()->post("params"));
        } else
        {
           $instance->params=json_encode(array());
        }
        R::store($instance);
        
        

        
        $app->json($instance);

    });

    // 
    $app->get('/instance/:id/eval', function ($id) use ($app) {
        $app->render('eval-edit.php');
    });

    $app->post('/instance/:id/access', function ($id) use ($app) {
        $instance = $app->mustExistAndVisible("instance",$id); 
        if (!$instance->library->isVisible()) {$app->pass();}
        
        // Comptabilise au niveau de l'insatnce
        $instance->access=intval($instance->access)+1;
        R::store($instance);
        
        // Comptabilise au niveau de la ressource
        $ressource=$instance->ressource;
        $ressource->access=intval($ressource->access)+1;
        R::store($ressource);
        
        $app->json($instance);
        
    });


    // Retourne toutes les évaluations pour une instance
    $app->get('/instance/:id/evals', function ($id) use ($app) {
        $instance = $app->mustExistAndVisible("instance",$id); 
        if (!$instance->library->isVisible()) {$app->pass();}
        
        $arr=array();
        foreach($instance->with( ' ORDER BY created DESC ' )->sharedEval as $eval) {
            $arr[]=$eval->json();
        }
        $app->json($arr);
        
    });

    // Retourne les dernières ressources évaluées
    $app->get('/home', function () use ($app) {
        $date = new DateTime();
        $date->modify('-1 day');
        $arrRet=array();
        
        $all = R::find( 'eval', ' created > ? ORDER BY created DESC', array($date->format('Y-m-d')) );
        
        // Dernières évaluations
        $arr=array();
        $already=array();
        $count=0;
        foreach ($all as $eval)
        {
            if (!$eval->instance) continue;
            if ($already[$eval->instance->id]) continue;
            if (!$eval->instance->library->isVisible()) continue;
            
            $ressource=$eval->instance->ressource;
            if (!$ressource->isVisible()) continue;
            
            $a=$eval->instance->json();
            $already[$eval->instance->id]=true;
            
            $a["eval"]=$eval->json();
            $arr[]=$a;
            $count++;
            if ($count==4) break;
        }
        $arrRet["evals"]=$arr;
        
       
        $app->json($arrRet);
    });

    // Evaluation
    $app->post('/instance/:id/eval', function ($id) use ($app) {
        $instance = $app->mustExistAndVisible("instance",$id);
        if (!$instance->library->isVisible()) {$app->pass();}
        
        $req = $app->request();
        $vote=$req->post("vote");
        $comment=$req->post("comment");
        
        // Création de l'évaluation
        $eval=R::dispense("eval");
        $eval->vote=intval($vote);
        $eval->comment=$comment;
        $eval->instance=$instance;
        R::store($eval);
        
        // Comptabilise le vote sur l'instance
        $instance->points=$instance->points+$eval->vote;
        $instance->count=$instance->count+1;
        $instance->rate=$instance->points/$instance->count;
        $instance->sharedEvalList[]=$eval;
        R::store($instance);
        
        // Idem sur la ressource
        $ressource=$instance->ressource;
        $ressource->points=$instance->points+$eval->vote;
        $ressource->count=$ressource->count+1;
        $ressource->sharedEvalList[]=$eval;
        R::store($ressource);
        
        $app->json($instance);
        
    });

    $app->get('/instance/:id/json', function ($id) use ($app) {
        $lib = $app->mustExistAndVisible("instance",$id);
        echo json_encode($lib->json());
    });


?>
