<?php

    // List des profils
    $app->get('/parameters', function () use ($app) {
        $app->requireAdmin();
        $app->sendAll("parameter");
    });

    // Edit profil
    $app->get('/parameter/:id', function ($id) use ($app) {
        
        $app->requireAdmin();
        
        $parameter = R::findOne('parameter', 'id = ?',array($id));
        if (! $parameter ) 
        { 
            $parameter=R::dispense('parameter'); 
        }

        $app->render('parameter-edit.php',array("parameter"=>$parameter));

    });

    // Sauvegarde 
    $app->post('/parameter/:id', function ($id) use ($app) {
        
        $app->requireAdmin();

        $parameter = R::findOne('parameter', 'id = ?',array($id));
        if (! $parameter ) {  
            $parameter=R::dispense('parameter');
            $parameter->tag=$name;
        }

        $req = $app->request();
        $parameter->name=$req->post("name");
        $parameter->value=$req->post("value");  
        R::store($parameter);         

    });

    // Sauvegarde en put (par  le tag)
    $app->put('/parameter/:tag', function ($tag) use ($app) {
        
        $app->requireAdmin();

        $parameter = R::findOne('parameter', 'tag = ?',array($tag));
        if (! $parameter ) {  
            $parameter=R::dispense('parameter');
            $parameter->tag=$tag;
            $parameter->name=$tag;
        }
 
        global $_PUT;
        $parameter->value=$_PUT["value"];
        if (isset($_PUT["locked"])) {
            $parameter->locked=$_PUT["locked"]; 
        }
        R::store($parameter);         

    });

    // Supression
    $app->delete('/parameter/:id', function ($id) use ($app) {
        $app->requireAdmin();
        $parameter = $app->mustExistAndDeletable("parameter",$id);
        R::trash( $parameter );  
    });


?>