var Parameters =  CItem.extend({
    initialize : function(data) { 
        this.api_tag="";
        this.api_elementsTag="parameters";
        this.class_element="Param"; 
        this.template="parameter-elements-template";
        this.getElements();
        this.group = function() {}
        
        this.libelleCreate("un paramètre");
        this.libelleListe("Liste des paramètres de l'application");
        
        this.isWritable = function() { return appViewModel.user.isAdmin()}
    }
});

var Param = CItem.extend({
    initialize : function(data) { 
        this.api_tag="parameter";
    }
});



// ===== Profils =========================================
var Profils = CItem.extend({
    initialize : function(data) { 
        this.api_tag="";
        this.api_elementsTag="profils";
        this.class_element="Profil"; 
        this.template="profil-elements-template";
        this.getElements();
        this.group = function() {}
        this.menu="profil";
        
        this.libelleCreate("un profil");
        this.libelleListe("Liste des profils");
        
        this.isWritable = function() { return appViewModel.user.canCreateProfil();}
    }
});

Profils.prototype.check=function(value) {}

// Attention : Pour le moment la cohérence id<->libelle avec le serveur
// doit se faire manuellement dans le fichier classes.php
Profils.RIGHTS=[]
Profils.RIGHTS.push({id:0,libelle:"Interdit",icon:"fa-ban"})
Profils.RIGHTS.push({id:100,libelle:"Visualisation",icon:"fa-eye"})
Profils.RIGHTS.push({id:200,libelle:"Ajout",icon:"fa-plus-circle"})
Profils.RIGHTS.push({id:300,libelle:"Edition",icon:"fa-pencil"})
Profils.RIGHTS.push({id:400,libelle:"Suppression",icon:"fa-trash"})

Profils.HASHRIGHTS={}
for (var i=0;i<Profils.RIGHTS.length;i++)
{
  Profils.HASHRIGHTS[Profils.RIGHTS[i].id]=Profils.RIGHTS[i];  
}


var Profil = CItem.extend({
    initialize : function(data) { 
        this.api_tag="profil";
        this.menu="profil";
    }
});

// Lors de la récupération des données du formulaire
// on va récupérer l'expression du profil
Profil.prototype.onModalData = function (data) {
     var jsonData = JSON.stringify(this.viewModel.group().toJSON());
     data.expression=jsonData;
     data.text=this.viewModel.group().getText();
     data.human=this.viewModel.group().text();
}

// OnEdit
Profil.prototype.onEdit = function () {
    var self=this
    //self.viewModel=new QueryBuilder.ViewModel();
    try {
         var expression=$("#expression").val();
         var parsed=JSON.parse(expression);
         self.viewModel=new QueryBuilder.ViewModel(parsed);
    } catch (e) {
        console.log(e)
        self.viewModel=new QueryBuilder.ViewModel();
    }
    
    var editExpr="";
    if (self.isEditable()) {
        editExpr='<div data-bind="with: group"><div data-bind="template: templateName"></div>'
    }
    
    $("#expressionBuilder").html('<div class="alert alert-info expression-preview"><span data-bind="html: text"></span></div>'+editExpr+'</div>');
    
    ko.cleanNode($("#expressionBuilder")[0])
    ko.applyBindings(self.viewModel,$("#expressionBuilder")[0]);
      
}




