function Right(data,parent) {
    
    var self=this;
    self.parent=parent
    self.editing=ko.observable(false)
    
    
    data=data || {profil:"0",right:0}
    self.data=data
    
    // Si le droit n'est pas trouvé -> droit par défaut 0
    if (! Profils.HASHRIGHTS[data.right]) data.right=0
    
    self.profil=ko.observable(data.profil);
    self.right=ko.observable(data.right);
    
    this.lastProfil=data.profil
    this.lastRight=data.right
    
    this.export = function() {
        return {profil:this.profil(),right:this.right()}   
    }
    
    this.profilExists=function() {
        return appViewModel.profilExists(self.profil());    
    }
    
    this.profilName=function() {
        return appViewModel.getProfilName(self.profil());    
    }
    
    this.droitName=ko.computed(function() {
        var d=Profils.HASHRIGHTS[self.right()];
        if (!d) {
            return self.right();
        }
        return d.libelle;    
    });
    
    this.droitIcon=function() {
        return "<i class='fa "+Profils.HASHRIGHTS[self.data.right].icon+"'</i>";    
    };
    
    this.edit=function() 
    {
        self.lastProfil=self.profil()
        self.lastRight=self.right()
        self.editing(!self.editing())
    }
    
    this.cancel=function() 
    {
        self.profil(self.lastProfil)
        self.right(self.lastRight)
        self.editing(false)
    }
    
    this.trash=function() 
    {
        parent.deleteRight(self);
    }
}
