var User = CItem.extend({
    initialize : function(data) { 
        var self=this;
        this.api_tag="user";
        this.userProfilEdit=ko.observable();
        self.context=ko.observableArray([]);
        
        this.canCreateCatalogue=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.canCreateLibrary=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.canInstantiate=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.canCreateProfil=function() {
            return this.isAdmin() || this.isAdminLocal();   
        }
        
        this.mainProfil=function() {
            if (self.isAdmin()) return "Administrateur"; 
            if (self.isAdminLocal()) return "Administrateur Local";  
            if (self.data.profils && self.data.profils.length>1) return self.data.profils[1];
            if (self.data.profils && self.data.profils.length==1) return self.data.profils[0];
            return "--";
            
        }
    
        
        this.isAdmin=function()   {return this.data.admin}
        this.isAdminLocal=function() {return this.data.adminlocal}
        
        this.canAdmin=function() {return this.isAdmin() || this.isAdminLocal()}
        
        this.profils=ko.computed(function()
        {
            if (!self.data.profils) return "";
            var ret=""
            for ( var i=0;i<self.data.profils.length;i++)
            {
                ret=ret+self.data.profils[i].toLowerCase().replace(" ","")+" "
            }
            if (self.isAdmin()) ret=ret+"admin"+" ";
            if (self.isAdminLocal()) ret=ret+"adminlocal"+" ";
            return ret
        })
        
        for ( var i=0;i<self.data.context.length;i++)
        {
            c=new Context(self.data.context[i])
            self.context.push(c);
        }
    }
});


User.prototype.onEdit=function()
{
    
}

var Context = CItem.extend({
    initialize : function(data) {
    
    }
})