<script id="carousel-template" type="text.html">

<div class="col-md-12">
    <div class="carousel slide">
      <div class="carousel-inner" data-bind="foreach: {data:catalogue.children , as: 'ressource'}">
        <div class="item active">
          <div class="col-md-4">
            <a href="#">
                <div class="ressource" data-bind="template: { name: 'ressource-template', data: ressource }"></div>  
            </a>
          </div>
        </div>
      </div>
      <a class="left carousel-control" href="#myCarousel" data-slide="prev"><i class="glyphicon glyphicon-chevron-left"></i></a>
      <a class="right carousel-control" href="#myCarousel" data-slide="next"><i class="glyphicon glyphicon-chevron-right"></i></a>
    </div>
</div>
</script>

<script id="home-template" type="text/html">

    <div class="row">
    
    
        <!--- -- -- -- CATALOGUES -- -- -- ---- -- --->
        <!-- ko if: appViewModel.catalogues().length!=0 -->
        <div id="catalogues-intro" class="col-xs-12 col-sm-12 col-lg-12">
            <h2>Catalogues</h2>
            <p>Vous disposez de <span data-bind="text:appViewModel.catalogues().length"></span> catalogue<span data-bind="visible:appViewModel.catalogues().length>1">s</span> pour compléter vos bibliothèques.</p>
            <p>Voici les <b>dernières</b> ressources qui ont été ajoutées. Cliquez sur le bouton 
            <button type="button" class="btn btn-primary btn-xs ">
                                        <i class="fa fa-plus-circle"/>
                </button> 
            pour les
            ajouter dans les bibliothèques.</p>
        </div>
        
        <div id="catalogues-ressources" data-bind="foreach: { data: appViewModel.catalogues, as: 'catalogue'}">
        <!-- Catalogue -->
        <div class="col-xs-12 col-sm-12 col-lg-12 list-group" >
              <div href="#" class="list-group-item catalogue">
                <h4 class="list-group-item-heading">
                    <i class="fa fa-suitcase fa-fw"></i>
                    <span data-bind="text:data.name"></span> 
                    <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:catalogue.show">
                                    <i class="fa fa-plus-XX"/>Tout voir
                    </button>  
                </h4>
                <p class="list-group-item-text">
                    <small data-bind="html:data.description"></small>
                </p>
                
                <!-- <div xdata-bind="template: { name: 'carousel-template'}"></div> --> 
                
                 <ul  class="ressources rig columns-5" 
                     data-bind="foreach: {data:catalogue.children , as: 'ressource'}">

                    <!-- ko if:  ressource.isProposable() && ressource.actif() && $index() <4 -->
                    <li class="ressource" data-bind="template: { name: 'ressource-template', data: ressource }"></li> 
                    <!-- /ko -->
                </ul>

              </div>
        </div> <!-- fin catalogue -->
        </div>    
 
        <!-- /ko -->
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
    
        <!--- -- -- -- DERNIERS COMMENTAIRES -- -- -- -- -->
        <div class="col-xs-12 col-sm-6 col-lg-4 lastevals" data-bind="visible:appViewModel.lastEvals().length!=0">
        <div class="col-inner">
            <h2>Derniers commentaires</h2>

            <!-- ko if: appViewModel.lastEvals().length!=0 -->
            <p>
                
                <ul  class="categorie rig columns-5" 
                     data-bind="foreach: {data:appViewModel.lastEvals , as: 'instance'}">

                    <li data-bind="template: { name: 'instance-template', data: instance }"></li> 
                </ul>
            </p>
            <!-- /ko -->
        </div>
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!--- -- -- -- DERNIERS AJOUTS -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-8 lastinstances" 
                    data-bind="visible:appViewModel.hasLastInstances">
         <div class="col-inner">
            <h2>
                <span class="fa-stack fa-lg puce">
                  <i class="fa fa-circle fa-stack-2x"></i>
                  <i class="fa fa-clock-o fa-stack-1x fa-inverse"></i>
                </span>
                Nouveautés
                <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:appViewModel.byDate">
                                    <i class="fa fa-plus-XX"/>Tout voir
                </button>  
            </h2>
            
            <ul  class="categorie rig columns-5" 
                     data-bind="foreach: {data:appViewModel.lastInstances , as: 'instance'}">

                    
                    <li data-bind="template: { name: 'instance-template', data: instance }"></li> 
            </ul>
            
            <!-- <i class="fa fa-hand-o-right"></i> 
                <a href="#" 
                   data-bind="click:appViewModel.byDate" >Voir toutes les ressources, des plus récentes au plus anciennes</a>-->
            
          </div> 
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!-- --- --- -- -- BIBLIOTHEQUES CONTEXTUELLES -- -- -- -->
        
        <div id="libraries-context" 
             data-bind="foreach: { data: appViewModel.librariesContextual}">
            <!-- Library -->
            <div class="col-xs-12 col-sm-12 col-lg-12 list-group" >
                  <div href="#" class="list-group-item library">
                    <h4 class="list-group-item-heading">
                        <i class="fa fa-book fa-fw"></i>
                        <span data-bind="text:data.name"></span> 
                    </h4>
                    <p class="list-group-item-text">
                        <small data-bind="html:data.description"></small>
                    </p>

                     <ul  class="instances rig columns-5 light" 
                         data-bind="foreach: {data:children , as: 'instance'}">
                        
                        <li data-bind="template: { name: 'instance-template', data: instance }"></li> 
                        

                    </ul>
                    
                    <!-- ko if: children().length==0 -->
                        Il n'y a aucune ressource actuellement dans cette bibliothèque.
                        <span data-bind="visible: ! isWritable()">Veuillez contacter l'administrateur de l'établissement pour y ajouter des ressources</span>
                        <div data-bind="visible:  isWritable()">
                            Vous pouvez y ajouter des ressources soit
                            <ul>
                                <li data-bind="click:selectRessources"><a href="#">depuis un catalogue</a></li>
                                <li data-bind="click:createNewRessource"><a href="#">ou créer une nouvelle ressource</a></li>
                            </ul>
                        </div>
                    <!-- /ko -->

                  </div>
            </div> <!-- fin Library -->
        </div> 
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        
        
        
        <!--- -- -- -- MIEUX NOTES -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-8 bestrating" data-bind="visible:appViewModel.bestRating().length!=0">
         <div class="col-inner">
            <h2>
                <span class="fa-stack fa-lg puce">
                  <i class="fa fa-circle fa-stack-2x"></i>
                  <i class="fa fa-star fa-stack-1x fa-inverse"></i>
                </span>
                Les mieux notées
                <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:appViewModel.byRate">
                                    <i class="fa fa-plus-XX"/>Tout voir
                </button> 
            </h2>
            
            <ul  class="categorie rig columns-5 light" 
                     data-bind="foreach: {data:appViewModel.bestRating , as: 'instance'}">

                    <li data-bind="template: { name: 'instance-template', data: instance }"></li> 
            </ul>
            
            <!-- <i class="fa fa-hand-o-right"></i> 
                <a href="#" 
                   data-bind="click:appViewModel.byRate" >Voir toutes les ressources, classées par leur notation</a>-->
                
          </div> 
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!--- -- -- -- TOP VIEW -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-8 topview" data-bind="visible:appViewModel.topView().length!=0">
         <div class="col-inner">
            <h2>
                <span class="fa-stack fa-lg puce">
                  <i class="fa fa-circle fa-stack-2x"></i>
                  <i class="fa fa-eye fa-stack-1x fa-inverse"></i>
                </span>
                Les plus visitées
                <button type="button" class="btn btn-success btn-sm pull-right" 
                                     data-bind="click:appViewModel.byView">
                                    <i class="fa fa-plus-XX"/>Tout voir
                </button> 
            </h2>
            
            <ul  class="categorie rig columns-5 light" 
                     data-bind="foreach: {data:appViewModel.topView , as: 'instance'}">

                    <li data-bind="template: { name: 'instance-template', data: instance }"></li> 
            </ul>
            
            <!-- <i class="fa fa-hand-o-right"></i> 
                <a href="#" 
                   data-bind="click:appViewModel.byView" >Voir toutes les ressources, des plus visitées au moins visitées</a>-->
            
          </div> 
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <div class="col-xs-12 col-sm-12 col-lg-12">
        </div>

        <!--- -- -- -- BIBLIOTHEQUES -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-6" data-bind="visible:appViewModel.AllInstances.children().length!=0">
            <h2>Bibliothèques</h2>
            <p>Vous disposez de <span data-bind="text:appViewModel.libraries().length"></span> bibliothèque<span data-bind="visible:appViewModel.libraries().length>0">s</span>, cliquez sur l'une d'entre elle pour voir les ressources</p>

            <ul data-bind="foreach: { data: appViewModel.libraries, as: 'library'}">
                <li>
                    <div>
                        <a href="#" data-bind="text:library.data.name,click: library.xToogle"></a>
                        <span data-bind="text: library.count, visible: count() != 0 " class="badge"></span>

                    </div>
                    <!-- <span>&nbsp;&nbsp;</span>
                    <small data-bind="text:library.data.description"></small> -->
                </li>
            </ul>
            <i class="fa fa-hand-o-right"></i><a href="#" data-bind="click:appViewModel.byLibraries" >Voir toutes les bibliothèques</a>
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->
        
        <!--- -- -- -- CATEGORIES / THEMES -- -- -- ---- -- --->
        <div class="col-xs-12 col-sm-6 col-lg-6" data-bind="visible:appViewModel.categories().length!=1 && appViewModel.AllInstances.children().length!=0 ">
            <h2>Thématiques</h2>
            <p>Les ressources sont classées par thème. Voici, la liste des thèmes</p>

            <ul class="nav" data-bind="foreach: { data: appViewModel.categories, as: 'category'}">
                <li data-bind="visible: category.count() != 0">
                    <div>
                        <i class="fa fa-circle" 
                           data-bind="style: { color: category.color}"></i>
                        <a href="#" data-bind="text:category.data.name,click: category.xToogle"></a>
                        &nbsp;<span data-bind="text: category.count, visible: category.count() != 0 " 
                              class="badge"></span>

                    </div>
                </li>
            </ul>
            <br>
            <i class="fa fa-hand-o-right"></i><a href="#" data-bind="click:appViewModel.byCategories" >Voir toutes les thèmatiques</a>
           
        </div>
        <!--- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --->

        

        
    </div>

</script>

<script id="categories-template" type="text/html">
        <!-- <div class="tool">
            <span>Tous</span>
            <span>Aucun</span>
            <span>Inverser</span>
        </div> -->
        <ul class="nav" data-bind="foreach: appViewModel.whCategories.children">
            <li data-bind="css: {  unchecked:!isChecked()},visible: count() != 0">
                <div data-bind="click: xToogle">
                    <span class="fa-stack fa-lg" data-bind="click: toogle">
                      <i class="fa fa-square-o fa-stack-2x"></i>
                      <i data-bind="visible: isChecked" class="fa fa-square"></i>
                      <i data-bind="visible: ! isChecked()" class="fa fa-square-o"></i>
                    </span>
                    <span class='name' data-bind="text: data.name"></span>
                     <span data-bind="text: count, visible: count() != 0 " class="badge pull-right"></span>
                </div>

           </li>
        
        </ul>
</script>

<script id="ressource-template" type="text/html">
        <div data-bind="style: { borderColor: ressource.category.color}">
        <i class="fa fa-square flag" data-bind="style: { color: ressource.category.color}">
        </i>
        <table xdata-bind="click: edit">
        
        <tr>
            <td class="libelle"  data-bind="text: ressource.data.name">

            </td>
        </tr>
        
        
        <tr>
            <td>
            <div class="icone" data-bind="style: { backgroundImage: ressource.bgUrl()}">
                
            </div>

            </td>
        <td class="titre">

        <h3>
        
            
        
            <span data-bind="text: ressource.data.name"></span>
            <button type="button" class="btn btn-primary btn-xs pull-right" 
                                     data-bind="click: ressource.instantiate,visible: ! data.error">
                                        <i class="fa fa-plus-circle"/>
            </button> 
            
            <span data-bind="visible:  data.error,click: ressource.showCatalogue" class="pull-right" style="color:red">
                <i class="fa fa-warning"/>
            <span>

        </h3>
        <p data-bind="html: ressource.data.description"></p>
        </td>
        </tr>
        <tr>
           <td colspan="3" >
                
                <div class="subscribe alert-warning" data-bind="visible:data.subscribe">
                    <span class="fa-stack fa-lg">
                      <i class="fa fa-circle fa-stack-2x"></i>
                      <i class="fa fa-eur fa-stack-1x fa-inverse"></i>
                    </span>
                    Abonnement nécessaire&nbsp;
                    <span data-bind="text: depends()"></span>
                </div>
           
                <button type="button" class="btn btn-default btn-xs pull-right" 
                                     data-bind="click: ressource.access,visible: ! data.error">
                                        Visiter
                </button>
            </td>
        
        </tr>
        
        <tr class="bydate" >
            <td colspan="3" >
                 par <b data-bind="text:data.user.fullname"></b>
                  <span class="timeago" data-bind="attr:{ title: ressource.data.iso8601}"></span>
            </td>
        </tr>
            
        <tr>
            <td colspan="3" class="infos">
                <span >
                     <span class="star toolinfo"
                          data-bind="attr:  { id: 'instance-rating-'+data.id, score: ressource.rate }">
                     </span>

                    <span class="pull-right"
                          data-bind="visible: count()!=0,click: ressource.showComments" >
                        <span data-bind="text: count"></span><i class="fa fa-comment-o"></i>
                    </span>
                </span>

            </td>
        </tr>
        
       
        </table>


    </div>
</script>


<script id="instance-template" type="text/html">
        <div data-bind="style: { borderColor: category.color}">
        <i class="fa fa-square flag" data-bind="style: { color: category.color}">
        </i>
        <table data-bind="click: display">
        
        <tr>
            <td class="libelle"  data-bind="text: data.name">

            </td>
        </tr>
        
        
        <tr>
            <td>
            <div class="icone" data-bind="style: { backgroundImage: bgImageUrlStyle}, attr:{title:data.description}"  data-toggle="tooltip" data-placement="bottom">
                
                <!-- ko if: hasRessource() -->
                <div class="ribbon-wrapper-green">
                    <div class="ribbon-green" data-bind="text:data.ressource_name"></div>
                </div>
                <!-- /ko -->
            </div>

            </td>
        <td class="titre">

        <h3><a  target="_blank" data-bind="attr: {href: data.url}, text: data.name"></a></h3>
        <p data-bind="text: data.description"></p>
        </td>
        </tr>
    
        
        
        <tr class="bydate" >
            <td colspan="3" >
                 par <b data-bind="text:data.user.fullname"></b>
                 <span data-bind="visible: ! appViewModel.isGroupedByLibraries() ||  appViewModel.isAccueil()">dans <a data-bind="click:instance.showLib, text:instance.data.libraryName"></a></span>, <span class="timeago" data-bind="attr:{ title: instance.data.iso8601}"></span>
            </td>
        </tr>
       
        
        <tr>
            <!-- ko if: data.eval == undefined -->
            <td colspan="3" class="infos">
                <span >
                     <span class="star toolinfo" data-container='body'
                          data-toggle="tooltip" data-placement="bottom" 
                          title="Cliquer pour noter cette ressource" 
                          data-bind="click: instance.evaluate, 
                                     attr:  { id: 'instance-rating-'+data.id, score: instance.score }">
                     </span>

                     <span class="pull-right" data-bind="visible: access()!=0">
                        <span data-bind="text: access"></span><i class="fa fa-eye"></i>
                     </span>

                    <span class="pull-right"
                          data-bind="visible: count()!=0,click: showComments" >
                        <span data-bind="text: count"></span><i class="fa fa-comment-o"></i>
                    </span>
                </span>

            </td>
            <!-- /ko -->
        </tr>
        
       
        
        <!-- ko if: data.eval != undefined -->
        <tr>
            <td colspan="3" data-bind="with:instance.data.eval">
                <blockquote class="">
                  <small>
                    <span data-bind="text:user"></span>
                    ,<span data-bind="text:created"></span>
                   </small>
                   <span class="star toolinfo" 
                      data-bind="attr: { score: vote }">
                    </span>
                  <div data-bind="text:comment"></div>
                  
                </blockquote>
            </td>
        </tr>
        <!-- /ko -->

        </table>


    </div>
</script>

<script id="ressources-by-categories-template" type="text/html">

    <div  id="og-grid">
       <div  data-bind="foreach: { data: appViewModel.categoriesVisible, as: 'category'}">  
          <!-- ko if: category.filteredChildren().length != 0 -->     
              <span data-bind="text:category.name"></span>
              <ul  class="categorie rig columns-5" data-bind="foreach: { data: category.filteredChildren, as: 'instance'},
                                                      css: { light: appViewModel.mode()=='icon'},
                                                      visible: category.children().length>0">
                 <!-- ko if: instance.isLibraryVisible() -->                                      
                 <li data-bind="template: { name: 'instance-template', data: instance }"></li>                                            <!-- /ko -->
              </ul>
          <!-- /ko -->
       </div>
    </div>
    

</script>

<!-- LISTE DES RESSOURCES -->
<script id="ressources3-template" type="text/html">

<div  id="og-grid">

    <div data-bind="foreach: { data: appViewModel.whMain, as: 'group'}" >
        
        <div class="divgroup" data-bind="visible: group.filteredChildren().length>0 || (group.isWritable()&&isChecked())">
            <span  data-bind="text: group.data.name"></span>

            <!-- Block de gestion -->
            
            
            <div class="btn-group pull-left" 
                 data-bind="visible: group.isWritable()">


                <!-- Bouton de gestion de la library -->
                <button type="button" class="btn btn-primary btn-sm pull-right add" data-bind="click:group.gerer" >
                   <i class="fa fa-wrench"></i> 
                </button>&nbsp;

                <!-- Menu de gestion de la library -->
                <!-- <ul class="dropdown-menu" role="menu">
                        <li>
                            <a href="#" data-bind="click:group.selectRessources">
                                <i class="fa fa-plus"></i> Depuis un catalogue
                            </a>
                        </li>
                        <li>
                            <a href="#" data-bind="click: appViewModel.createRessource">
                                <i class="fa fa-star"></i> Créer nouvelle ressource
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li>
                            <a href="#" data-bind="click:group.gerer">
                                <i class="fa fa-wrench"></i> Gérer
                            </a>
                        </li>
                </ul> -->

            </div>
            <!-- Fin du block de gestion -->
        </div>
        
        <ul  class="rig columns-5" data-bind="foreach: { data: group.filteredChildren, as: 'instance'},
                                                  css: { light: appViewModel.mode()=='icon'},
                                                  visible: group.children().length>0">
                        
            <li data-bind="template: { name: 'instance-template', data: instance },visible:instance.isFiltered"></li>

            <!-- xko if: group.isWritable() && $index()==group.filteredChildren().length -1 -->
           <!-- <li>
                <div style="border-color:white">
                <i class="fa fa-square flag" style="color:white">
                </i>
                <table data-bind=""> 
                    <tr>
                        <td class="libelle">
                            Ajouter
                        </td>
                    </tr>
                    <tr>
                        <td>
                          <a href="#" data-bind="click:group.selectRessources">
                                        <i class="fa fa-plus"></i> Depuis un catalogue
                           </a>  
                           <br>
                           <a href="#" data-bind="click: appViewModel.createRessource">
                                        <i class="fa fa-star"></i> Créer nouvelle ressource
                           </a>
                        </td>
                    </tr>
                </table>
               
            </li> -->
            <!-- /xko -->

        </ul>
    
    </div>

</div>

</script>

<!-- LISTE DES RESSOURCES -->
<script id="ressources2-template" type="text/html">
        <div  id="og-grid">	
        <!--  Pour chaque library -->
        <div data-bind="foreach: { data: librariesVisible, as: 'library'}">
        
            <div class="main" data-bind="visible: library.children().length>0 || library.isWritable()">
                
                <!-- Entete de la lib -->
                <div class="libraryname">
                
                    <i class="fa fa-book"/>
                    <span  data-bind="text: library.name"></span>
                    
                    <!-- Block de gestion -->
                    <div class="btn-group pull-right" 
                         data-bind="visible:library.children().length>0 && library.isWritable()">
                        
                        <!-- Bouton de gestion de la library -->
                        <button type="button" data-toggle="dropdown" 
                                                class="dropdown-toggle btn btn-primary btn-sm pull-right add" >
                           <i class="fa fa-align-justify"></i> 
                        </button>
                        
                        <!-- Menu de gestion de la library -->
                        <ul class="dropdown-menu" role="menu">
                                <li>
                                    <a href="#" data-bind="click:library.selectRessources">
                                        <i class="fa fa-plus"></i> Depuis un catalogue
                                    </a>
                                </li>
                                <li>
                                    <a href="#" data-bind="click: appViewModel.createRessource">
                                        <i class="fa fa-star"></i> Créer nouvelle ressource
                                    </a>
                                </li>
                                <li class="divider"></li>
                                <li>
                                    <a href="#" data-bind="click:library.gerer">
                                        <i class="fa fa-wrench"></i> Gérer
                                    </a>
                                </li>
                        </ul>
                        
                    </div>
                    <!-- Fin du block de gestion -->
                        
                </div>
                <!-- Fin de l'entête -->
                
                <!-- Cadre indiquant q'aucune ressource n'est présente dans la lib -->
                <div data-bind="visible:library.children().length==0 && library.isWritable()">
                    <div class="alert alert-info">Vous ne disposez d'aucune ressource dans cette bibliothèque, cliquer sur   
                        <div class="btn-group" data-bind="visible: isWritable()">
                            <button type="button" data-toggle="dropdown" 
                                                    class="dropdown-toggle btn btn-primary btn-sm add" >
                               <i class="fa fa-plus"> Ajouter</i> 
                            </button>
                        
                            <ul class="dropdown-menu" role="menu">
                                    <li data-bind="css: { disabled: appViewModel.catalogues().length==0}">
                                        <a href="#" data-bind="click:library.selectRessources">
                                            <i class="fa fa-plus"></i> Depuis un catalogue
                                        </a>
                                    </li>
                                    <li><a href="#" data-bind="click: appViewModel.createRessource">
                                        <i class="fa fa-star"></i> Créer nouvelle ressource
                                        </a>
                                    </li>
                            </ul>
                        </div>
                        pour en ajouter.
        
                    </div>
                </div> 
                <!-- fin du cadre -->
                
                <ul  class="rig columns-5" data-bind="foreach: { data: library.filteredChildren, as: 'instance'},
                                                  css: { light: appViewModel.mode()=='icon'},
                                                  visible: library.children().length>0">
                                                  
                   
                                                  
                    <li data-bind="template: { name: 'instance-template', data: instance }"></li>
            </ul>
            </div>
        </div>
        </div>
    
    </script>

    <script id="evals-elements-template" type="text/html">
        <div class="list-group" data-bind="foreach: evals">
          <a href="#" class="list-group-item">
            <h4 class="list-group-item-heading">
                <span data-bind="text:user"></span>
                <span>, <small data-bind="text: created"></small></span>
                <span class="star toolinfo pull-right" 
                      data-bind="attr: { score: vote }">
                </span>
                
            </h4>
            <blockquote>
            <p class="list-group-item-text" data-bind="text: comment"></p>
            </blockquote>
          </a>
        </div>
    </script>
    
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="select-ressources-template" type="text/html">
        <table cellpadding="0" cellspacing="0" border="0" class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>
                        <div data-bind="template: { name: 'check-elements-template'}" class="check" ></div>
                    </th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }, visible: ! data.error && actif()">
                    <td><img data-bind="attr: {src: logoUrl()}" class="logo"/></td>
                    <td data-bind="text: data.name"></td>
                    <td>
                        <div  data-bind="text: data.description"></div>
                        <div class="subscribe alert-warning" data-bind="visible:data.subscribe">
                            <span class="fa-stack fa-lg">
                              <i class="fa fa-circle fa-stack-2x"></i>
                              <i class="fa fa-eur fa-stack-1x fa-inverse"></i>
                            </span>
                            Abonnement nécessaire&nbsp;
                            <span data-bind="text: depends()"></span>
                        </div>
                        
                        <div class="form-group" data-bind="visible: hasParams()">
                            <br>
                            <!-- <label for="description" class="col-sm-2 control-label">Paramètres</label> -->
                            
                            <div class="col-sm-10" data-bind="visible: isChecked()">
                              <table data-bind="foreach: params" class="table-striped">
                                <tr>
                                    <td data-bind="text: $data"></td>
                                    <td>&nbsp;&nbsp;</td>
                                    <td><input type="text" type="text" class="form-control param"  
                                                data-bind="attr: {label:$data,name:$data,required:$parent.required,ressourceid:$parent.id}" 
                                                data-validation-required-message="paramètre obligatoire"><p class="help-block"></p>
                                    </td>
                                </tr>
                              </table>
                            </div>
                          </div>
                
                    </td>
                    <td>
                       <div data-bind="template: { name: 'check-element-template'}" class="check" ></div>       
                    </td>
                    
                </tr>
            </tbody>
        </table>      
    </script> 
    
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="simple-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Nombre d'éléments</th>
                    <th>Propriétaire</th>
                    <th data-bind="visible: appViewModel.hasMultipleContext">Etablissement</th>
                    <th></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }">
                    <td>
                       <i data-bind="visible: !isOwner() && isWritable()" class="fa fa-unlock" title=""/> 
                       <i data-bind="visible: !isOwner() && !isWritable()" class="fa fa-lock" title="Accès restreint"/> 
                    </td>
                    <td data-bind="text: name"></td>
                    <td data-bind="html: description"></td>
                    <td data-bind="text: total"></td> 
                    <td data-bind="text: user"></td>
                    <td data-bind="visible: appViewModel.hasMultipleContext, text: displayContext"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                    </td>
                    
                </tr>
            </tbody>
        </table>      
    </script>
    
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="parameter-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Valeur</th>
                    <th></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }">
                    <td data-bind="text: data.name"></td>
                    <td data-bind="text: data.value"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                    </td>
                </tr>
            </tbody>
        </table>      
    </script>    
 
    <!-- Template d'affichage d'une liste d'éléménts simple -->
    <script id="profil-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Conditions</th>
                    <th></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id },click: edit">
                    <td data-bind="text: data.name"></td>
                    <td data-bind="html: data.human"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                    </td>
                </tr>
            </tbody>
        </table>      
    </script>
    
    <!-- Template d'affichage d'une liste de ressource -->
    <script id="catalogue-elements-template" type="text/html">
        <div data-bind="html:description" class="description"></div>
        
        <!-- CATALOGUE VOLUMINEUX -->
        <div data-bind="visible:isBig" class="big alert-info">
            Ce catalogue contient <b><span data-bind="text:total"></span></b> ressources. <span data-bind="visible: ! filter">Seulement les <b><span data-bind="text:children().length"></span> dernières</b> ressources sont affichées.<br /> Pour affiner l'affichage veuillez utiliser la zone de recherche.</span>
            <span data-bind="visible: filter"><b><span data-bind="text:children().length"></span></b> ressources trouvées</span><br />
            
            <div class="input-group">
                 <input data-bind="value:filter" type="text" class="form-control search" placeholder="rechercher par nom, description, url..." id="query" name="query" value="">
                <div class="input-group-btn">
                    
                    <button type="submit" class="btn btn-success go">
                        <span class="glyphicon glyphicon-search"></span> <span data-bind="visible:! filter">Rechercher</span>
                    </button>
                    <!-- ko if: filter -->
                    <button type="submit" class="btn btn-danger cancel">
                        <span class="glyphicon glyphicon glyphicon-remove"></span>
                    </button>
                    <!-- /ko -->
                </div>
			</div>
        </div>
        <!-- -- -- --- -- --- -- --- -- -- -->
    
        <table class="datatable table table-striped table-bordered catalogue-elements">
            <thead>
                <tr>
                    <th dt-visible="hide"></th>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Proposée par</th>
                    <th>Actif ?</th>
                    <th>Edition</th>
                    <th class='action'>Action</th>
                </tr>
            </thead>
            <tbody data-bind="foreach: { data: children}">
                <tr data-bind="attr: { 'data-id': data.id } , click: edit">
                    <td  data-bind="text:data.since"></td>
                    <td><img data-bind="attr: {'data-original': logoUrl()}" class="logo lazy"/></td>
                    <td><a href="#" data-bind="text: data.name,click: access" ></a></td>
                    <td>
                        <div data-bind="html: data.description"></div>
                        <div class="subscribe alert-warning" data-bind="visible:data.subscribe">
                            <span class="fa-stack fa-lg">
                              <i class="fa fa-circle fa-stack-2x"></i>
                              <i class="fa fa-eur fa-stack-1x fa-inverse"></i>
                            </span>
                            Abonnement nécessaire&nbsp;
                            <span data-bind="text: depends()"></span>
                        </div>
                        <div class="alert alert-danger" data-bind="visible: data.error">
                            L'url ne peut être correctement évaluée, car les paramètres suivants sont manquants:
                            <ul data-bind="foreach: { data: data.code_in_error, as : 'code'}">
                                <li>
                                    <span data-bind="text:code"></span>
                                    : <a data-bind="visible: appViewModel.user.isAdmin(),click: appViewModel.addParam">Créer</a>
                                    <span data-bind="visible: ! appViewModel.user.isAdmin()">Veuillez contacter l'administrateur</span>
                                </li>
                            </ul>
                            
                        </div>
                    </td>
                    <td data-bind="text: data.user.fullname"></td>
                    
                    <td>
                        <i class="fa fa-check-square fa-2x" 
                            data-bind="click: $data.desactivate, visible: actif() && ! data.error" ></i>
                        <i class="fa fa-square-o fa-2x" 
                            data-bind="click: $data.activate, visible: ! actif() && ! data.error" ></i>
                    </td>
                    
                    <td>
                        <i data-bind="click: trash,visible: isDeletable()"  class='fa fa-trash-o action' action='trash'/>
                         <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                    </td>
                    
                    <td>
                        <button type="button" data-toggle="tooltip" data-placement="bottom" title="Ajouter à une bibliothèque" class="btn btn-primary btn-sm add" 
                                     data-bind="click: instantiate,visible: ! data.error && actif()">
                                <i class="fa fa-cloud-download"></i>
                        </button>
                        
                    </td>
                </tr>
            </tbody>
        </table>      
    </script>    

    <!-- Template d'affichage d'une liste de ressource -->
    <script id="t2" type="text/html">
        <div data-bind="html:description" class="description"></div>
    
        <table class="datatable table table-striped table-bordered catalogue-elements">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Proposée par</th>
                    <th></th>
                    <th>Actif ?</th>
                    <th class='action'></th>
                </tr>
            </thead>
            <tbody data-bind="foreach: { data: children}">
                <tr data-bind="attr: { 'data-id': data.id } , click: edit">
                   <td><img data-bind="attr: {'data-original': logoUrl()}" class="logo lazy"/></td>
                   <td></td>
                   <td></td>
                   <td></td>
                   <td></td>
                   <td></td>
                   <td></td>
                </tr>
            </tbody>
        </table>      
    </script>    
    
    <script id="check-element-template" type="text/html">
        <div data-bind="click: toogle">
            <span class="fa-stack fa-lg" >
                <i class="fa fa-circle-o fa-stack-2x"></i>
                <i data-bind="visible: isChecked" class="fa fa-check fa-stack-1x"></i>
            </span>
        </div>   
    </script>
    
    <script id="check-elements-template" type="text/html">
        <div>
        <span class="fa-stack fa-lg" data-bind="click: toogleAll" >
            <i class="fa fa-circle-o fa-stack-2x"></i>
            <i data-bind="visible: allSelected" class="fa fa-check fa-stack-1x"></i>
        </span>   
        </div>
    </script>


 
    <!-- Template d'affichage d'une liste de ressource -->
    <script id="library-elements-template" type="text/html">
        <table class="datatable table table-striped table-bordered">
            <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Description</th>
                    <th>Catalogue</th>
                    <th>Ajouté par</th>
                    <th></th>
                    <th>
                        <div data-bind="template: { name: 'check-elements-template'}" class="check" ></div>
                    </th>
                </tr>
            </thead>
            <tbody data-bind="foreach: children">
                <tr data-bind="attr: { 'data-id': data.id }">
                    <td><img data-bind="attr: {src: data.logo}" class="logo"/></td>
                    <td data-bind="text: data.name"></td>
                    <td data-bind="text: data.description"></td>
                    <td><a data-bind="click: showCatalogue,
                                      text: catalogueName,
                                      visible: catalogue">
                        </a>
                    </td>
                    <td data-bind="text: owner()"></td>
                    <td>
                        <i data-bind="click: edit ,visible: isEditable()"  class='fa fa-edit action' action='edit'/>
                    </td>
                    <td>
                       <div data-bind="visible: isDeletable() ,template: { name: 'check-element-template'}" class="check" ></div>        
                    </td>
                </tr>
            </tbody>
        </table>      
    </script> 