#!/bin/bash
# Script d'execution autonomme

DIR="/tmp/econnect"

CURRENT=$(pwd)

die(){
    echo ""
    echo "$1 "
    echo "Plus d'infos dans $LOG"
    exit 1
}

LOG="/tmp/aaf2gar.log"
echo "" > $LOG

# Clone du projet
echo ""
echo -n "Récupération du projet sur la forge dev-eole.ac-dijon.fr "
if [ ! -d $DIR ]; then
 git clone https://dev-eole.ac-dijon.fr/git/envole-connecteur.git  $DIR >>$LOG 2>&1
 [ $? -ne 0 ] && die "Impossible de récupérer les sources"
fi
cd $DIR
git checkout patch  >>$LOG 2>&1
git pull $DIR >>$LOG 2>&1
[ $? -ne 0 ] && die "Impossible de récupérer les sources"

echo " OK"

# Suppression et recopie des nouvelles sources
[ -d aaf2gar ] && rm -rf aaf2gar
cp -a $DIR/src/econnect-1.2/aaf2gar $DIR

cd aaf2gar
echo ""
echo "Les scripts se trouvent ici : "$(pwd) 
echo ""
./aaf2gar.sh --aaf-path=$CURRENT $@
