<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:run="http://www.ac-reunion.fr/xsl/run">
<xsl:output method="xml" version="1.0"
    encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="GAR-ENT.xsd" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
	<xsl:variable name="ANONYMAT">
		<xsl:for-each  select="$CONFIG/ANONYMAT">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="GARPATH">
		<xsl:for-each  select="$CONFIG/GARPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="TMPPATH">
		<xsl:for-each  select="$CONFIG/TMPPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="eleves">
		<xsl:for-each  select="$CONFIG/eleves">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="ELVUUID">
		<xsl:for-each  select="$CONFIG/ELVUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="cheminELEVES" select="concat($AAFPATH,concat('?select=',$eleves))"/>
	<xsl:variable name="ELEVES" select="collection($cheminELEVES)"/>
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>

    <xsl:variable name="GARMatiereCodeLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>255</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="GARPersonNomPatroLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="GARPersonNomLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">70</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="GARPersonPrenomLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">35</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="GARPersonAutresPrenomsLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

	<xsl:function name="run:anonymatDateNaissance">
		<xsl:param name="chaine"/>
		<xsl:variable name="resultat">
		<xsl:choose>
					<xsl:when test="$ANONYMAT = 'oui'"
						><xsl:value-of select="substring($chaine, 1, 5)"
						/><xsl:value-of select="'01-01'"
						/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$chaine"/></xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$resultat"/>
	</xsl:function>	
	<xsl:function name="run:anonymat">
		<xsl:param name="chaine"/>
		<xsl:variable name="redacted" select="'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'"/>
		<xsl:variable name="resultat">
		<xsl:choose>
					<xsl:when test="$ANONYMAT = 'oui'"
						><xsl:value-of select="upper-case(substring($chaine, (string-length($chaine)), 1))"
						/><xsl:value-of select="substring($redacted, 1, (string-length($chaine)-2) )"
						/><xsl:value-of select="upper-case(substring($chaine, 1, 1))"
						/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$chaine"/></xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$resultat"/>
	</xsl:function>
<xsl:template match="/">
<men:GAR-ENT-Eleve
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="GAR-ENT.xsd"
    Version="">
    <xsl:for-each  select="($ELEVES)/ficAlimMENESR">
		<xsl:for-each select="addRequest/attributes">
			<xsl:variable name="GARPersonProfilsPrepare">
				<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
					<xsl:variable name="ID" select="value"/>
					<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
					<xsl:if test = "$RNE != ''">
				<men:GARPersonProfils>		
					<men:GARStructureUAI><xsl:value-of select="normalize-space($RNE)"/></men:GARStructureUAI>
					<men:GARPersonProfil>National_elv</men:GARPersonProfil>
				</men:GARPersonProfils>		
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test = "$GARPersonProfilsPrepare != ''">
				<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
	<men:GAREleve>
	<men:GARPersonIdentifiant><xsl:copy-of select="$ELVUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/>
	</men:GARPersonIdentifiant>
	<xsl:copy-of select="$GARPersonProfilsPrepare" />
	<men:GARPersonNomPatro><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='ENTPersonNomPatro'], 1, $GARPersonNomPatroLength)))"/></men:GARPersonNomPatro>
	<men:GARPersonNom><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='sn'], 1, $GARPersonNomLength)))"/></men:GARPersonNom>
	<men:GARPersonPrenom><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='givenName'], 1, $GARPersonPrenomLength)))"/></men:GARPersonPrenom>
	<xsl:choose>
		<xsl:when test="$VERSION = '1.5.4'"></xsl:when>
		<xsl:otherwise>
	<men:GARPersonAutresPrenoms><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='givenName'], 1, $GARPersonAutresPrenomsLength)))"/></men:GARPersonAutresPrenoms>
		</xsl:otherwise>
	</xsl:choose>	
	<xsl:for-each select="attr[@name='ENTPersonAutresPrenoms']/value">
	<men:GARPersonAutresPrenoms><xsl:value-of select="run:anonymat(substring(., 1, $GARPersonAutresPrenomsLength))"/></men:GARPersonAutresPrenoms>
	</xsl:for-each>
	<men:GARPersonCivilite><xsl:choose><xsl:when test="attr[@name='personalTitle'] = 'Mlle'">Mme</xsl:when><xsl:otherwise><xsl:value-of select="normalize-space(attr[@name='personalTitle'])"/></xsl:otherwise></xsl:choose></men:GARPersonCivilite>
	<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
		<xsl:variable name="ID" select="value"/>
		<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
		<xsl:if test = "$RNE != ''">
		<men:GARPersonStructRattach><xsl:value-of select="normalize-space($RNE)"/></men:GARPersonStructRattach>
		</xsl:if>
	</xsl:for-each>
	<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
		<xsl:variable name="ID" select="value"/>
		<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
		<xsl:if test = "$RNE != ''">
		<men:GARPersonEtab><xsl:value-of select="normalize-space($RNE)"/></men:GARPersonEtab>
		</xsl:if>
	</xsl:for-each>
	<xsl:variable name="datedenaissance" select="normalize-space(attr[@name='ENTPersonDateNaissance'])"/>
	<xsl:variable name="jour" select="substring-before($datedenaissance,'/')"/>
	<xsl:variable name="mois" select="substring-before(substring-after($datedenaissance,'/'),'/')"/>
	<xsl:variable name="annee" select="substring-after(substring-after($datedenaissance,'/'),'/')"/>
	<xsl:if test = "($jour != '') and ($mois != '') and ($annee != '')">
	<men:GARPersonDateNaissance><xsl:value-of select="run:anonymatDateNaissance(concat($annee,'-',$mois,'-',$jour))"/></men:GARPersonDateNaissance>
	</xsl:if>
	</men:GAREleve>
			</xsl:if>	
		</xsl:for-each>
	</xsl:for-each>

    <xsl:for-each  select="($ELEVES)/ficAlimMENESR">
		<xsl:for-each select="addRequest/attributes">
			<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
	<men:GARPersonMEF>
			<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
				<xsl:variable name="ID" select="value"/>
				<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
				<xsl:if test = "$RNE != ''">
		<men:GARStructureUAI><xsl:value-of select="normalize-space($RNE)"/></men:GARStructureUAI>
				</xsl:if>
			</xsl:for-each>
		<men:GARPersonIdentifiant><xsl:copy-of select="$ELVUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></men:GARPersonIdentifiant>
		<men:GARMEFCode><xsl:value-of select="normalize-space(attr[@name='ENTEleveMEF'])"/></men:GARMEFCode>
	</men:GARPersonMEF>		
		</xsl:for-each>
	</xsl:for-each>

    <xsl:for-each  select="($ELEVES)/ficAlimMENESR">
		<xsl:for-each select="addRequest/attributes">
			<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
			<xsl:variable name="GARStructureUAI">
				<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
					<xsl:variable name="ID" select="value"/>
					<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
					<xsl:if test = "$RNE != ''">
					<men:GARStructureUAI><xsl:value-of select="normalize-space($RNE)"/></men:GARStructureUAI>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:for-each select="attr[@name='ENTEleveCodeEnseignements']/value">
			<xsl:variable name="code" select="."/>
			<xsl:if test = "$code != ''">
		<men:GAREleveEnseignement>
			<xsl:copy-of select="$GARStructureUAI"/>
			<men:GARPersonIdentifiant><xsl:copy-of select="$ELVUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></men:GARPersonIdentifiant>
			<men:GARMatiereCode><xsl:value-of select="normalize-space(substring($code, 1, $GARMatiereCodeLength))"/></men:GARMatiereCode>
		</men:GAREleveEnseignement>
			</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:for-each>
	
</men:GAR-ENT-Eleve>
</xsl:template>
</xsl:stylesheet>
