<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
	<xsl:variable name="TMPPATH">
		<xsl:for-each  select="$CONFIG/TMPPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
    <xsl:variable name="ENSUUID">
		<xsl:for-each  select="$CONFIG/ENSUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="personnels">
		<xsl:for-each  select="$CONFIG/personnels">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="cheminPERSONNELS" select="concat($AAFPATH,concat('.?select=',$personnels))"/>
	<xsl:variable name="PERSONNELS" select="collection($cheminPERSONNELS)"/>
	<xsl:variable name="cheminGARETABLISSEMENTS" select="concat('file://',concat($TMPPATH,'GAR_TMP_Etab.xml'))"/>	
	<xsl:variable name="GARETABLISSEMENTS" select="document($cheminGARETABLISSEMENTS)"/>	
	
<xsl:template match="/">
<xsl:variable name="vPass1">
<LISTE>

<xsl:for-each  select="($PERSONNELS)/ficAlimMENESR">
<xsl:for-each select="addRequest/attributes">
	<xsl:variable name="EtabRattach">
		<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
			<xsl:variable name="ID" select="value"/>
			<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
			<xsl:if test = "$RNE != ''"><xsl:value-of select="normalize-space($RNE)"/></xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$EtabRattach != ''">
		<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>	
		<xsl:for-each select="attr[@name='ENTAuxEnsMEF']/value">
		<xsl:variable name="chainemef" select="."/>
		<xsl:if test="$chainemef != '' ">
			<xsl:variable name="UID" select="concat($ENSUUID,'-',substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12))"/>
			<xsl:variable name="codeMEF" select="substring-before( substring-after ( $chainemef, '$'), '$')"/>
			<xsl:variable name="checkGAREtabMEF" select="($GARETABLISSEMENTS)/men:GAR-ENT-Etab/men:GARMEF[men:GARStructureUAI=$EtabRattach and men:GARMEFCode=$codeMEF]/men:GARMEFCode"/>
			<xsl:if test = "$checkGAREtabMEF != ''">
	 <PersonMEF>
		<ID><xsl:value-of select="concat($EtabRattach, '-', $UID, '-', $codeMEF)"/></ID>
	 	<RNE><xsl:value-of select="$EtabRattach"/></RNE>
		<UID><xsl:value-of select="$UID"/></UID>
		<MEF><xsl:value-of select="$codeMEF"/></MEF>
	 </PersonMEF>
			</xsl:if>
		</xsl:if>
		</xsl:for-each>
	</xsl:if>
</xsl:for-each>
</xsl:for-each>
</LISTE>
</xsl:variable>
<xsl:apply-templates select="$vPass1/*"/>
</xsl:template>

<xsl:template match="LISTE">
  <LISTE>
   <xsl:perform-sort select="*">
    <xsl:sort select="ID"/>
   </xsl:perform-sort>
  </LISTE>
</xsl:template>

</xsl:stylesheet>

  
