<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
	<xsl:variable name="TMPPATH">
		<xsl:for-each  select="$CONFIG/TMPPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
    <xsl:variable name="ENSUUID">
		<xsl:for-each  select="$CONFIG/ENSUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="personnels">
		<xsl:for-each  select="$CONFIG/personnels">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="cheminPERSONNELS" select="concat($AAFPATH,concat('.?select=',$personnels))"/>
	<xsl:variable name="PERSONNELS" select="collection($cheminPERSONNELS)"/>
	<xsl:variable name="cheminGARETABLISSEMENTS" select="concat('file://',concat($TMPPATH,'GAR_TMP_Etab.xml'))"/>	
	<xsl:variable name="GARETABLISSEMENTS" select="document($cheminGARETABLISSEMENTS)"/>	
	
<xsl:template match="/">
<LISTE>

<xsl:for-each  select="($PERSONNELS)/ficAlimMENESR">
<xsl:for-each select="addRequest/attributes">
	<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>	
	<xsl:variable name="EtabRattach">
		<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
			<xsl:variable name="ID" select="value"/>
			<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
			<xsl:if test = "$RNE != ''"><xsl:value-of select="normalize-space($RNE)"/></xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$EtabRattach != ''">
		<xsl:variable name="RNEProfilEnseignant">
			<xsl:for-each select="attr[@name='ENTPersonFonctions']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:variable name="IDUAI" select="substring-before(.,'$')"/>
				<xsl:variable name="precedent" select="concat(substring-before(preceding-sibling::value[1],'$'),substring-before(substring-after(preceding-sibling::value[1],'$'),'$'))"/>
				<xsl:variable name = "courant" select="concat(substring-before(.,'$'),substring-before(substring-after(.,'$'),'$'))"/>
				<xsl:if test="$precedent != $courant">	
					<xsl:variable name="VALRNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($IDUAI)]]/attr[@name='ENTStructureUAI']/value"/>
					<xsl:variable name="PROFIL">
						<xsl:choose>
							<xsl:when test = "$VALRNE != ''">
								<xsl:choose>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'DOC'">OK</xsl:when>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'ENS'">OK</xsl:when>
									<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test = "$PROFIL != 'HORSPERIMETRE'">
		<value><xsl:value-of select="normalize-space($IDUAI)"/></value>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:for-each select="attr[@name='ENTAuxEnsMEF']/value">
			<xsl:variable name="chainemef" select="."/>
			<xsl:if test="$chainemef != '' ">
				<xsl:variable name="UID" select="concat($ENSUUID,'-',substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12))"/>
				<xsl:variable name="codeMEF" select="substring-before( substring-after ( $chainemef, '$'), '$')"/>
				<!-- check etab dans le perimetre -->
				<xsl:variable name="EtabDansPerimetre" select="($RNEProfilEnseignant)[value=substring-before( $chainemef, '$')]/value" />
				<xsl:if test = "$EtabDansPerimetre != ''">
					<xsl:variable name="EtabMEF">
						<xsl:variable name="IDetab" select="substring-before( $chainemef, '$')"/>
						<xsl:variable name="RNEetab" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($IDetab)]]/attr[@name='ENTStructureUAI']/value"/>
						<xsl:if test = "$RNEetab != ''"><xsl:value-of select="normalize-space($RNEetab)"/></xsl:if>
					</xsl:variable>
					<xsl:variable name="checkGAREtabMEF" select="($GARETABLISSEMENTS)/men:GAR-ENT-Etab/men:GARMEF[men:GARStructureUAI=$EtabMEF and men:GARMEFCode=$codeMEF]/men:GARMEFCode"/>
					<xsl:if test = "$checkGAREtabMEF != ''">
						<xsl:if test = "$EtabMEF != ''">
			 <PersonMEF>
				<ID><xsl:value-of select="concat($EtabMEF, '-', $UID, '-', $codeMEF)"/></ID>
				<RNE><xsl:value-of select="$EtabMEF"/></RNE>
				<UID><xsl:value-of select="$UID"/></UID>
				<MEF><xsl:value-of select="$codeMEF"/></MEF>
			 </PersonMEF>
						</xsl:if>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:if>
</xsl:for-each>
</xsl:for-each>
</LISTE>
</xsl:template>
</xsl:stylesheet>

  
