<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	 xmlns:run="http://www.ac-reunion.fr/xsl/run">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
	<xsl:variable name="ANONYMAT">
		<xsl:for-each  select="$CONFIG/ANONYMAT">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="TMPPATH">
		<xsl:for-each  select="$CONFIG/TMPPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
    <xsl:variable name="ENSUUID">
		<xsl:for-each  select="$CONFIG/ENSUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="personnels">
		<xsl:for-each  select="$CONFIG/personnels">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="cheminPERSONNELS" select="concat($AAFPATH,concat('.?select=',$personnels))"/>
	<xsl:variable name="PERSONNELS" select="collection($cheminPERSONNELS)"/>
	<xsl:variable name="cheminSRC_PERSONMEF" select="concat('file://',concat($TMPPATH,'GAR_TMP_PersonMef_sorted.xml'))"/>
	<xsl:variable name="SRC_PERSONMEF" select="document($cheminSRC_PERSONMEF)/LISTE"/>

    <xsl:variable name="GARPersonNomPatroLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GARPersonNomLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">70</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GARPersonPrenomLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">35</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GARPersonAutresPrenomsLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GAREnsDisciplinePosteCodeLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">70</xsl:when>
            <xsl:otherwise>255</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

	<xsl:function name="run:anonymatDateNaissance">
		<xsl:param name="chaine"/>
		<xsl:variable name="resultat">
		<xsl:choose>
					<xsl:when test="$ANONYMAT = 'oui'"
						><xsl:value-of select="substring($chaine, 1, 5)"
						/><xsl:value-of select="'01-01'"
						/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$chaine"/></xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$resultat"/>
	</xsl:function>
	<xsl:function name="run:anonymat">
		<xsl:param name="chaine"/>
		<xsl:variable name="redacted" select="'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'"/>
		<xsl:variable name="resultat">
		<xsl:choose>
					<xsl:when test="$ANONYMAT = 'oui'"
						><xsl:value-of select="substring($chaine, (string-length($chaine)-1), 1)"
						/><xsl:value-of select="substring($redacted, 1, (string-length($chaine)-2) )"
						/><xsl:value-of select="substring($chaine, 1, 1)"
						/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$chaine"/></xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$resultat"/>
	</xsl:function>
	
<xsl:template match="/">
<men:GAR-ENT-Enseignant
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
<xsl:for-each  select="($PERSONNELS)/ficAlimMENESR">
<xsl:for-each select="addRequest/attributes">
	<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
	<xsl:variable name="EtabRattach">
		<xsl:for-each select="attr[@name='ENTPersonStructRattach']">
			<xsl:variable name="ID" select="value"/>
			<xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($ID)]]/attr[@name='ENTStructureUAI']/value"/>
			<xsl:if test = "$RNE != ''"><xsl:value-of select="normalize-space($RNE)"/></xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$VERSION = '1.8.0' or $EtabRattach != ''">
		<xsl:variable name="GARPersonProfilsSource">
			<LISTE>
			<xsl:for-each select="attr[@name='ENTPersonFonctions']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:variable name="IDUAI" select="substring-before(.,'$')"/>
				<xsl:variable name="precedent" select="concat(substring-before(preceding-sibling::value[1],'$'),substring-before(substring-after(preceding-sibling::value[1],'$'),'$'))"/>
				<xsl:variable name = "courant" select="concat(substring-before(.,'$'),substring-before(substring-after(.,'$'),'$'))"/>
				<xsl:if test="$precedent != $courant">	
					<xsl:variable name="VALRNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($IDUAI)]]/attr[@name='ENTStructureUAI']/value"/>
					<xsl:variable name="PROFIL">
						<xsl:choose>
							<xsl:when test = "$VALRNE != ''">
								<xsl:variable name="Fonction" select="substring-before(substring-after(.,'$'),'$')"/>
								<xsl:variable name="ListeFonctionsETA" select="'AES ASH ADF LAB ALB MDS CTR ASE ORI CFC'"/>
								<xsl:choose>
								<!--
								https://cache.media.eduscol.education.fr/file/ENT/75/3/SDET_Annexe-operationnelle_v6.3_1158753.pdf
								cf SDET_Annexe-operationnelle_v6.3 pages 96-97
								-->
									<xsl:when test="$Fonction = 'DIR'">National_dir</xsl:when>
									<xsl:when test="$Fonction = 'DOC'">National_doc</xsl:when>
									<xsl:when test="contains ( 'ENS ADA', $Fonction )">National_ens</xsl:when>
									<xsl:when test="contains ( 'EDU AED SUR', $Fonction )">National_evs</xsl:when>
									<xsl:when test="contains ( $ListeFonctionsETA, $Fonction )">National_eta</xsl:when>
									<!-- OUV = TOS géré par collectivités, en contradiction avec SDET : -->
									<xsl:when test="$Fonction = 'OUV'">National_col</xsl:when>
									<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test = "$PROFIL != 'HORSPERIMETRE'">
			<PROFIL>
				<IDPROFIL><xsl:value-of select="concat(normalize-space($VALRNE),normalize-space($PROFIL))" /></IDPROFIL>
				<UAI><xsl:value-of select="normalize-space($VALRNE)"/></UAI>
				<PersProfil><xsl:value-of select="normalize-space($PROFIL)"/></PersProfil>
			</PROFIL>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			</LISTE>
		</xsl:variable>
		<xsl:variable name="GARPersonProfilsTRI">
			<LISTE>
			<xsl:for-each select="($GARPersonProfilsSource)//LISTE/PROFIL">
				<xsl:sort select="IDPROFIL"/>
				<PROFIL>
					<IDPROFIL><xsl:value-of select="IDPROFIL"/></IDPROFIL>
					<UAI><xsl:value-of select="UAI"/></UAI>
					<PersProfil><xsl:value-of select="PersProfil"/></PersProfil>
				</PROFIL>
			</xsl:for-each>
			</LISTE>			
		</xsl:variable>		
		<xsl:variable name="GARPersonProfils">
			<xsl:for-each select="($GARPersonProfilsTRI)//LISTE/PROFIL">
				<xsl:variable name="precedent" select="string(preceding-sibling::PROFIL[1]/IDPROFIL)"/>
				<xsl:variable name = "courant" select="string(IDPROFIL)"/>
				<xsl:if test="$precedent != $courant">	
		<men:GARPersonProfils>
			<men:GARStructureUAI><xsl:value-of select="UAI"/></men:GARStructureUAI>
			<men:GARPersonProfil><xsl:value-of select="PersProfil"/></men:GARPersonProfil>
		</men:GARPersonProfils>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="courriel">
			<xsl:choose>
				<xsl:when test="$ANONYMAT = 'oui'">
					<xsl:for-each select="attr[@name='mail']/value">
						<value><xsl:value-of select="concat('noreply@',substring-after(normalize-space(.),'@'))"/></value>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
                    <xsl:for-each select="attr[@name='mail']/value">
						<value><xsl:value-of select="normalize-space(.)"/></value>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$GARPersonProfils != ''">
	<men:GAREnseignant>
		<men:GARPersonIdentifiant><xsl:copy-of select="$ENSUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></men:GARPersonIdentifiant>
	<xsl:copy-of select="$GARPersonProfils"/>
		<men:GARPersonNomPatro><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='ENTPersonNomPatro'], 1, $GARPersonNomPatroLength)))"/></men:GARPersonNomPatro>
		<men:GARPersonNom><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='sn'], 1, $GARPersonNomLength)))"/></men:GARPersonNom>
		<men:GARPersonPrenom><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='givenName'], 1, $GARPersonPrenomLength)))"/></men:GARPersonPrenom>
		<men:GARPersonAutresPrenoms><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='givenName'], 1, $GARPersonAutresPrenomsLength)))"/></men:GARPersonAutresPrenoms>
		<men:GARPersonCivilite><xsl:choose>
				 <xsl:when test="attr[@name='personalTitle'] = 'Mlle'">MM.</xsl:when>
				 <xsl:otherwise><xsl:value-of select="normalize-space(attr[@name='personalTitle'])"/></xsl:otherwise>
			 </xsl:choose></men:GARPersonCivilite>
		<xsl:if test="$EtabRattach != ''">
		<men:GARPersonStructRattach><xsl:copy-of select="$EtabRattach"/></men:GARPersonStructRattach>
		<men:GARPersonEtab><xsl:copy-of select="$EtabRattach"/></men:GARPersonEtab>
		</xsl:if>
		<xsl:variable name="datedenaissance" select="normalize-space(attr[@name='ENTPersonDateNaissance'])"/>
		<xsl:variable name="jour" select="substring-before($datedenaissance,'/')"/>
		<xsl:variable name="mois" select="substring-before(substring-after($datedenaissance,'/'),'/')"/>
		<xsl:variable name="annee" select="substring-after(substring-after($datedenaissance,'/'),'/')"/>
		<xsl:if test = "($jour != '') and ($mois != '') and ($annee != '')">
		<men:GARPersonDateNaissance><xsl:value-of select="run:anonymatDateNaissance(concat($annee,'-',$mois,'-',$jour))"/></men:GARPersonDateNaissance>
		</xsl:if>
		 <xsl:for-each select="attr[@name='ENTPersonFonctions']/value">
		 <xsl:variable name="chaine" select="."/>
		 <xsl:variable name="profilFonction" select="substring-before(substring-after(.,'$'),'$')"/>
		 <xsl:if test="($profilFonction = 'DOC') or ($profilFonction = 'ENS')">
			 <xsl:variable name="codediscipline" select="substring-before( substring-after ( substring-after ( substring-after ($chaine, '$'), '$'), '$'), '$')"/>
			 <xsl:if test="$codediscipline != '-'">
				 <xsl:variable name="iduai" select="substring-before( $chaine, '$')"/>
				 <xsl:variable name="RNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($iduai)]]/attr[@name='ENTStructureUAI']/value"/>
				 <xsl:if test = "$RNE != ''">
			<men:GAREnsDisciplinesPostes>
				<men:GARStructureUAI><xsl:value-of select="normalize-space($RNE)"/></men:GARStructureUAI>
				<men:GAREnsDisciplinePosteCode><xsl:value-of select="substring($codediscipline, 1, $GAREnsDisciplinePosteCodeLength)"/></men:GAREnsDisciplinePosteCode>
			</men:GAREnsDisciplinesPostes>
				</xsl:if>
			</xsl:if>
		</xsl:if>			
		</xsl:for-each>
		<xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'"></xsl:when>
            <xsl:otherwise>
				<xsl:for-each select="$courriel/value">
		<men:GARPersonMail><xsl:value-of select="."/></men:GARPersonMail>
				</xsl:for-each>
			</xsl:otherwise>
        </xsl:choose>
	</men:GAREnseignant>
		</xsl:if>
	</xsl:if>	
</xsl:for-each>
</xsl:for-each>
<xsl:for-each  select="($SRC_PERSONMEF)/PersonMEF">
	 <xsl:sort select="ID"/>
	 <xsl:variable name="precedent" select="string(preceding-sibling::PersonMEF[1]/ID)"/>
	 <xsl:variable name = "courant" select="string(ID)"/>
	 <xsl:if test="$precedent != $courant">	
	 <men:GARPersonMEF>
	 	<men:GARStructureUAI><xsl:value-of select="RNE"/></men:GARStructureUAI>
		<men:GARPersonIdentifiant><xsl:value-of select="UID"/></men:GARPersonIdentifiant>
		<men:GARMEFCode><xsl:value-of select="MEF"/></men:GARMEFCode>
	 </men:GARPersonMEF>
	 </xsl:if>
</xsl:for-each>
</men:GAR-ENT-Enseignant>
</xsl:template>
</xsl:stylesheet>
