<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="TMPPATH">
		<xsl:for-each  select="$CONFIG/TMPPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>

	<xsl:variable name="cheminSRC_Matieres" select="concat('file://',concat($TMPPATH,'GAR_TMP_Matieres_sorted.xml'))"/>	
	<xsl:variable name="SRC_Matieres" select="document($cheminSRC_Matieres)/Matieres"/>
	<xsl:variable name="cheminSRC_MEFS" select="concat('file://',concat($TMPPATH,'GAR_TMP_MEFS_sorted.xml'))"/>	
    <xsl:variable name="SRC_MEFS" select="document($cheminSRC_MEFS)/MEFS"/>
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>

    <xsl:variable name="GARMatiereCodeLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>255</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GARMatiereLibelleLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>255</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GARStructureNomCourantLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">70</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="iteration" select="0"/>
<xsl:template match="/">
<men:GAR-ENT-Etab
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="compteur" select="($iteration) + position()"/>
		<xsl:variable name="type" select="attr[@name='ENTStructureTypeStruct']/value"/>
		<xsl:if test="contains($type,'COLLEGE') or contains($type,'LYCEE')">
		<men:GAREtab>
			<men:GARStructureUAI><xsl:value-of select="attr[@name='ENTStructureUAI']"/></men:GARStructureUAI>
			<men:GARStructureNomCourant><xsl:value-of select="substring(attr[@name='ENTStructureNomCourant'], 1, $GARStructureNomCourantLength)"/></men:GARStructureNomCourant>
			<men:GAREtablissementStructRattachFctl><xsl:value-of select="attr[@name='ENTEtablissementStructRattachFctl']"/></men:GAREtablissementStructRattachFctl>
			<men:GARStructureContrat><xsl:value-of select="attr[@name='ENTEtablissementContrat']"/></men:GARStructureContrat>
			<men:GARStructureTelephone><xsl:value-of select="attr[@name='telephoneNumber']"/></men:GARStructureTelephone>
			<men:GARStructureEmail><xsl:value-of select="attr[@name='ENTStructureEmail']"/></men:GARStructureEmail>
		</men:GAREtab>
		</xsl:if>
	</xsl:for-each>
</xsl:for-each>
<xsl:for-each select="($SRC_MEFS)/MEF">
	<xsl:sort select="ID"/>
		<xsl:variable name="precedent" select="string(preceding-sibling::MEF[1]/ID)"/>
		<xsl:variable name = "courant" select="string(ID)"/>
		<xsl:if test="$precedent != $courant">	
	<men:GARMEF>
		<men:GARStructureUAI><xsl:value-of select="RNE"/></men:GARStructureUAI>
		<men:GARMEFCode><xsl:value-of select="Code"/></men:GARMEFCode>
		<men:GARMEFLibelle><xsl:value-of select="Libelle"/></men:GARMEFLibelle>
	<xsl:choose>
		<xsl:when test="$VERSION = '1.5.4'"></xsl:when>
		<xsl:otherwise>
		<men:GARMEFRattach><xsl:value-of select="Rattach"/></men:GARMEFRattach>
		<men:GARMEFSTAT11><xsl:value-of select="MefStat11"/></men:GARMEFSTAT11>
		</xsl:otherwise>
	</xsl:choose>		
	</men:GARMEF>
		</xsl:if>
</xsl:for-each>
<xsl:for-each select="($SRC_Matieres)/Matiere">
	<xsl:sort select="ID"/>
		<xsl:variable name="precedent" select="string(preceding-sibling::Matiere[1]/ID)"/>
		<xsl:variable name = "courant" select="string(ID)"/>
		<xsl:if test="$precedent != $courant">	
	<men:GARMatiere>
		<men:GARStructureUAI><xsl:value-of select="RNE"/></men:GARStructureUAI>
		<men:GARMatiereCode><xsl:value-of select="substring(Code, 1, $GARMatiereCodeLength)"/></men:GARMatiereCode>
		<men:GARMatiereLibelle><xsl:value-of select="substring(Libelle, 1, $GARMatiereLibelleLength)"/></men:GARMatiereLibelle>
	</men:GARMatiere>
		</xsl:if>
</xsl:for-each>
</men:GAR-ENT-Etab>
</xsl:template>
 </xsl:stylesheet>
