<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
    encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
	<xsl:variable name="VERSION">
		<xsl:for-each  select="$CONFIG/VERSION">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="TMPPATH">
		<xsl:for-each  select="$CONFIG/TMPPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="eleves">
		<xsl:for-each  select="$CONFIG/eleves">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="ELVUUID">
		<xsl:for-each  select="$CONFIG/ELVUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="personnels">
		<xsl:for-each  select="$CONFIG/personnels">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
    <xsl:variable name="ENSUUID">
		<xsl:for-each  select="$CONFIG/ENSUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	

	<xsl:variable name="cheminELEVES" select="concat($AAFPATH,concat('.?select=',$eleves))"/>	
	<xsl:variable name="ELEVES" select="collection($cheminELEVES)"/>
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="cheminPERSONNELS" select="concat($AAFPATH,concat('.?select=',$personnels))"/>
	<xsl:variable name="PERSONNELS" select="collection($cheminPERSONNELS)"/>
	<xsl:variable name="cheminSRC_GROUPES" select="concat('file://',concat($TMPPATH,'GAR_TMP_Groupe_sorted.xml'))"/>	
	<xsl:variable name="SRC_GROUPES" select="document($cheminSRC_GROUPES)/LISTE"/>		

    <xsl:variable name="GARMatiereCodeLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>255</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GARGroupeCodeLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>255</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

	<xsl:variable name="iteration" select="0"/>
<xsl:template match="/">
<men:GAR-ENT-Groupe
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
	
<xsl:for-each select="($SRC_GROUPES)/GROUPES">
	<xsl:sort select="ID"/>
	<xsl:variable name="precedent" select="string(preceding-sibling::GROUPES[1]/ID)"/>
	<xsl:variable name = "courant" select="string(ID)"/>
	<xsl:if test="$precedent != $courant">	
<men:GARGroupe>	
		<men:GARGroupeCode><xsl:value-of select="substring(CodeGroupe, 1, $GARGroupeCodeLength)"/></men:GARGroupeCode>
		<men:GARStructureUAI><xsl:value-of select="RNE"/></men:GARStructureUAI>
		<men:GARGroupeLibelle><xsl:value-of select="LibelleGroupe"/></men:GARGroupeLibelle>
		<xsl:variable name = "GroupeType" select="StatutGroupe"/>
		<men:GARGroupeStatut><xsl:value-of select="$GroupeType"/></men:GARGroupeStatut>
		<xsl:if test="$GroupeType != 'DIVISION'">
			<xsl:for-each select="DivAppartenance">
		<men:GARGroupeDivAppartenance><xsl:value-of select="."/></men:GARGroupeDivAppartenance>
			</xsl:for-each>
		</xsl:if>
</men:GARGroupe>	
	</xsl:if>
</xsl:for-each>

<xsl:for-each select="($SRC_GROUPES)/PERSONGROUPES">
	<xsl:sort select="ID"/>
	<xsl:variable name="precedent" select="string(preceding-sibling::PERSONGROUPES[1]/ID)"/>
	<xsl:variable name = "courant" select="string(ID)"/>
	<xsl:if test="$precedent != $courant">	
<men:GARPersonGroupe>
	<men:GARStructureUAI><xsl:value-of select="RNE"/></men:GARStructureUAI>
	<men:GARPersonIdentifiant><xsl:value-of select="identifiant"/></men:GARPersonIdentifiant>
	<men:GARGroupeCode><xsl:value-of select="substring(CodeGroupe, 1, $GARGroupeCodeLength)"/></men:GARGroupeCode>
</men:GARPersonGroupe>
	</xsl:if>
</xsl:for-each>

<xsl:for-each select="($SRC_GROUPES)/GRPMATIERES">
	<xsl:sort select="ID"/>
	<xsl:variable name="precedent" select="string(preceding-sibling::GRPMATIERES[1]/ID)"/>
	<xsl:variable name = "courant" select="string(ID)"/>
	<xsl:if test="$precedent != $courant">	
<men:GAREnsGroupeMatiere>
	<men:GARStructureUAI><xsl:value-of select="RNE"/></men:GARStructureUAI>
	<men:GARPersonIdentifiant><xsl:value-of select="identifiant"/></men:GARPersonIdentifiant>
	<men:GARGroupeCode><xsl:value-of select="substring(CodeGroupe, 1, $GARGroupeCodeLength)"/></men:GARGroupeCode>
	<xsl:for-each select="CodeMatiere">
	<men:GARMatiereCode><xsl:value-of select="substring(., 1, $GARMatiereCodeLength)"/></men:GARMatiereCode>
	</xsl:for-each>
</men:GAREnsGroupeMatiere>
	</xsl:if>
</xsl:for-each>

<xsl:for-each select="($SRC_GROUPES)/CLASSEMATIERES">
	<xsl:sort select="ID"/>
	<xsl:variable name="precedent" select="string(preceding-sibling::CLASSEMATIERES[1]/ID)"/>
	<xsl:variable name = "courant" select="string(ID)"/>
	<xsl:if test="$precedent != $courant">	
<men:GAREnsClasseMatiere>
	<men:GARStructureUAI><xsl:value-of select="RNE"/></men:GARStructureUAI>
	<men:GARPersonIdentifiant><xsl:value-of select="identifiant"/></men:GARPersonIdentifiant>
	<men:GARGroupeCode><xsl:value-of select="substring(CodeGroupe, 1, $GARGroupeCodeLength)"/></men:GARGroupeCode>
	<xsl:for-each select="CodeMatiere">
	<men:GARMatiereCode><xsl:value-of select="substring(., 1, $GARMatiereCodeLength)"/></men:GARMatiereCode>
	</xsl:for-each></men:GAREnsClasseMatiere>
	</xsl:if>
</xsl:for-each>
</men:GAR-ENT-Groupe>
</xsl:template>
</xsl:stylesheet>
