<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
     <xsl:output method="xml" version="1.0"
          encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />

<!-- tri de chaque partie des groupes  -->
<xsl:template match="/">
<LISTE
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
<xsl:for-each select="/LISTE/GROUPES">
	<xsl:sort select="ID"/>
	<GROUPES>
		<ID><xsl:value-of select="ID"/></ID>
		<CodeGroupe><xsl:value-of select="CodeGroupe"/></CodeGroupe>
		<RNE><xsl:value-of select="RNE"/></RNE>
		<LibelleGroupe><xsl:value-of select="LibelleGroupe"/></LibelleGroupe>
		<StatutGroupe><xsl:value-of select="StatutGroupe"/></StatutGroupe>
		<xsl:for-each select="DivAppartenance">
		<xsl:copy-of select="."/>
		</xsl:for-each>
	</GROUPES>
</xsl:for-each>
<xsl:for-each select="/LISTE/PERSONGROUPES">
	<xsl:sort select="ID"/>
	<PERSONGROUPES>
		<ID><xsl:value-of select="ID"/></ID>
		<RNE><xsl:value-of select="RNE"/></RNE>
		<identifiant><xsl:value-of select="identifiant"/></identifiant>
		<CodeGroupe><xsl:value-of select="CodeGroupe"/></CodeGroupe>
	</PERSONGROUPES>
</xsl:for-each>
<xsl:for-each select="/LISTE/GRPMATIERES">
	<xsl:sort select="ID"/>
	<xsl:variable name = "courant" select="string(ID)"/>
	<xsl:variable name = "CodeMatiere" select="string(CodeMatiere)"/>
	<xsl:variable name="Matiere">
		<xsl:for-each select="/LISTE/GRPMATIERES[ID=$courant]">
		<CodeMatiere><xsl:value-of select="CodeMatiere"/></CodeMatiere>
		</xsl:for-each>		
	</xsl:variable>
	<xsl:variable name="IDMatiere">
		<xsl:for-each select="/LISTE/GRPMATIERES[ID=$courant]"><xsl:value-of select="CodeMatiere"/></xsl:for-each>
	</xsl:variable>
		<GRPMATIERES>
			<ID><xsl:value-of select="concat($courant,'-',$IDMatiere)"/></ID>
			<RNE><xsl:value-of select="RNE"/></RNE>
			<identifiant><xsl:value-of select="identifiant"/></identifiant>
			<CodeGroupe><xsl:value-of select="CodeGroupe"/></CodeGroupe>
			<xsl:for-each select="$Matiere/CodeMatiere">
				<xsl:sort select="CodeMatiere"/>
				<xsl:variable name="precedent" select="string(preceding-sibling::CodeMatiere[1])"/>
				<xsl:variable name = "courant" select="string(.)"/>
				<xsl:if test="$precedent != $courant">	
				<CodeMatiere><xsl:value-of select="."/></CodeMatiere>
				</xsl:if>
			</xsl:for-each>
		</GRPMATIERES>
</xsl:for-each>
<xsl:for-each select="/LISTE/CLASSEMATIERES">
	<xsl:sort select="ID"/>
	<xsl:variable name = "courant" select="string(ID)"/>
	<xsl:variable name = "CodeMatiere" select="string(CodeMatiere)"/>
	<xsl:variable name="Matiere">
		<xsl:for-each select="/LISTE/CLASSEMATIERES[ID=$courant]"><CodeMatiere><xsl:value-of select="CodeMatiere"/></CodeMatiere></xsl:for-each>		
	</xsl:variable>
	<xsl:variable name="IDMatiere">
		<xsl:for-each select="/LISTE/CLASSEMATIERES[ID=$courant]"><xsl:value-of select="CodeMatiere"/></xsl:for-each>
	</xsl:variable>
		<CLASSEMATIERES>
			<ID><xsl:value-of select="concat($courant,'-',$IDMatiere)"/></ID>
			<RNE><xsl:value-of select="RNE"/></RNE>
			<identifiant><xsl:value-of select="identifiant"/></identifiant>
			<CodeGroupe><xsl:value-of select="CodeGroupe"/></CodeGroupe>
			<xsl:for-each select="$Matiere/CodeMatiere">
				<xsl:sort select="CodeMatiere"/>
				<xsl:variable name="precedent" select="string(preceding-sibling::CodeMatiere[1])"/>
				<xsl:variable name = "courant" select="string(.)"/>
				<xsl:if test="$precedent != $courant">	
				<CodeMatiere><xsl:value-of select="."/></CodeMatiere>
				</xsl:if>
			</xsl:for-each>
		</CLASSEMATIERES>
</xsl:for-each>
</LISTE>
</xsl:template>
</xsl:stylesheet>
