<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
    encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="TMPPATH">
		<xsl:for-each  select="$CONFIG/TMPPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="eleves">
		<xsl:for-each  select="$CONFIG/eleves">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="ELVUUID">
		<xsl:for-each  select="$CONFIG/ELVUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="personnels">
		<xsl:for-each  select="$CONFIG/personnels">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
    <xsl:variable name="ENSUUID">
		<xsl:for-each  select="$CONFIG/ENSUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	

	<xsl:variable name="cheminELEVES" select="concat($AAFPATH,concat('.?select=',$eleves))"/>	
	<xsl:variable name="ELEVES" select="collection($cheminELEVES)"/>
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="cheminGARETABLISSEMENTS" select="concat('file://',concat($TMPPATH,'GAR_TMP_Etab.xml'))"/>	
	<xsl:variable name="GARETABLISSEMENTS" select="document($cheminGARETABLISSEMENTS)"/>		
	<xsl:variable name="cheminPERSONNELS" select="concat($AAFPATH,concat('.?select=',$personnels))"/>
	<xsl:variable name="PERSONNELS" select="collection($cheminPERSONNELS)"/>

    <xsl:variable name="GARMatiereCodeLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">45</xsl:when>
            <xsl:otherwise>255</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

	<xsl:variable name="iteration" select="0"/>
<xsl:template match="/">
<LISTE
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
	

<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="RNE" select="attr[@name='ENTStructureUAI']/value"/>
		<xsl:variable name="type" select="attr[@name='ENTStructureTypeStruct']/value"/>
		<xsl:if test="contains($type,'COLLEGE') or contains($type,'LYCEE')">
			<xsl:for-each select="attr[@name='ENTStructureClasses']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:if test="$chaine != ''">
					<xsl:variable name="CodeClasse" select="substring-before( $chaine, '$')"/>
					<xsl:variable name="LibelleTMP" select="substring-before( substring-after( $chaine, '$'), '$')"/>
					<xsl:variable name="LibelleClasse">
						<xsl:choose>
						<xsl:when test="$LibelleTMP = ''"><xsl:value-of select="$CodeClasse"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$LibelleTMP"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
	<GROUPES>
		<ID><xsl:value-of select="concat('DIVISION-',$RNE,'-',$CodeClasse)"/></ID>
		<CodeGroupe><xsl:copy-of select="$CodeClasse"/></CodeGroupe>
		<RNE><xsl:value-of select="$RNE"/></RNE>
		<LibelleGroupe><xsl:copy-of select="$LibelleClasse"/></LibelleGroupe>
		<StatutGroupe>DIVISION</StatutGroupe>
		<DivAppartenance/>
	</GROUPES>					
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:for-each>
</xsl:for-each>	
<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="RNE" select="attr[@name='ENTStructureUAI']/value"/>
		<xsl:variable name="type" select="attr[@name='ENTStructureTypeStruct']/value"/>
		<xsl:if test="contains($type,'COLLEGE') or contains($type,'LYCEE')">	
			<xsl:for-each select="attr[@name='ENTStructureGroupes']/value">
			<xsl:variable name="chaine" select="."/>
			<xsl:if test="$chaine != ''">
				<xsl:variable name="CodeGroupe" select="substring-before( $chaine, '$')"/>
                <xsl:variable name="Libelle" select="substring-before( substring-after( $chaine, '$'), '$')"/>
                <xsl:variable name="LibelleGroupe">
                    <xsl:choose>
                        <xsl:when test="$Libelle = ''"><xsl:copy-of select="$CodeGroupe"/></xsl:when>
                        <xsl:otherwise><xsl:copy-of select="$Libelle"/></xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
				<xsl:variable name="ParentGroupe" select="substring-after ( substring-after( $chaine, '$'), '$')"/>

	<GROUPES>
		<ID><xsl:value-of select="concat('GROUPE-',$RNE,'-',$CodeGroupe)"/></ID>
		<CodeGroupe><xsl:copy-of select="$CodeGroupe"/></CodeGroupe>
		<RNE><xsl:value-of select="$RNE"/></RNE>
		<LibelleGroupe><xsl:copy-of select="$LibelleGroupe"/></LibelleGroupe>
		<StatutGroupe>GROUPE</StatutGroupe>
		<xsl:call-template name="eclate_parents">
		<xsl:with-param name="ParentChaine"><xsl:value-of select="$ParentGroupe"/></xsl:with-param>	
		</xsl:call-template>
	</GROUPES>				
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:for-each>
</xsl:for-each>
<xsl:for-each  select="($ELEVES)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
		<xsl:for-each select="attr[@name='ENTEleveGroupes']/value">
			<xsl:variable name="chaine" select="."/>
			<xsl:variable name="GroupeCode" select="substring-after( $chaine, '$')"/>
			<xsl:variable name="ID" select="substring-before( $chaine, '$')"/>
			<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
				<xsl:for-each select="addRequest/attributes">
					<xsl:if test="attr[@name='ENTStructureJointure']/value=$ID">
						<xsl:variable name="RNE" select="attr[@name='ENTStructureUAI']"/>
						<xsl:for-each select="attr[@name='ENTStructureGroupes']/value">
							<xsl:variable name="groupe" select="substring-before( ., '$')"/>
							<xsl:if test="$groupe=$GroupeCode">					
	<PERSONGROUPES>
		<ID><xsl:value-of select="concat(normalize-space($RNE),'-',$IdJointure,'-',$GroupeCode)"/></ID>
		<RNE><xsl:value-of select="normalize-space($RNE)"/></RNE>
		<identifiant><xsl:copy-of select="$ELVUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></identifiant>
		<CodeGroupe><xsl:value-of select="$GroupeCode"/></CodeGroupe>
	</PERSONGROUPES>
							</xsl:if>
						</xsl:for-each>	
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:for-each>	
		<xsl:for-each select="attr[@name='ENTEleveClasses']/value">
			<xsl:variable name="chaine" select="."/>
				<xsl:variable name="GroupeCode" select="substring-after( $chaine, '$')"/>
				<xsl:variable name="ID" select="substring-before( $chaine, '$')"/>
				<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
					<xsl:for-each select="addRequest/attributes">
						<xsl:if test="attr[@name='ENTStructureJointure']/value=$ID">
							<xsl:variable name="RNE" select="attr[@name='ENTStructureUAI']"/>
							<xsl:for-each select="attr[@name='ENTStructureClasses']/value">
								<xsl:variable name="classe" select="substring-before( ., '$')"/>
								<xsl:if test="$classe=$GroupeCode">
	<PERSONGROUPES>
		<ID><xsl:value-of select="concat(normalize-space($RNE),'-ELV-',$IdJointure,'-',$GroupeCode)"/></ID>
		<RNE><xsl:value-of select="normalize-space($RNE)"/></RNE>
		<identifiant><xsl:copy-of select="$ELVUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></identifiant>
		<CodeGroupe><xsl:value-of select="$GroupeCode"/></CodeGroupe>
	</PERSONGROUPES>		
								</xsl:if>
							</xsl:for-each>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
		</xsl:for-each>	
	</xsl:for-each>
</xsl:for-each>

<xsl:for-each  select="($PERSONNELS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
		
		<xsl:variable name="Affectations">
			<xsl:for-each select="attr[@name='ENTPersonFonctions']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:variable name="IDUAI" select="substring-before(.,'$')"/>
				<xsl:variable name="VALRNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($IDUAI)]]/attr[@name='ENTStructureUAI']/value"/>
				<xsl:variable name="precedent" select="concat(substring-before(preceding-sibling::value[1],'$'),substring-before(substring-after(preceding-sibling::value[1],'$'),'$'))"/>
				<xsl:variable name = "courant" select="concat(substring-before(.,'$'),substring-before(substring-after(.,'$'),'$'))"/>
				<xsl:if test="$precedent != $courant">	
					<xsl:variable name="PROFIL">
						<xsl:choose>
							<xsl:when test = "$VALRNE != ''">
								<xsl:choose>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'DOC'">National_doc</xsl:when>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'ENS'">National_ens</xsl:when>
									<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test = "$PROFIL != 'HORSPERIMETRE'">
						<value><xsl:value-of select="normalize-space($IDUAI)"/></value>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:variable name="EtabRattach" select="attr[@name='ENTPersonStructRattach']/value" />
		<xsl:if test="$EtabRattach != ''">	
		<xsl:for-each select="attr[@name='ENTAuxEnsGroupes']/value">
			<xsl:variable name="compteur" select="($iteration) + position()"/>
			<xsl:variable name="chaineprec" select="preceding-sibling::value[1]"/>
			<xsl:variable name="chaine" select="."/>
			<xsl:if test="($compteur = 1) or ($chaine != $chaineprec)">
				<xsl:variable name="GroupeCode" select="substring-after( $chaine, '$')"/>
				<xsl:variable name="ID" select="substring-before( $chaine, '$')"/>
				<xsl:for-each select="$Affectations/value">
					<xsl:variable name="ENCOURS" select="."/>
					<xsl:if test="$ID = $ENCOURS">
						<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
							<xsl:for-each select="addRequest/attributes">
								<xsl:if test="attr[@name='ENTStructureJointure']/value=$ID">
							<PERSONGROUPES>
								<IDETABS><xsl:copy-of select="$Affectations"/></IDETABS>
								<ENTAuxEnsGroupesENCOURS><xsl:copy-of select="$ENCOURS"/></ENTAuxEnsGroupesENCOURS>
								<ETABS><xsl:copy-of select="$EtabRattach"/></ETABS>
								<ID><xsl:value-of select="concat(normalize-space(attr[@name='ENTStructureUAI']),'-ENS-',$IdJointure,'-',$GroupeCode)"/></ID>
								<RNE><xsl:value-of select="normalize-space(attr[@name='ENTStructureUAI'])"/></RNE>
								<identifiant><xsl:copy-of select="$ENSUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></identifiant>
								<CodeGroupe><xsl:value-of select="$GroupeCode"/></CodeGroupe>
							</PERSONGROUPES>
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>	
		<xsl:for-each select="attr[@name='ENTAuxEnsClasses']/value">
			<xsl:variable name="compteur" select="($iteration) + position()"/>
			<xsl:variable name="chaineprec" select="preceding-sibling::value[1]"/>
			<xsl:variable name="chaine" select="."/>
			<xsl:if test="($compteur = 1) or ($chaine != $chaineprec)">
				<xsl:variable name="GroupeCode" select="substring-after( $chaine, '$')"/>
				<xsl:variable name="ID" select="substring-before( $chaine, '$')"/>
				<xsl:for-each select="$Affectations/value">
					<xsl:variable name="ENCOURS" select="."/>
					<xsl:if test="$ID = $ENCOURS">
						<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
							<xsl:for-each select="addRequest/attributes">
								<xsl:if test="attr[@name='ENTStructureJointure']/value=$ID">
						<PERSONGROUPES>
							<ETABS><xsl:copy-of select="$Affectations"/></ETABS>
							<ENTAuxEnsClassesENCOURS><xsl:copy-of select="$ENCOURS"/></ENTAuxEnsClassesENCOURS>
							<ID><xsl:value-of select="concat(normalize-space(attr[@name='ENTStructureUAI']),'-ENS-',$IdJointure,'-',$GroupeCode)"/></ID>
							<RNE><xsl:value-of select="normalize-space(attr[@name='ENTStructureUAI'])"/></RNE>
							<identifiant><xsl:copy-of select="$ENSUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></identifiant>
							<CodeGroupe><xsl:value-of select="$GroupeCode"/></CodeGroupe>
						</PERSONGROUPES>	
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>				
			</xsl:if>
		</xsl:for-each>
		</xsl:if>
	</xsl:for-each>
</xsl:for-each>

<xsl:for-each  select="($PERSONNELS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
		<xsl:variable name="EtabRattach" select="attr[@name='ENTPersonStructRattach']/value" />
		<xsl:variable name="Affectations">
			<xsl:for-each select="attr[@name='ENTPersonFonctions']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:variable name="IDUAI" select="substring-before(.,'$')"/>
				<xsl:variable name="VALRNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($IDUAI)]]/attr[@name='ENTStructureUAI']/value"/>
				<xsl:variable name="precedent" select="concat(substring-before(preceding-sibling::value[1],'$'),substring-before(substring-after(preceding-sibling::value[1],'$'),'$'))"/>
				<xsl:variable name = "courant" select="concat(substring-before(.,'$'),substring-before(substring-after(.,'$'),'$'))"/>
				<xsl:if test="$precedent != $courant">	
					<xsl:variable name="PROFIL">
						<xsl:choose>
							<xsl:when test = "$VALRNE != ''">
								<xsl:choose>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'DOC'">National_doc</xsl:when>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'ENS'">National_ens</xsl:when>
									<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test = "$PROFIL != 'HORSPERIMETRE'">
						<value><xsl:value-of select="normalize-space($IDUAI)"/></value>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:if test="$EtabRattach != ''">	
			<xsl:for-each select="attr[@name='ENTAuxEnsGroupesMatieres']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:variable name="GroupeCode" select="substring-before(substring-after( $chaine, '$'),'$')"/>
				<xsl:variable name="MatiereCode" select="substring-after(substring-after( $chaine, '$'),'$')"/>
				<xsl:variable name="ID" select="substring-before( $chaine, '$')"/>
				<xsl:for-each select="$Affectations/value">
					<xsl:variable name="ENCOURS" select="."/>
					<xsl:if test="$ID = $ENCOURS">
						<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
							<xsl:for-each select="addRequest/attributes">
								<xsl:if test="attr[@name='ENTStructureJointure']/value=$ID">
									<xsl:variable name="RNE" select="normalize-space(attr[@name='ENTStructureUAI'])"/>
									<!-- recherche dans le fichier GAR Etab si la matiere est déclarée pour cet etab -->
									<xsl:for-each  select="($GARETABLISSEMENTS)/men:GAR-ENT-Etab">
									<!-- si OUI  -->
										<xsl:for-each select="men:GARMatiere[men:GARStructureUAI=$RNE and men:GARMatiereCode = $MatiereCode]">
				<GRPMATIERES>
					<ETABS><xsl:copy-of select="$Affectations"/></ETABS>
					<ENTAuxEnsGroupesMatieresENCOURS><xsl:copy-of select="$ENCOURS"/></ENTAuxEnsGroupesMatieresENCOURS>
					<ID><xsl:value-of select="concat($RNE,'-GMAT-',$IdJointure,'-',$GroupeCode)"/></ID>
					<RNE><xsl:value-of select="$RNE"/></RNE>
					<identifiant><xsl:copy-of select="$ENSUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></identifiant>
					<CodeGroupe><xsl:value-of select="$GroupeCode"/></CodeGroupe>
					<CodeMatiere><xsl:copy-of select="$MatiereCode"/></CodeMatiere>
				</GRPMATIERES>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>			
	</xsl:for-each>
</xsl:for-each>

<xsl:for-each  select="($PERSONNELS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>	
		<xsl:variable name="EtabRattach" select="attr[@name='ENTPersonStructRattach']/value" />
		<xsl:variable name="Affectations">
			<xsl:for-each select="attr[@name='ENTPersonFonctions']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:variable name="IDUAI" select="substring-before(.,'$')"/>
				<xsl:variable name="VALRNE" select="($ETABLISSEMENTS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTStructureJointure'][value=normalize-space($IDUAI)]]/attr[@name='ENTStructureUAI']/value"/>
				<xsl:variable name="precedent" select="concat(substring-before(preceding-sibling::value[1],'$'),substring-before(substring-after(preceding-sibling::value[1],'$'),'$'))"/>
				<xsl:variable name = "courant" select="concat(substring-before(.,'$'),substring-before(substring-after(.,'$'),'$'))"/>
				<xsl:if test="$precedent != $courant">	
					<xsl:variable name="PROFIL">
						<xsl:choose>
							<xsl:when test = "$VALRNE != ''">
								<xsl:choose>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'DOC'">National_doc</xsl:when>
									<xsl:when test="substring-before(substring-after(.,'$'),'$') = 'ENS'">National_ens</xsl:when>
									<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>HORSPERIMETRE</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test = "$PROFIL != 'HORSPERIMETRE'">
						<value><xsl:value-of select="normalize-space($IDUAI)"/></value>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:if test="$EtabRattach != ''">
			<xsl:for-each select="attr[@name='ENTAuxEnsClassesMatieres']/value">
				<xsl:variable name="chaine" select="."/>
				<xsl:variable name="GroupeCode" select="substring-before(substring-after( $chaine, '$'),'$')"/>
				<xsl:variable name="MatiereCode" select="substring-after(substring-after( $chaine, '$'),'$')"/>
				<xsl:variable name="ID" select="substring-before( $chaine, '$')"/>
				<xsl:for-each select="$Affectations/value">
					<xsl:variable name="ENCOURS" select="."/>
					<xsl:if test="$ID = $ENCOURS">
						<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
							<xsl:for-each select="addRequest/attributes">
								<xsl:if test="attr[@name='ENTStructureJointure']/value=$ID">
									<xsl:variable name="RNE" select="normalize-space(attr[@name='ENTStructureUAI'])"/>
									<!-- recherche dans le fichier GAR Etab si la matiere est déclarée pour cet etab -->
									<xsl:for-each  select="($GARETABLISSEMENTS)/men:GAR-ENT-Etab">
									<!-- si OUI -->
										<xsl:for-each select="men:GARMatiere[men:GARStructureUAI=$RNE and men:GARMatiereCode = $MatiereCode]">					
			<CLASSEMATIERES>
				<ETABS><xsl:copy-of select="$Affectations"/></ETABS>
				<ENTAuxEnsClassesMatieresENCOURS><xsl:copy-of select="$ENCOURS"/></ENTAuxEnsClassesMatieresENCOURS>
				<ID><xsl:value-of select="concat($RNE,'-GMAT-',$IdJointure,'-',$GroupeCode)"/></ID>
				<RNE><xsl:value-of select="$RNE"/></RNE>
				<identifiant><xsl:copy-of select="$ENSUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></identifiant>
				<CodeGroupe><xsl:value-of select="$GroupeCode"/></CodeGroupe>
				<CodeMatiere><xsl:copy-of select="$MatiereCode"/></CodeMatiere>
			</CLASSEMATIERES>
										</xsl:for-each>
									</xsl:for-each>	
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:if>				
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>			
	</xsl:for-each>
</xsl:for-each>

</LISTE>
</xsl:template>
<xsl:template name="eclate_parents" xmlns:men="http://data.education.fr/ns/gar" >
		<xsl:param name="ParentChaine"/>
		<xsl:choose>
			<xsl:when test="contains($ParentChaine,'$')">
<DivAppartenance><xsl:value-of select="substring-before( $ParentChaine, '$')"/></DivAppartenance>
<xsl:call-template name="eclate_parents">
					<xsl:with-param name="ParentChaine"><xsl:value-of select="substring-after( $ParentChaine, '$')"/></xsl:with-param>	
</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
<DivAppartenance><xsl:value-of select="$ParentChaine"/></DivAppartenance>
			</xsl:otherwise>
		</xsl:choose>
</xsl:template>
</xsl:stylesheet>
