<xsl:stylesheet version="2.0" xmlns:saxon="http://saxon.sf.net/"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="eleves">
		<xsl:for-each  select="$CONFIG/eleves">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="matieres">
		<xsl:for-each  select="$CONFIG/matieres">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="cheminELEVES" select="concat($AAFPATH,concat('.?select=',$eleves))"/>	
	<xsl:variable name="ELEVES" select="collection($cheminELEVES)"/>
	<xsl:variable name="cheminMATIERES" select="concat($AAFPATH,concat('.?select=',$matieres))"/>	
	<xsl:variable name="MATIERES" select="collection($cheminMATIERES)"/>
    <xsl:variable name="iteration" select="0"/>
<xsl:template match="/">
<xsl:variable name="vPass1">
<Matieres
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">

<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR" saxon:threads="10">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="ID" select="attr[@name='ENTStructureJointure']"/>
		<xsl:variable name="RNE" select="attr[@name='ENTStructureUAI']"/>
		<!-- recherche les fiches des élèves de cet etab -->
		<xsl:for-each  select="($ELEVES)/ficAlimMENESR">
			<xsl:for-each select="addRequest/attributes">
				<xsl:if test="attr[@name='ENTPersonStructRattach']/value=$ID">
				<!-- on est sur une fiche eleve de l'etab  -->
					<!-- on parcout la liste des codes matieres de l'eleve -->
					<xsl:for-each select="attr[@name='ENTEleveCodeEnseignements']/value">
							<xsl:variable name="matcode" select="."/>
							<!-- pour chaque code trouvé on recherche le libellé dans le doc $MATIERES -->
							<xsl:for-each  select="($MATIERES)/ficAlimMENESR">
								<xsl:for-each select="addRequest">
									<xsl:if test="identifier/id=$matcode">
										<xsl:variable name="libelle" select="attributes/attr[@name='ENTLibelleMatiere']"/>
				<Matiere>
					<ID><xsl:value-of select="concat($RNE,'|',$matcode)"/></ID>
					<RNE><xsl:value-of select="$RNE"/></RNE>
					<Code><xsl:value-of select="$matcode"/></Code>
					<Libelle><xsl:value-of select="$libelle"/></Libelle>
				</Matiere>
									</xsl:if>
								</xsl:for-each>
							</xsl:for-each>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:for-each>
</xsl:for-each>

</Matieres>
</xsl:variable>
<xsl:apply-templates select="$vPass1/*"/>
</xsl:template>

<xsl:template match="Matieres">
  <Matieres>
   <xsl:perform-sort select="*">
    <xsl:sort select="ID"/>
   </xsl:perform-sort>
  </Matieres>
</xsl:template>

</xsl:stylesheet>
