<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
     <xsl:output method="xml" version="1.0"
          encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
<!-- tri des mefs  -->
<xsl:template match="/">
<MEFS
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
<xsl:for-each select="/MEFS/MEF">
	<xsl:sort select="ID"/>
	<MEF>
		<ID><xsl:value-of select="ID"/></ID>
		<RNE><xsl:value-of select="RNE"/></RNE>
		<Code><xsl:value-of select="Code"/></Code>
		<Libelle><xsl:value-of select="Libelle"/></Libelle>
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'"></xsl:when>
            <xsl:otherwise>
		<Rattach><xsl:value-of select="Rattach"/></Rattach>
		<MefStat11><xsl:value-of select="MefStat11"/></MefStat11>
			</xsl:otherwise>
        </xsl:choose>			
	</MEF>
</xsl:for-each>
</MEFS>
</xsl:template>
</xsl:stylesheet>
