<xsl:stylesheet version="2.0" xmlns:saxon="http://saxon.sf.net/"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="eleves">
		<xsl:for-each  select="$CONFIG/eleves">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="cheminELEVES" select="concat($AAFPATH,concat('.?select=',$eleves))"/>	
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="ELEVES" select="collection($cheminELEVES)"/>	
    <!-- <xsl:variable name="iteration" select="0"/> -->
<!-- template des établissements : traitement des mefs -->

<xsl:template match="/">
<xsl:variable name="vPass1">
<MEFS
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">

<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR"  >
        <xsl:sort select="ID"/>
	<xsl:for-each select="addRequest/attributes">
        <!-- <xsl:variable name="compteur" select="($iteration) + position()"/> -->
        <xsl:variable name="ID" select="attr[@name='ENTStructureJointure']"/>
        <xsl:variable name="RNE" select="attr[@name='ENTStructureUAI']"/>
		<xsl:for-each  select="($ELEVES)/ficAlimMENESR">
			<xsl:for-each select="addRequest/attributes">
				<xsl:variable name="libelle" select="attr[@name='ENTEleveLibelleMEF']"/>
				<xsl:if test="attr[@name='ENTPersonStructRattach']/value=$ID">
					<xsl:for-each select="attr[@name='ENTEleveMEF']">
	<MEF>
	<ID><xsl:value-of select="concat($RNE,'|',value)"/></ID>
	<RNE><xsl:value-of select="($RNE)"/></RNE>
	<Code><xsl:value-of select="value"/></Code>
	<Libelle><xsl:value-of select="($libelle)"/></Libelle>
	</MEF>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
        </xsl:for-each>
	</xsl:for-each>
</xsl:for-each>

</MEFS>
</xsl:variable>
<xsl:apply-templates select="$vPass1/*"/>
</xsl:template>

<xsl:template match="MEFS">
  <MEFS>
   <xsl:perform-sort select="*">
    <xsl:sort select="ID"/>
   </xsl:perform-sort>
  </MEFS>
 </xsl:template>

</xsl:stylesheet>
