<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="eleves">
		<xsl:for-each  select="$CONFIG/eleves">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="mefs">
		<xsl:for-each  select="$CONFIG/mefs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="cheminELEVES" select="concat($AAFPATH,concat('.?select=',$eleves))"/>	
	<xsl:variable name="cheminMEFS" select="concat($AAFPATH,concat('.?select=',$mefs))"/>
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="ELEVES" select="collection($cheminELEVES)"/>	
	<xsl:variable name="MEFS" select="collection($cheminMEFS)"/>	
    <xsl:variable name="iteration" select="0"/>
<!-- template des établissements : traitement des mefs -->
<xsl:template match="/">
<MEFS
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">

<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
        <xsl:variable name="compteur" select="($iteration) + position()"/>
        <xsl:variable name="ID" select="attr[@name='ENTStructureJointure']"/>
        <xsl:variable name="RNE" select="attr[@name='ENTStructureUAI']"/>
		<xsl:for-each  select="($ELEVES)/ficAlimMENESR">
			<xsl:for-each select="addRequest/attributes">
				<xsl:variable name="libelle" select="normalize-space(attr[@name='ENTEleveLibelleMEF'])"/>
				<xsl:if test="attr[@name='ENTPersonStructRattach']/value=$ID">
					<xsl:for-each select="attr[@name='ENTEleveMEF']">
					<xsl:variable name="MefCode" select="normalize-space(value)"/>
	<MEF>
	<ID><xsl:value-of select="concat($RNE,'|',value)"/></ID>
	<RNE><xsl:value-of select="($RNE)"/></RNE>
	<Code><xsl:value-of select="($MefCode)"/></Code>
	<Libelle><xsl:value-of select="($libelle)"/></Libelle>
	<xsl:choose>
		<xsl:when test="$VERSION = '1.5.4'"></xsl:when>
		<xsl:otherwise>
	<xsl:variable name="Rattach" select="($MEFS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTMefJointure'][value=$MefCode]]/attr[@name='ENTMEFRattach']/value"/>
	<xsl:variable name="MefStat11" select="($MEFS)/ficAlimMENESR/addRequest/attributes[attr[@name='ENTMefJointure'][value=$MefCode]]/attr[@name='ENTMEFSTAT11']/value"/>
	<Rattach><xsl:value-of select="($Rattach)"/></Rattach>
	<MefStat11><xsl:value-of select="($MefStat11)"/></MefStat11>
		</xsl:otherwise>
	</xsl:choose>	
	</MEF>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
        </xsl:for-each>
	</xsl:for-each>
</xsl:for-each>

</MEFS>
</xsl:template>
</xsl:stylesheet>
