<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	 xmlns:run="http://www.ac-reunion.fr/xsl/run">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
	<xsl:variable name="ANONYMAT">
		<xsl:for-each  select="$CONFIG/ANONYMAT">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>		
	<xsl:variable name="AAFPATH">
		<xsl:for-each  select="$CONFIG/AAFPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
     <xsl:variable name="ENSUUID">
		<xsl:for-each  select="$CONFIG/ENSUUID">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	 
	<xsl:variable name="etabs">
		<xsl:for-each  select="$CONFIG/etabs">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="personnels">
		<xsl:for-each  select="$CONFIG/personnels">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="cheminETABLISSEMENTS" select="concat($AAFPATH,concat('.?select=',$etabs))"/>
	<xsl:variable name="cheminPERSONNELS" select="concat($AAFPATH,concat('.?select=',$personnels))"/>	
	<xsl:variable name="ETABLISSEMENTS" select="collection($cheminETABLISSEMENTS)"/>
	<xsl:variable name="PERSONNELS" select="collection($cheminPERSONNELS)"/>

    <xsl:variable name="GARPersonNomLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">70</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="GARPersonPrenomLength">
        <xsl:choose>
            <xsl:when test="$VERSION = '1.5.4'">35</xsl:when>
            <xsl:otherwise>500</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

	<xsl:function name="run:anonymat">
		<xsl:param name="chaine"/>
		<xsl:variable name="redacted" select="'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'"/>
		<xsl:variable name="resultat">
		<xsl:choose>
					<xsl:when test="$ANONYMAT = 'oui'"
						><xsl:value-of select="substring($chaine, (string-length($chaine)-1), 1)"
						/><xsl:value-of select="substring($redacted, 1, (string-length($chaine)-2) )"
						/><xsl:value-of select="substring($chaine, 1, 1)"
						/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$chaine"/></xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$resultat"/>
	</xsl:function>
<xsl:template match="/">
<men:GAR-ENT-RespAff
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
<xsl:for-each  select="($PERSONNELS)/ficAlimMENESR">
	<xsl:for-each select="addRequest/attributes">
		<xsl:variable name="IdJointure" select="normalize-space(attr[@name='ENTPersonJointure'])"/>
		<xsl:variable name="RespAffEtabBrut">
		<xsl:for-each select="attr[@name='ENTPersonFonctions']/value">
			<xsl:sort/>
			<xsl:variable name="ID" select="substring-before(.,'$')"/>
				<xsl:choose>
					<xsl:when test="contains(.,'DIR')">
						<xsl:for-each  select="($ETABLISSEMENTS)/ficAlimMENESR">
							<xsl:for-each select="addRequest/attributes">
								<xsl:if test="attr[@name='ENTStructureJointure']/value=$ID">
						<men:GARRespAffEtab><xsl:value-of select="normalize-space(attr[@name='ENTStructureUAI'])"/></men:GARRespAffEtab>
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					 </xsl:when>
					 <xsl:otherwise></xsl:otherwise>
				</xsl:choose>
		 </xsl:for-each>
		</xsl:variable>
		<!-- dédoublonnage des etabs -->
		<xsl:variable name="RespAffEtab" select="($RespAffEtabBrut)/men:GARRespAffEtab[not(. =  preceding-sibling::*)]"/>
		<xsl:if test="$RespAffEtab!=''">
		<xsl:variable name="courriel">
			<xsl:choose>
				<xsl:when test="$ANONYMAT = 'oui'"><xsl:value-of select="concat('noreply@',substring-after(normalize-space(attr[@name='mail']),'@'))"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="normalize-space(attr[@name='mail'])"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
<men:GARRespAff>
	<men:GARPersonIdentifiant><xsl:copy-of select="$ENSUUID"/>-<xsl:value-of select="substring(concat('0000000000000', $IdJointure), string-length($IdJointure)+2, 12)"/></men:GARPersonIdentifiant>
	<men:GARPersonNom><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='sn'], 1, $GARPersonNomLength)))"/></men:GARPersonNom>
	<men:GARPersonPrenom><xsl:value-of select="run:anonymat(normalize-space(substring(attr[@name='givenName'], 1, $GARPersonPrenomLength)))"/></men:GARPersonPrenom>
	<men:GARPersonCivilite><xsl:choose>
			 <xsl:when test="normalize-space(attr[@name='personalTitle']) = 'Mlle'">MM.</xsl:when>
			 <xsl:otherwise><xsl:value-of select="normalize-space(attr[@name='personalTitle'])"/></xsl:otherwise>
		 </xsl:choose></men:GARPersonCivilite>
    <men:GARPersonMail><xsl:value-of select="$courriel"/></men:GARPersonMail>
	<xsl:copy-of select="$RespAffEtab"/> 
</men:GARRespAff>
		</xsl:if>
	</xsl:for-each>
</xsl:for-each>
</men:GAR-ENT-RespAff>
</xsl:template>
</xsl:stylesheet>
