<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0"
     encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" />
<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
<xsl:variable name="TMPPATH">
	<xsl:for-each  select="$CONFIG/TMPPATH">
		<xsl:value-of select="."/>
	</xsl:for-each>
</xsl:variable>	 
<xsl:variable name="cheminRESPAFFS" select="concat($TMPPATH,concat('?select=','Source_RespAffs_*.xml'))"/>
<xsl:variable name="RESPAFFS" select="collection($cheminRESPAFFS)"/>
<!-- Fusion  -->
<xsl:template match="/">
<men:GAR-ENT-RespAff
    xmlns:men="http://data.education.fr/ns/gar"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
    Version="1.5.4">
<xsl:for-each  select="$RESPAFFS/men:GAR-ENT-RespAff">
	<xsl:for-each select="men:GARRespAff">
		<xsl:copy-of select="." copy-namespaces="no"/>
	</xsl:for-each>
</xsl:for-each>	
</men:GAR-ENT-RespAff>		
</xsl:template>
</xsl:stylesheet>