<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:param name="basename" required="yes"/>
	<xsl:output method="xml" version="1.0"
    encoding="UTF-8" indent="yes" xmlns:men="http://data.education.fr/ns/gar" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd" />
    <xsl:param name="pItemsNumber" select="10000"/>
	<xsl:variable name="CONFIG" select="document('config.xml')/GAR-CONFIG"/>
    <xsl:variable name="VERSION">
        <xsl:for-each  select="$CONFIG/VERSION">
            <xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
	<xsl:variable name="GARPATH">
		<xsl:for-each  select="$CONFIG/GARPATH">
			<xsl:value-of select="."/>
		</xsl:for-each>
	</xsl:variable>	 	
    <xsl:template match="@*|node()">
        <xsl:for-each-group select="child::*"
                            group-adjacent="(position()-1) idiv $pItemsNumber">
			<xsl:variable name="compteur" select="substring(
			concat('0000', string(current-grouping-key()) ), string-length(string(current-grouping-key()))+1
			, 4)"/>
            <xsl:result-document  href="file://{$GARPATH}{$basename}_{$compteur}.xml">
                <men:GAR-ENT-RespAff xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                   xmlns:men="http://data.education.fr/ns/gar"
                   xsi:schemaLocation="http://data.education.fr/ns/gar/GAR-ENT.xsd"
                   Version="">
                    <xsl:sequence select="current-group()"/>
                </men:GAR-ENT-RespAff>
            </xsl:result-document>
        </xsl:for-each-group>
    </xsl:template>
</xsl:stylesheet>
