<?php

/* Module de récupération des ressources du GAR */
class GAR {

    private $url;
    private $cert;
    private $client;

    private $app;

    const  UAJ_OR_USER_NOT_EXIST = 400;
    const  OPERATIONEL           = 200;
    const  GAR_CONFIG_MISSING    = "Configuration GAR absente";

    public function __construct($app) {
    
        $this->app    = $app;
        // Initialisation Curl
        $this->client = curl_init();
        
        curl_setopt($this->client, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($this->client, CURLOPT_HEADER, false);
        curl_setopt($this->client, CURLOPT_ENCODING, "gzip, deflate");
        curl_setopt($this->client, CURLOPT_HTTPHEADER, array('Accept: application/json'));

        // Un proxy ?
        $proxy=PARAM("proxy");
        if ($proxy) {
            curl_setopt($this->client,CURLOPT_PROXY,$proxy);
        }

    }

    // Recupération des ressources pour un uaj donné
    public function _getRessources($uaj) {
        
        $idEnt = PARAM("GAR_CODE");
        $idGar = USER()->garidentifiant;

        curl_setopt($this->client, CURLOPT_URL,$this->url . "/ressources/${idEnt}/${uaj}/${idGar}");
        
        try {
            $start = microtime(true);
            $response = curl_exec($this->client);
            $time_elapsed_secs = microtime(true) - $start;
            //file_put_contents("/tmp/gar.log",date("Y-m-d H:i:s", time()) . " /ressources/${idEnt}/${uaj}/${idGar} : ".$time_elapsed_secs."\n",FILE_APPEND);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
        
        if ($response===false) {
            $status= curl_getinfo($this->client,CURLINFO_HTTP_CODE);
            return curl_error($this->client);
        }

        // vérifie le code de retour du service Web
        $status= curl_getinfo($this->client,CURLINFO_HTTP_CODE);
        if ($status==self::UAJ_OR_USER_NOT_EXIST) {
            return "Votre compte ou votre établissement n'a pas encore été ajouté au GAR";
        }        
        
        $ressources  = json_decode($response,true);

        if (isset($ressources["Erreur"])) {
            return $ressources["Erreur"]["Code"]. " " . $ressources["Erreur"]["Message"];
        }

        if (!isset($ressources["listeRessources"])) {
            return [];
        }

        if (!isset($ressources["listeRessources"]["ressource"])) {
            return [];
        }

        $ressources = $ressources["listeRessources"]["ressource"];

        return $ressources;
    }

    // Construction des instances de ressources pour une library d'établissement
    public function getRessourcesForLibrary($library,$context,$bRefresh=false) {
        $instances = [];

        if ( $context->garStep != Model_Gar::STEP_INTEGRATED ) {
            return $instances;
        }

        $gar = $context->getGarConfig();

        if (!$gar) {
            return self::GAR_CONFIG_MISSING;
        }

        if (!$gar->actif) {
            return [];
        }

        // Pas en mode refresh , on tente d'utiliser le cache
        if (!$bRefresh) {
            $instances = $this->loadFromCache($library,$context);
            if ($instances && count($instances)) { return $instances;}
        }

        if (!$gar->isWebServiceConfValid()) {
            return "la configuration de '" . $gar->description . "' est incomplete (certificat manquant)";
        }

        if (!$gar->isRessourcesAvailable()) {
            return "la configuration de l'accès aux ressources de '" . $gar->description . "' est en échec";
        }


        // Initialisation de CURL
        $this->url  = $gar->wsUrl;
        // 10s max 
        ini_set('max_execution_time', 90); //1mn30s max pour récupérer
        curl_setopt($this->client, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($this->client, CURLOPT_TIMEOUT, 10); 
        curl_setopt($this->client, CURLOPT_SSLCERTTYPE,"PEM");
        curl_setopt($this->client, CURLOPT_SSLKEY, $gar->getWsKey());
        curl_setopt($this->client, CURLOPT_SSLCERT,$gar->getWsPem());

        

        //$start = microtime(true);
        $ressources = $this->_getRessources($library->uaj);
        /*$time_elapsed_secs = microtime(true) - $start;
        file_put_contents("/tmp/gar-ressources.log",date("Y-m-d H:i:s", time()) . " /libraries/ : ". USER()->id . "  " .$time_elapsed_secs."\n",FILE_APPEND);
        */
        
        if (!is_array($ressources)) {
            return $ressources ;
        }

        $bNewUrl = false ;
        $now     = new DateTime("now");
        $start = microtime(true);
        foreach($ressources as $garRessource) {

            //file_put_contents("/tmp/gar-ressources.log",date("Y-m-d H:i:s", time()) . " 1\n",FILE_APPEND);
            
            // L'url reçue, est une URL qui provoquera une
            // fédération SAML en SP Initiated
            $url       = $garRessource["urlAccesRessource"];
            $idRess    = md5($garRessource["idRessource"]);

            /// Construction des ressources 
            $ressource = R::findOne("ressource","tag = ?",array($idRess));
            $bNewRessource = false;
            if (!$ressource) {
                $ressource      = R::dispense("ressource");
                $bNewRessource  = true;
                $ressource->tag = $idRess;
                $ressource->url          = "";
                $ressource->urlaccess    = "";

                // Gestion de la catégorie
                if (isset($garRessource["typePresentation"]) && isset($garRessource["typePresentation"]["code"]) ) {
                    $tag       = $garRessource["typePresentation"]["code"];
                    $name      = $garRessource["typePresentation"]["nom"];
                    $category = R::findOne("category", 'tag = ?',array($tag));
                    if (!$category) {
                        $category       = R::dispense("category"); 
                        $category->tag  = $tag;
                        $category->name = $name;
                        R::store($category);
                    }
                    $ressource->category=$category;
                }

                $ressource->name        = $garRessource["nomRessource"];
                $ressource->description = $garRessource["nomEditeur"];
                $ressource->logo        = $garRessource["urlVignette"];
                // #30129 Afficher le code ARK pour chaque ressource du GAR
                // Nouvelle ressource
                $ressource->idType        = $garRessource["idType"];
                $ressource->idRessource   = $garRessource["idRessource"];
                $ressource->nomSourceEtiquetteGar =  $garRessource["nomSourceEtiquetteGar"];
                $ressource->actif       = 1;
                R::store($ressource);
            } 

            // #30129 Afficher le code ARK pour chaque ressource du GAR
            // ressource déja présente
            if ($ressource && !$ressource->idRessource) {
                $ressource->idType        = $garRessource["idType"];
                $ressource->idRessource   = $garRessource["idRessource"];
                R::store($ressource);
            }
            $ressource->name        = $garRessource["nomRessource"];
            $ressource->description = $garRessource["nomEditeur"];
            $ressource->logo        = $garRessource["urlVignette"];
            $ressource->nomSourceEtiquetteGar =  $garRessource["nomSourceEtiquetteGar"];
            $ressource->actif       = 1;

            //file_put_contents("/tmp/gar-ressources.log",date("Y-m-d H:i:s", time()) . " 2\n",FILE_APPEND);

           // if ($bNewRessource) {
           //    $gar->ownRessourceList[]     = $ressource;
           //    $context->sharedRessourceList[] = $ressource;
           // }
            
            // Instance de la ressource ( Ressource dans une library)
            $instance=R::dispense("instance");

            $instance->user          = $library->user;
            $instance->library       = $library;
            $instance->ressource     = $ressource;
            $instance->garOrigin     = true; 
            $ressource->url          = $url;
            $ressource->urlaccess    = $url;
            $instance->urlaccess     = $url;
                
            $instance->logo                  =  $garRessource["urlVignette"];
            $instance->nomSourceEtiquetteGar =  $garRessource["nomSourceEtiquetteGar"];

            //file_put_contents("/tmp/gar-ressources.log",date("Y-m-d H:i:s", time()) . " 3\n",FILE_APPEND);

            // gar
            $garInstance = R::findOne("garinstance","url = ? AND gid = ? ",array($url,USER()->garidentifiant));
            if (!$garInstance) {
                $garInstance = R::dispense("garinstance");
                $garInstance->url  = $url;
                $garInstance->user = USER();
                $garInstance->gid  = USER()->garidentifiant;
                $garInstance->ressource = $ressource;
                R::store($garInstance);

                //$gar->ownGarinstanceList[]     = $garInstance;
                //$context->ownGarinstanceList[] = $garInstance;
                //$bNewUrl = true;
            } else {
                $garInstance->context = $context;
                $garInstance->updated = $now;
                //R::store($garInstance);
            }

            //file_put_contents("/tmp/gar-ressources.log",date("Y-m-d H:i:s", time()) . " 4\n",FILE_APPEND);

            $instance->garInstance           = $garInstance->id;
            $instance->id                    = $garInstance->id;
            $instance->access                = intval($ressource->access);
            $instance->updated               = $garInstance->created;
    
            $instances[] = $instance;
        }

        //$time_elapsed_secs = microtime(true) - $start;
        //file_put_contents("/tmp/gar-ressources.log",date("Y-m-d H:i:s", time()) . " /libraries/ : ". USER()->id . "  " .$time_elapsed_secs."\n",FILE_APPEND);
        

        if ($bNewUrl) {
            R::store($gar);
            R::store($context);
        }

        // Supression des instances non mises à jour ============================================
        $instancesToDelete = [] ;
        $nowString = \R::isoDateTime();
        $cacheDesInstances = R::findAll("garinstance","gid = ? and updated < ?",array(USER()->garidentifiant,$nowString));
        foreach($cacheDesInstances as $garInstance) {
            if ($garInstance->updated) {
                $diff = $now->diff(new \DateTime($garInstance->updated));
                $nbDays = $diff->days;
                if ($nbDays > 0) {$instancesToDelete[] = $garInstance;}
            }
        }
        if (count($instancesToDelete)) {\R::trashAll($instancesToDelete);}
        // ======================================================================================


        return $instances;
    }

    public function loadFromCache($library,$context) {
        $cacheDesInstances = R::findAll("garinstance","gid = ? ",array(USER()->garidentifiant));
        $instances         = [];
        $now               = new \Datetime();
        foreach($cacheDesInstances as $garInstance) {

            // Une des ressources non mises à jours depuis plus de 
            // 5 jours => on retourne vide pour forcer la MAJ
            if ($garInstance->updated) {
                $diff = $now->diff(new \DateTime($garInstance->updated));
                $nbDays = $diff->days;
                if ($nbDays > 5) {
                    return null;
                }
            }
            

            $instance=R::dispense("instance");

            $ressource =  $garInstance->ressource;
            $url       =  $garInstance->url;

            $instance->user          = $library->user;
            $instance->library       = $library;
            $instance->ressource     = $ressource;
            $instance->garOrigin     = true; 
            $ressource->url          = $url;
            $ressource->urlaccess    = $url;
            $instance->logo          = $ressource->logo;

            $instance->garInstance           = $garInstance->id;
            $instance->id                    = $garInstance->id;
            $instance->access                = intval($ressource->access);
            $instance->updated               = $garInstance->created;

            $instances[] = $instance;
        }

        return $instances;
    }


}