<?php


define("PAD_DEFAULT_KEY",str_pad("x",2000,"x"));
define("__UPDLOAD_DIR","../upload");

set_include_path(get_include_path() . PATH_SEPARATOR . __DIR__. '/../phpseclib');
include('Net/SSH2.php');
include('Net/SFTP.php');
include('Crypt/RSA.php');
include('File/X509.php');

define('NET_SFTP_LOGGING', NET_SFTP_LOG_COMPLEX);

// Classe de Base
class Model_First extends RedBean_SimpleModel {

    public static $RIGHT_FORBIDEN=0;
    public static $RIGHT_READ=100;
    public static $RIGHT_WRITE=200;
    public static $RIGHT_EDIT=300;
    public static $RIGHT_DELETE=400;

    public $rights="[]";

    public function isContextuable() {return false;}

     public function isOwner() {
        if (!$this->user) $this->user=USER();
        return $this->user->id==USER()->id;
    }

    public function isEditable() {
        return ($this->isOwner() || USER()->isAdmin());
    }

    public function isDeletable() {
        return ($this->isOwner() || USER()->isAdmin()) ;
    }

    public function isVisible() {
        return ($this->isOwner() || USER()->isAdmin()) ;
    }

    public function importProperty($data,$prop,$boolean=false) {
        if (property_exists($data, $prop)) {
            $this->{$prop}=$data->{$prop};
            if ($boolean) $this->{$prop}=(boolean)$data->{$prop};
        }
    }

    public function isLocked() {return ($this->locked!=null)?$this->locked:false;}

    public function hasRight($val) {
        global $config;
        $bContextOK=true;

        // Pas de user encore, par défaut c'est admin
        if (!$this->user) { return true; }

        // Si l'item dispose d'un contexte, on va vérifier que le contexte est dispo pour
        // le USER
        if ($this->isContextuable() && is_array($this->sharedContextList)) {
            $bContextOK=false;
            foreach ($this->sharedContext as $context)
            {
               if ($context->tag=="GLOBAL" || USER()->hasContext($context)) {
                 $bContextOK=true;
                 break;
               }
            }
        }

        // Context non OK -> return false
        if (!$bContextOK)               {return false;}

        if ($this->isOwner() || USER()->isAdmin())          {return true;}

        // Pas de droit positionné rettourne true si on vérifie les droits en lecture , faut sinon
        // (Si aucun droit positionné par défaut c'est visible)
        if (!is_array($this->rights))   {return $val==self::$RIGHT_READ;}
        if (count($this->rights)==0 )   {return $val==self::$RIGHT_READ;}

        // Pour chacun des droits on vérifie si le USER a le profil associé
        foreach ($this->rights as $right) {
            if (USER()->hasProfil($right->{'profil'})) {
                return intval($right->{'right'})>=$val  ;
            }
        }
        return $val==self::$RIGHT_READ;
    }

    public function checkAction($data) {
        if (property_exists($data, 'action')) {
            if ($data->{'action'} == "delete" && $this->isDeletable() ) {
                R::trash($this);
                return false;
            }
        }

        return true;
    }

    public function importAutorisations($data) {
        if (property_exists($data, 'rights')) {
            $autorisations=array();
            $a=Model_Base::RIGHTS();
            foreach($data->{'rights'} as $r) {
                $profil= R::findOne('profil', 'tag = ?',array($r->{'profil'}));
                if (!$profil) continue;
                $right=$a[$r->{'right'}];
                $autorisations[]=array("profil"=>$profil->id,"right"=>$right);
            }
            $this->autorisations=json_encode($autorisations);
        }

        if ($this->isContextuable() && property_exists($data, 'contexts')) {

        }

        // Lors d'une importation lock la donnée, sauf si locked est precisé
        // évite la modification par l'ui
        if (property_exists($data, 'locked')) {
            $this->locked=(boolean)$data->{'locked'};
        } else {
            $this->locked=true;
        }

    }

    public function open(){
           $this->rights=json_decode($this->autorisations);
           if (!$this->user) {
               $this->user=ADMIN();
           }
    }

    public function update(){
            if (!$this->user)       $this->user=USER();
            if (!$this->created)    $this->created=new DateTime("now");
            if (!$this->updated)    $this->updated=$this->created;

            // Supprime tous les caractères spéciaux du tag
            // ne garde que les chiffres et lettres
            if ($this->tag) {
                $this->tag = normalizeTag($this->tag);
            }

            // On met a jour la date de modification si la ressource n'est pas locké
            // si locké, il est impossible de mettre a jour depuis l'interface web
            // donc si locké cela vient d'une importation CLI, il ne s'agit donc pas d'un
            // update
            if (!$this->isLocked() || !$this->updated) {
                $this->updated=new DateTime("now");
            }

            if (!$this->description)$this->description="Aucune description";

            // Si est contextuable, et pas de context on va en ajouter un
            if ($this->isContextuable() && count($this->sharedContext)==0) {
                $arr=USER()->getContext();
                if (count($arr)!=0) {
                     $this->sharedContextList=array(reset($arr));
                }
                else $this->sharedContextList=array(GLOBAL_CONTEXT());
            }
    }

}


class Model_Base extends Model_First {




    public $profil=array();
    public $cas=array();

    // Attention : Pour le moment la cohérence id<->libelle avec le client
    // doit se faire manuellement dans le fichier profils.js
    public static function RIGHTS()
    {
        return array("DENY"=>self::$RIGHT_FORBIDEN,
                     "READ"=>self::$RIGHT_READ,
                     "WRITE"=>self::$RIGHT_WRITE,
                     "EDIT"=>self::$RIGHT_EDIT,
                     "DELETE"=>self::$RIGHT_DELETE);
    }



    public function getContext() {
        $arr=array();
        if (is_array($this->sharedContext))
        {
            foreach ($this->sharedContext as $context)
            {
                $arr[]=$context->json();
            }
        }else
        {
            $arr[]=GLOBAL_CONTEXT();
        }
        return $arr;
    }

    public function jsonWithoutContext() {

        // export des caractéristiques générales
        $a=array("id"=>$this->id,"name"=>$this->name,"description"=>$this->description,
        "autorisations"=>$this->autorisations,
        "tag"=>$this->tag,
        "locked"=>$this->isLocked(),
        "writable"=>$this->isWritable(),
        "deletable"=>$this->isDeletable(),
        "editable"=>$this->isEditable());
        if ($this->user) $a["user"]=$this->user->json();

        // récupération de la date de modification
        $d=new DateTime($this->garInstance?$this->updated:$this->created);
        $st=$d->getTimestamp();
        $a["timestamp"]=$st;
        $a["since"]=TIMESTAMP()-$st;
        $a["iso8601"]=$d->format('c');

        return $a;

    }

    public function json() {
        $a=$this->jsonWithoutContext();
        $a["context"]=$this->getArrContext();
        return $a;
    }

    function getArrContext($bWithGarCounter=false) {
        $ret=array();
        if (is_array($this->sharedContext)) {
            foreach ($this->sharedContext as $c){$ret[]=$c->json($bWithGarCounter);}
        }
        return $ret;

    }

    public function dispense(){
           $this->name="";
           $this->description="";
    }




    public function isEditable()  {return $this->hasRight(self::$RIGHT_EDIT);}
    public function isVisible()   {return $this->hasRight(self::$RIGHT_READ);}
    public function isWritable()  {return $this->hasRight(self::$RIGHT_WRITE);}
    public function isDeletable() {return $this->hasRight(self::$RIGHT_DELETE);}

}




// ======
class Model_Eval extends Model_Base {

    public function json() {

        $arr=array();
        $arr["id"]=$this->id;
        $arr["comment"]=$this->comment;
        $arr["user"]=$this->user->fullname;
        $arr["vote"]=$this->vote;
        $d=new DateTime($this->created);
        $st=$d->getTimestamp();
        $arr["created"]=strftime("%A %e %B %Y à %H:%M",$st);
        return $arr;
    }

    public function update() {
        $this->created=new DateTime("now");
        if (!$this->user) $this->user=USER();
    }

}

class Model_Category extends Model_First {

    public static function import($datas,$app) {

        $app->requireAdmin();

        foreach ($datas as $data)
        {
            echo $data->{'tag'};
            $category= $app->createIfNotExist('category',$data->{'tag'});
            if (!$category->checkAction($data)) continue;
            $category->tag=$data->{'tag'};
            $category->name=$data->{'name'};
            $category->importProperty($data,'color');
            R::store($category);
        }
    }

    public function json() {
        $arr=array();
        $arr["id"]=$this->id;
        $arr["tag"]=$this->tag;
        $arr["name"]=$this->name;
        $arr["color"]=$this->color?$this->color:"#000";
        return $arr;
    }


    public function isVisible() {
       return true;
    }

}

// ======
class Model_Catalogue extends Model_Base {

    public function isContextuable() {return true;}

    public static function import($datas,$app) {
        foreach ($datas as $data)
        {
                $catalogue = R::findOne('catalogue', 'tag = ?',array(normalizeTag($data->{'tag'})));
                if (!$catalogue) {
                    $app->requireAdmin();
                    $catalogue=R::dispense('catalogue');
                    $catalogue->tag=$data->{'tag'};
                }

                if (!$catalogue->checkAction($data)) continue;

                if (!$catalogue->isEditable()) {
                    $app->info("catalogue tag=".$catalogue->tag." non editable");
                    continue;
                }

                $catalogue->name=$data->{'name'};
                $catalogue->description=$data->{'description'};

                $catalogue->importAutorisations($data);

                R::store($catalogue);
        }
    }

    public function json() {
        $a=parent::json();
        try {
            $a["recordsTotal"]=$this->bean->countOwn( 'ressource' );
        } catch (Exception $e) {}
        return $a;
    }
}

class Model_Parameter extends Model_Base {

    public function json() {
        $a=parent::json();
        $a["value"]=$this->value;
        return $a;
    }

    public static function get($name,$default) {
        $parameter = R::findOne('parameter', 'name = ?',array($name));
        if (! $parameter ) {  return $default ;}
        return $parameter->value;
    }

    public static function set($name,$value) {
        $parameter = R::findOne('parameter', 'name = ?',array($name));
        if (! $parameter )               {
            $parameter=R::dispense('parameter');
            $parameter->tag=$name;
            $parameter->name=$name;
        }
        $parameter->value=$value;
        R::store($parameter);
    }

    // Pas de context pour un Parametre
    function getArrContext($bWithGarCounter=false) {
        return [];
    }

}

class Model_Context extends RedBean_SimpleModel implements \JsonSerializable {

    // $bWithGarCounter a false permet de ne pas remonter les
    // compteurs du GAR
    public function json($bWithGarCounter=false) {
        $a=array();
        $a["id"]=$this->id;
        $a["name"]=$this->name;
        $a["tag"]=$this->tag;
        $a["actif"]=$this->actif;
        $a["editable"]=$this->isEditable();
        $a["activable"]= $this->isVisible() && $this->isActivable();
        //$a["nbusers"]= count($this->sharedUserList);

        // Pas d'initialisation GAR on ne va pas chercher à récupérer des élements du GAR
        if ($this->name==$this->tag || !$this->garStep) {
            return $a;
        }

        // Configuration GAR =============================
        $gar = $this->getGarConfig();
        if ($gar) {
            //$a["garStatus"]=$gar->isOk()?Gar::OPERATIONEL:$gar->getError();
            $a["garConfig"]= $gar->tag;
            $a["garIcon"]  = $gar->icon;
            $a["garActif"] = $gar->actif;
        } else {
            //$a["garStatus"]="";
            $a["garConfig"]="";
            $a["garIcon"]="";
            $a["garActif"]=false;
        }

        $a["garStep"] = $this->garStep;
        $a["garStepMsg"] = $this->garStepMsg;

        // Compteur du GAR
        if ($bWithGarCounter) {
            $instances = $this->ownGarinstanceList;
            $a["garInstances"] = count($instances);

            if (!$this->library ) {
                $lib=R::findOne('library','uaj = ?',array($this->tag));
                if ($lib) { 
                    $this->library = $lib;
                    R::store($this);
                }
            }
            //$a["nbInstances"]  = $this->library?count($this->library->ownInstance):0;

            $ressources = $this->sharedRessourceList;
            $a["garRessources"] = count($ressources);
        }
        
        
        $a["garAccess"] = intval($this->garAccess);
        
        return $a;
    }

    public function getGarConfig() {
        return $this->gar?$this->gar:GAR_DEFAULT();
    }

    public function jsonSerialize (  ) {
        return json_encode($this->json());
    }

     public function isVisible() {
        if ($this->tag==GLOBAL_CONTEXT()->tag) return false;

        if (strlen($this->tag) < 8) return false;

        if (USER()->isAdmin()) return true;
        if (USER()->isGestAcad()) return true;

        
        

        return USER()->hasContext($this);
    }

    public function isActivable() {
        return ($this->tag != GLOBAL_CONTEXT()->tag) && USER()->isAdmin();
    }

    public function isEditable() {
        return (USER()->isAdmin());
    }

    public function isActif() {
        return $this->actif;
    }

    public function isGarAvailable() {
        $gar = $this->getGarConfig();
        if ($gar &&  ! $gar->isRessourcesAvailable() ) {
            return false;
        }
        return $this->isActif() ;
    }


}


// ======
class Model_Ressource extends Model_Base {

    public static $LOGO_PATH="../logos/";

    public static function import($datas,$app) {
        if (!is_array($datas)) {
            $app->sendError("Format de données incorrect");
        }
        $all=array();
        foreach ($datas as $data)
        {
                $ressource = R::findOne('ressource', 'tag = ?',array(normalizeTag($data->{'tag'})));
                if (!$ressource) {
                    $ressource=R::dispense('ressource');
                    $ressource->actif=false;
                }
                if (!$ressource->isEditable()) continue;
                $ressource->tag=$data->{'tag'};
                $ressource->name=$data->{'name'};
                $ressource->url=$data->{'url'};

                $ressource->importProperty($data,'description');
                $ressource->importProperty($data,'note');
                $ressource->importProperty($data,'subscribe');
                $ressource->importProperty($data,'actif',true);

                $ressource->importAutorisations($data);


                if (!$ressource->importProperty($data,'logo')) {
                    if (file_exists(self::$LOGO_PATH.$ressource->tag.".png")) {
                       $ressource->logo=$ressource->tag.".png";
                    }
                }

                $ressource->importProperty($data,'urlaccess');

                if (property_exists($data, 'ressource')) {
                    $ressourceDep = $app->mustExistAndVisible('ressource',$data->{'ressource'});
                    $ressource->ressource=$ressourceDep;
                }

                $catalogue=null;
                if (property_exists($data, 'catalogue')) {
                    $catalogue = $app->mustExistAndWritable('catalogue',$data->{'catalogue'});
                    $ressource->catalogue=$catalogue;
                }

                if (property_exists($data, 'category')) {
                    $category = $app->mustExistAndVisible('category',$data->{'category'});
                    $ressource->category=$category;
                }

                if (property_exists($data, 'sso_attr')) {
                    $ressource->sso_attr=$data->{'sso_attr'};
                } else {
                    $ressource->sso_attr=" ";
                }

                R::store($ressource);

                if (property_exists($data, 'library')) {
                    $library = $app->mustExistAndWritable('library',$data->{'library'});
                    $ressource->instantiate($library,$app);
                }

                /*if ($catalogue) {
                    $catalogue->ownRessourceList[]=$ressource;
                    R::store($catalogue);
                }*/
        }
    }


    public function dispense(){
           parent::dispense();
           $this->icon="";
           $this->url="http://";
    }

    public function hasSso() {
        return   $this->sso_attr != null && trim($this->sso_attr)!="";
    }

    public function isActif() {
        return $this->actif;
    }

    public function isVisible() {
        // Non actif => Que Admin a le droit de voir
        if (!$this->actif && ! USER()->isAdmin()) {return false;}
        // Ressource du GAR et User est GarAdmin
        if (USER()->isGarAdmin() && $this->gar)   {return true;}
        return parent::isVisible();
    }

    public function sso() {
        $tag=$this->tag;
        

        list($error,$url,$message,$arrCode)=$this->getAccessUrl();;
        if ($error) return null;

        if (!$url) $url= $this->url;
        $url=str_replace("https://".PARAM("SERVEUR_SSO","").":".PARAM("PORT_SSO","")."/?service=","",$url);
        $url=urldecode($url);
        $parse = parse_url($url);

        // Pas de host ??? sans doute une ressource invalide
        if (!isset($parse["host"]) ) {
            return [];
        }

        // Tag peut ne pas exister si c'est une création manuelle
        // Si c'est le cas on prend le nom dns de l'host de la ressource
        if (!$tag) {$tag=$parse["host"];}

        $a=array("name"=>$tag,
                        "baseurl"=>((isset($parse["path"]) && $parse["path"])!=null)?$parse["path"]:"/",
                        "scheme"=>"both",
                        "addr"=>$parse["host"],
                        "typeaddr"=>"dns",
                        "filter"=>$this->sso_attr);
        return $a;

    }

    // $bWithoutContext a false permet de ne pas tout récupérer
    public function json($bWithoutContext=false) {
       
        if ($bWithoutContext) {
            $a=parent::jsonWithoutContext();
        } else {
            $a=parent::json();
        }

        $a["logo"]=$this->getLogoUrl();
        if (!$this->urlaccess) $this->urlaccess=$this->url;
        $a["urlaccess"]=$this->urlaccess;
        list($error,$urlaccess,$message,$arrCode)=$this->getAccessUrl();
        $a["urlaccess_eval"]=$urlaccess;
        $a["error"]=$error;
        if ($this->actif==null) $this->actif=false;
        $a["actif"]=$this->actif;
        $a["msgerror"]=$message;
        $a["sso_attr"]=$this->sso_attr;
        $a["code_in_error"]=$arrCode;
        $a["url"]=$this->url;
        $a["subscribe"]=($this->subscribe!=null)?$this->subscribe:false;
        if ($this->catalogue) $a["catalogue_id"]=$this->catalogue->id;
        if ($this->ressource) $a["ressource_id"]=$this->ressource->id;
        if ($this->category)  $a["category_id"]=$this->category->id;

        // Si la ressource est lié a une autre
        if ($this->ressource) {
            list($err,$ressource_urlaccess,$m,$c)=$this->ressource->getAccessUrl();
            if (!$err) {
                $a["ressource_urlaccess"]=$ressource_urlaccess;
                $a["ressource_name"]=$this->ressource->tag;
                $a["ressource_url"]=$this->ressource->url;
                $a["ressource"]=$this->ressource->id;
            }
        }

        $a["count"]=intval($this->count);
        $a["points"]=intval($this->points);
        if ($a["count"]!=0)
            $a["rate"]=$a["points"]/$a["count"];
        else
            $a["rate"]=0;

        return $a;
    }

    public function getLogoUrl() {
        if (strpos($this->logo,"http")===0) {
            return $this->logo;
        }
        $d=new DateTime($this->updated);
        $st=$d->getTimestamp();
        return "api/ressource/logo/".$this->id."/".$st;
    }

    public function instantiate($library,$app,$params=null) {
        // Vérification des droits d'accès sur la library
        if (! $library || ! $library->isWritable() )
        { $app->sendError("Bibliothèque #${library_id} introuvable où droit insuffisant pour y ajouter des ressources"); }

        $all = R::find( 'instance', ' ressource_id = ? and library_id = ? ', array( $this->id,$library->id ) );
        if (count($all)!=0) return null;

        // Mise à jour de l'instance
        $instance=R::dispense("instance");
        $instance->ressource=$this;

        // Mise a jour des paramètres
        if ($app->request()->post("params")) {
            $instance->params=json_encode($app->request()->post("params"));
        } else if ($params != null )
        {
           $instance->params=json_encode( $params );
        } else
        {
           $instance->params=json_encode(array());
        }
        R::store($instance);


        // Ajout de l'instance dans la library
        $library->ownInstanceList[] = $instance;
        R::store($library);

        return $instance;
    }

    public function getAccessUrl() {
            $urlaccess=$this->url;
            if ($this->urlaccess) {
                $urlaccess=$this->urlaccess;
            }

            // Remplacement des paramètres
            $message="";$bError=false;$arrCode=array();
            $pattern = '/\[(.*?)\]/';
            preg_match_all($pattern, $urlaccess, $matches, PREG_OFFSET_CAPTURE);
            foreach($matches[1] as $match) {
                $pat=$match[0];
                $param= R::findOne('parameter', 'name = ?',array($pat));
                if ($param) $urlaccess=str_replace("[$pat]",$param->value,$urlaccess);
                else {$bError=true;$message="$message $pat:non renseigné<br/>";$arrCode[]=$pat;}
            }

            return array($bError,$urlaccess,$message,$arrCode);

    }
}

// ======
class Model_Instance extends Model_Base {


   public function json() {
        $a=parent::json();
        $ressource=$this->ressource;

        $a["logo"]=$ressource->getLogoUrl();
        $a["name"]=$ressource->name;
        $a["ress"]=$ressource->id;
        $a["library"]=$this->library->id;
        $a["libraryName"]=$this->library->name;
        $a["score"]= 0;
        $a["description"]=$ressource->description;
        if ($ressource->catalogue) {
            $a["catalogue"]=$ressource->catalogue->id;
        }
        if ($ressource->category) {
            $a["category"]=$ressource->category->id;
        } else
        {
            $a["category"]=CATEGORY_NONE()->id;
        }

        $url=$ressource->url;
        list($error,$urlaccess,$message,$arrCode)=$ressource->getAccessUrl();;
        $a["error"]=$error;
        $a["msgerror"]=$message;

        // Si la ressource est lié a une autre
        if ($ressource->ressource) {
            list($err,$ressource_urlaccess,$m,$c)=$ressource->ressource->getAccessUrl();
            if (!$err) {
                $a["ressource_urlaccess"]=$ressource_urlaccess;
                $a["ressource_name"]=$ressource->ressource->tag;
                $a["ressource"]=$ressource->ressource->id;
            }
        }

        $a["count"]=intval($this->count);
        $a["points"]=intval($this->points);
        if ($a["count"]!=0)
            $a["rate"]=$a["points"]/$a["count"];
        else
            $a["rate"]=0;

        $a["access"]=intval($this->access);

        // Si il s'agit d'une url paramétrée, on va renseigner les paramètres
        $params=json_decode($this->params);
        if ($ressource->urlaccess && is_array($params)) {
            foreach ($params as $param) {
                $urlaccess=str_replace("(".$param->{'libelle'}.")",$param->{'valeur'},$urlaccess);
            }
            $a["params"]=$params;
        }

        $a["url"]=$url;
        $a["urlaccess"]=$urlaccess;
        $a["garOrigin"]=$this->garOrigin;
        $a["garInstance"]=$this->garInstance;
        $a["nomSourceEtiquetteGar"] = $this->nomSourceEtiquetteGar;
        // #30129 Afficher le code ARK pour chaque ressource du GAR
        $a["idType"]      = $this->ressource->idType;
        $a["idRessource"] = $this->ressource->idRessource;
        return $a;
    }


    // ref #29656 
    // Possibilité de modifier / supprimer la resource 
    // en tant que ADMIN LOCAL
    public function isDeletable() {
        // Context établissement -> AdminLocal => OK à le droit
        if ($this->library->flag==Model_Library::$FLAG_CONTEXT && !$this->ressource->gar ) {
            if (USER()->isAdminLocal()) {return true;}
        }
        return parent::isDeletable();
    }

    public function isWritable() {
        // Context établissement -> AdminLocal => OK à le droit
        if ($this->library->flag==Model_Library::$FLAG_CONTEXT  && !$this->ressource->gar) {
            if (USER()->isAdminLocal()) {return true;}
        }
        return parent::isWritable();
    }

    // Pas de context pour une instance
    function getArrContext($bWithGarCounter=false) {
        return [];
    }


}

class Model_Garinstance extends Model_Base {

    public function isVisible() {
        return $this->user->id == USER()->id;
    }

    public function getRessource() {
        return $this->bean->ressource;
    }

    // Pas de context pour un Garinstance
    function getArrContext($bWithGarCounter=false) {
        return [];
    }

    public function json() {
        $a=parent::json();
        $a["access"]=intval($this->access);
        return $a;
    }

}

// ======
class Model_Library extends Model_Base {

    public function isContextuable() {return true;}

    public static $FLAG_PERSONEL='P';
    public static $FLAG_CONTEXT='C';

    public static function import($datas,$app) {
        foreach ($datas as $data)
        {
            $library = R::findOne('library', 'tag = ?',array(normalizeTag($data->{'tag'})));
            if (!$library)               {$library=R::dispense('library');   }
            if (!$library->isEditable()) continue;
            $library->tag=$data->{'tag'};
            $library->name=$data->{'name'};
            $library->description=$data->{'description'};
            R::store($library);
        }
    }

    public function isDeletable() {
        if ($this->flag==self::$FLAG_PERSONEL && $this->isOwner()) return false;
        if ($this->flag==self::$FLAG_PERSONEL)                     return USER()->isAdministrateur();
        return parent::isDeletable();
    }

    public function isVisible() {
        if ($this->flag==self::$FLAG_PERSONEL) {
            return  $this->isOwner();
        }
        return parent::isVisible();
    }

    public function isWritable() {
        if ($this->flag==self::$FLAG_PERSONEL) {
            return  $this->isOwner();
        }
        if ($this->flag==self::$FLAG_CONTEXT) {
            if (USER()->isDir()) {return true;}
        }
        return parent::isWritable();
    }

    public function isEditable() {
        if ($this->flag==self::$FLAG_PERSONEL) return false;
        return parent::isEditable();
    }

    public function update(){
        parent::update();
        if ($this->flag==self::$FLAG_PERSONEL) {
            $this->sharedContextList=array();
        }
    }

    // Vérification si les ressources associées à la librairie
    // sont toujours présentes
    public function checkRessources() {
        if ($this->ownInstance) {
            foreach($this->ownInstance as $instance)
            {
                $ressource=$instance->ressource;
                if (!$ressource) {
                   // Il n'y a plus de ressource associé à l'instance
                   // On va donc supprimer l'instance
                   R::trash($instance);
                } 
            }
        }
    }

    public function jsonWithOrder($order) {
        $a=parent::json();
        $arr=array();

        if ($this->ownInstance) {
            foreach($this->ownInstance as $instance)
            {
                if (!$instance->isVisible()) continue;

                $ressource=$instance->ressource;
                if (!$ressource) {
                   // Il n'y a plus de ressource associé à l'instance
                   // On va donc supprimer l'instance
                   R::trash($instance);
                } else {
                    $arr[]=$instance->json();
                }
            }
        }

        if ($this->contextual) {$a["contextual"]=true;}
        $a["personnal"] =   $this->flag==self::$FLAG_PERSONEL;
        $a["instances"] =   $arr;
        $a["count"]     =   count($arr);
        $a["order"]     =   $order . $this->name;
        try {
            $a["recordsTotal"]=$this->bean->countOwn( 'instance' );
        } catch (Exception $e) {}
        return $a;
    }


}

// ===== Configuration du GAR =======================================
class Model_Gar extends Model_First {

    # fixes #26625 Problème lors de l'envoi des fichiers GAR à la plateforme de test
    # [A-Z][0-9] => [A-Z][A-Z0-9] / Code ENT peut être sur 2 caractères alpha
    const ARCHIVE_PATTERN = '/^([A-Z][A-Z0-9])_GAR-ENT_Complet_([0-9]{8})_([0-9]{6}).tar.gz$/';
    const ERROR_PATTERN = '/^([A-Z][A-Z0-9])_GAR-ENT_RapportErreurs_([0-9]{8})_([0-9]{6})_[1-2]D.tar.gz$/';


    const STEP_INACTIF      = -1;
    const STEP_REQUESTED    = 0;
    const STEP_INTEGRATED   = 1;

    
    public function isVisible()       {return USER()->isAdmin() || USER()->isGar();}
    public function isEditable()      {return USER()->isAdmin();}

    public function isDefaut()        {return $this->defaut == "o";}

    public function json() {
        
        $a=array("id"   => $this->id,
                 "name" => $this->name,
                 "tag"  => $this->tag,
                 "icon" => $this->icon,
                 "description"=>$this->description,
                 "locked"  => $this->locked,
                 "actif"   =>  $this->actif,
                 "editable" => $this->isEditable(),
                 "public" => [
                     "metadata" => "https://" . PARAM("SERVEUR_SSO") . ":" . PARAM("PORT_SSO") . "/saml/metadata" ,
                     "csr"      => BASE_URL() . "/public/gar/" . $this->tag . "/csr" ,
                     "pubkey"   => BASE_URL() . "/public/gar/" . $this->tag . "/publicKey"
                 ],
                 "check" => [
                    "depot"     =>json_decode($this->checkerDepot(false)),
                    "archive"   =>json_decode($this->checkerArchive(false)),
                    "certificat"=>json_decode($this->checkerCertificat(false)),
                    "samlRes"   =>json_decode($this->checkerSamlRes(false)),
                    "samlAff"   =>json_decode($this->checkerSamlAff(false)),
                    "log"       =>$this->getLastArchiveLog(),
                 ],
                 "renater" => [
                     "samlRes"  => $this->samlRes,
                     "samlAff"  => $this->samlAff,
                     "depot"    => $this->depotUrl,
                     "pem"      => ($this->wsPem &&  $this->wsPem != PAD_DEFAULT_KEY),
                     "samlResEntityID" => $this->samlResEntityID,
                     "samlAffEntityID" => $this->samlAffEntityID
                 ]
                 
                );
        return $a;
    }

    public function getLastArchiveLog() {
        return $this->lastArchiveLog?json_decode($this->lastArchiveLog):["name"=>""];
    }

    private function _isStatusOk($jsonStatus) {
        $a = json_decode($jsonStatus,true);
        return (isset($a["status"]) && $a["status"]=="success" );
    }

    private function _getStatusMessageIf($jsonStatus,$value) {
        $a = json_decode($jsonStatus,true);
        if (isset($a["status"]) && $a["status"]==$value) {
            return $a["message"];
        }
        return "";
    }

    public function getError() {

        $errorsByPriority = [
            $this->checkerDepot(),
            $this->checkerArchive(),
            $this->checkerCertificat(),
            $this->checkerSamlRes(),
            $this->checkerSamlAff()
        ];

        foreach($errorsByPriority as $status) {
            $message = $this->_getStatusMessageIf($status,"error");
            if ($message) {return $message;}
        }

        foreach($errorsByPriority as $status) {
            $message = $this->_getStatusMessageIf($status,"inconnu");
            if ($message) {return $message;}
        }

        return Gar::OPERATIONEL;
    }

    public function isOk() {
        return  $this->_isStatusOk($this->checkerDepot())       &&
                $this->_isStatusOk($this->checkerArchive())     &&
                $this->_isStatusOk($this->checkerCertificat())  &&
                $this->_isStatusOk($this->checkerSamlRes())     &&
                $this->_isStatusOk($this->checkerSamlAff());
    }

    public function isRessourcesAvailable() {
        return  
                $this->_isStatusOk($this->checkerCertificat())  &&
                $this->_isStatusOk($this->checkerSamlRes())     &&
                $this->_isStatusOk($this->checkerSamlAff());
    }

    public function isDepotKeyValid() {
        return $this->depotPublicKey &&  $this->depotPrivateKey &&
               $this->depotPublicKey != PAD_DEFAULT_KEY && $this->depotPrivateKey != PAD_DEFAULT_KEY ;
    }

    public function isWebServiceConfValid() {
        return $this->wsKey && $this->wsPem &&
               $this->wsKey != PAD_DEFAULT_KEY && $this->wsPem != PAD_DEFAULT_KEY ;
    }


    // SFTP over php : http://phpseclib.sourceforge.net/

    public function checkerArchive($bforce=false) {

        set_time_limit(500); // 500s 3mn

        if ($bforce || !$this->checkArchive) {

            $uploadDir = $this->getUploadDir();

            if (!file_exists($uploadDir)) {
                mkdir($uploadDir, 0744, true);
            }

            if (!file_exists($uploadDir . '/ERREUR')) {
                mkdir($uploadDir . '/ERREUR', 0744, true);
            }

            if (!file_exists($uploadDir . '/SUCCES')) {
                mkdir($uploadDir . '/SUCCES', 0744, true);
            }

            
            $sftp = new Net_SFTP($this->depotUrl);
            $key  = new Crypt_RSA();

            $garCode = PARAM("GAR_CODE");

            // Il y a déja un état ?
            $currentName = "";
            $current     = null;
            if ($this->checkArchive) {
                $current     = json_decode($this->checkArchive,true);
                if ($current["status"]=="waiting") {
                    $currentName = $current["name"];
                }

                // Si le status est en erreur pour cause de génération de XML GAR
                // on ne fait rien tant que l'on est dans cette situation
                // => Il est nécessaire de refaire un depot avec le LOG qui contient
                //    <STATUT>OK</STATUT>
                if ($current["status"]=="error" && isset($current["aaf2gar-error"])) {
                    return $this->checkArchive;    
                }
            }

            try {
                $key->loadKey($this->depotPrivateKey);
                if (!$sftp->login($garCode, $key)) {
                    $status = ["status"=>"error","message"=>"","date"=>time()];
                    // SI un etat en cours, on sauvegarde le message
                    if ($current) {
                        $status=$current;
                        if (!isset($status["lastMessage"])) {
                            $status["lastMessage"] = $current["message"] ; 
                        } else {
                            $status["lastMessage"] = "";
                        }
                    }

                    $status["status"]   = "error";
                    $status["message"]  = $status["lastMessage"] . " ( erreur de connexion au dépôt lors de la dernière vérification )";
                    $this->checkArchive = json_encode($status);
                } else 
                {

                    $archive = $sftp->nlist("../ENTRANT/" . $garCode);

                    if (count($archive)>=3) {
                        foreach($archive as $file) {
                            preg_match_all(Model_GAR::ARCHIVE_PATTERN,$file,$matches);
                            if (count($matches[0])) {
                                $name = $matches[0][0];
                                $this->checkArchive = json_encode(["status"  => "waiting",
                                                                   "name"    => $name, 
                                                                   "message" => "En attente d'intégration par le GAR",
                                                                   "date"    => time()]);
                                break;
                            }
                        }
                    } else {
                        $allArchives = [];

                        $archive = $sftp->nlist("../ERREUR/" . $garCode ); 
                        arsort($archive);
                       
                        //print_r($archive);
                        foreach($archive as $file) {
                            preg_match_all(Model_GAR::ARCHIVE_PATTERN,$file,$matches);
                            if (count($matches[0])) { 
                                $name = $matches[0][0];
                                $allArchives[$name] =  ["status"=>"error","name"=>$name, "message"=>"Erreur d'intégration" ,"date"=>time()]; 
                            }

                            preg_match_all(Model_GAR::ERROR_PATTERN,$file,$matches);
                            if (count($matches[0])) { 
                                $name = $matches[0][0];
                                $allArchives[$name] =  ["status"=>"error","name"=>$name, "message"=>"Erreur d'intégration" ,"date"=>time()]; 

                                if (!file_exists("../upload/".$this->id."/ERREUR/".$name)) {
                                    $sftp->get("../ERREUR/". $garCode."/" . $name , "../upload/".$this->id."/ERREUR/".$name );
                                }
                            }

                        }

                        // Reverse pour parcourir dans l'ordre décroissant d'ajout
                        // et ne prendre que le dernier
                        $archive = $sftp->nlist("../SUCCES/" . $garCode); 
                        arsort($archive);
                        $lastDate = null;
                        foreach($archive as $file) {
                            preg_match_all(Model_GAR::ARCHIVE_PATTERN,$file,$matches);
                            if (count($matches[0])) { 
                                $name = $matches[0][0];

                                $date = DateTime::createFromFormat('Ymd_His', $matches[2][0]."_".$matches[3][0]);
                                
                                if ( ($lastDate && $lastDate > $date) || !$date ) {continue;}
                                $lastDate = $date;
                            
                                $filename = $this->_getLocalArchiveFilename($name);
                                if (!file_exists($filename)) {
                                    $sftp->get("../SUCCES/". $garCode."/" . $name , $filename );
                                }

                                // Toujours pas de fichier => pb lors de la récupération
                                if (!file_exists($filename)) {
                                    $allArchives[$name] = ["status"=>"error",
                                                        "name"=>$name, "timestamp" =>$date->getTimestamp(),
                                                        "message"=> "Erreur de récupération de l'archive",
                                                        "date"=>time()]; 
                                } else {
                                    try {
                                        $this->_parseArchive($filename);
                                        $allArchives[$name] = ["status"=>"success",
                                                            "name"=>$name, "timestamp" =>$date->getTimestamp(),
                                                            "message"=> "Intégration OK",
                                                            "date"=>time()]; 
                                    } catch (\Exception $e) {
                                        $allArchives[$name] = ["status"=>"error",
                                                            "name"=>"", "timestamp" =>$date->getTimestamp(),
                                                            "message"=> "erreur de traitement de l'archive $name : " . $e->getMessage() ,
                                                            "date"=>time()]; 
                                    }
                                }
                                

                                

                                break;
                            }
                        }

                        

                        // On va parcourir le tableau par la fin des noms de fichiers
                        // ie : Classé par date décroissante
                        if (count($allArchives)) {
                            $archivesOrdered = [];
                            // Renomme les _RapportErreurs_ avec le mot Complet , pour 
                            // que les archives soient trié par ordre descroissant de date
                            foreach($allArchives as $key => $arch) {
                                $key=str_replace("_RapportErreurs_","_CompletRapportErreurs_",$key);
                                $archivesOrdered[$key] = $arch;
                            }
                            ksort($archivesOrdered);
                            $allArchives = array_reverse($archivesOrdered);
                            // Le premier élément correspond à la dernière archive trouvée
                            /*print_r($allArchives);
                            die($currentName);*/
                            $check = json_encode(reset($allArchives));
                            foreach($allArchives as $check) {
                                if ( ($currentName && $check["name"] == $currentName) || !$currentName  ) {
                                    $this->checkArchive = json_encode($check);
                                    break;
                                }
                            }                            
                        } else {
                            if (!$currentName) {
                                $this->checkArchive = json_encode(["status"=>"inconnu","name"=>"", "message"=>"Aucune archive trouvée","date"=>time()]);
                            }
                        }

                    }
                }
            } catch (\Exception $e) {
                if ($filename) {
                    try { unlink($filename); } catch (\Exception $e) {}
                }
                $logSftp = $sftp->getSFTPLog();
                $this->checkArchive = json_encode(["status"=>"error","name"=>"", "message"=>"GAR::checkerArchive erreur lors de la récupération de l'archive sur le dépôt [" . $e->getMessage() . "] $logSftp" ,"date"=>time()]);
            }

            $sftp->disconnect();

        }

        
        return $this->checkArchive;

    }

    private function getUploadDir() {
        return __UPDLOAD_DIR."/" . $this->id;
    }

    private function _parseArchive($filename) {
        $uploadDir = $this->getUploadDir();

        if (!file_exists($uploadDir)) {
            mkdir($uploadDir . '/extract', 0744, true);
        }

        if (!file_exists($uploadDir . '/extract')) {
            mkdir($uploadDir . '/extract', 0744, true);
        }

        $phar    = new PharData($filename);
        $tempdir = tempnam( $uploadDir . "/extract", str_replace(".tar.gz","",basename($filename)));
        if (file_exists($tempdir)) { unlink($tempdir); }
        
        $phar->extractTo($tempdir);
        foreach (glob($tempdir . "/*_Etab_*.xml") as $file) {
            $xml =simplexml_load_file($file,"SimpleXMLElement",0,
                                      "http://data.education.fr/ns/gar");
            
            foreach ($xml as $etabXml) {
                if ($etabXml->{"GARStructureNomCourant"}) {
                    $etab = R::findOne("context","tag = ?",array($etabXml->{"GARStructureUAI"}));

                    // fixes #26909 : Donné le nom qui est dans XML si pas de NOM pour un étab
                    if ($etab && ($etab->name==$etab->tag || !$etab->name)) {
                        $parts=explode("-",$etabXml->{"GARStructureNomCourant"});
                        if (count($parts)>2) {
                            $etab->name = $parts[1];
                            R::store($etab);
                        }
                    }
                    if ($etab && $etab->garStep == Model_Gar::STEP_REQUESTED ) {
                        $etab->garStep     = Model_Gar::STEP_INTEGRATED;
                        $etab->garStepMsg  = "Intégré par " .basename($filename) . " $file";
                        R::store($etab);
                    }
                }
            }
            
            
        }

        //system('/bin/rm -rf ' . escapeshellarg($tempdir), $retval);
   


    }

    private function _getLocalArchiveFilename($name) {
        //return sys_get_temp_dir() . "/" . $this->tag . "-" . $name;
        return $this->getUploadDir() . "/SUCCES/" .$name;
    }

    public function samlResHost() {
        $parsed = parse_url($this->samlRes);
        return $parsed["host"];
    }

    public function samlAffHost() {
        $parsed = parse_url($this->samlAff);
        return $parsed["host"];
    }

    public function samlPortailHost() {
        $parsed = parse_url($this->samlRes);
        return str_replace("sp-auth","sso-portail",$parsed["host"]);
    }

    // vérifie si la connexion sftp est OK
    // Utilisation de la clef privée
    public function checkerDepot($bforce=false) {

        if ($bforce || !$this->checkDepot) {
            $ssh = new Net_SSH2($this->depotUrl);
            $key = new Crypt_RSA();

            try {
                $key->loadKey($this->depotPrivateKey);
                if ($ssh->login(PARAM("GAR_CODE"), $key)) {
                    $this->checkDepot= json_encode(["status"=>"success","message"=>"Accès OK","date"=>time()]);
                    $ssh->disconnect();
                } else {
                    $message = implode(",",$ssh->getErrors());
                    if (!$message) {$message="Connexion impossible";}
                    $this->checkDepot= json_encode(["status"=>"error","message"=>$message,"date"=>time()]);
                }
            } catch(\Exception $e) {
                $this->checkDepot= json_encode(["status"=>"error","message"=>$e->getMessage(),"date"=>time()]);
            }
        }

        return $this->checkDepot;
        
    }

    // Deposer des fichiers sur le dépot
    public function deposerFichiers($name,$files,$log) {
        //define('NET_SFTP_LOGGING', NET_SFTP_LOG_COMPLEX);

        // Vérification de la date de l'archive en fonction de son nom
        // avant le dépot
        preg_match_all(Model_GAR::ARCHIVE_PATTERN,$name,$matches);
        $date = DateTime::createFromFormat('Ymd_His', $matches[2][0]."_".$matches[3][0]);
        if (!$date) {
            throw new \Exception("La date de l'archive n'a pu être derterminée à partir de son nom ".$name);
        }

        // On va vérifier le rapport si tout est OK
        $xml = simplexml_load_string($log, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array = json_decode($json,TRUE);
        // On va déposer uniquement si le rapport de génération est OK
        if ($array["STATUT"] ==  "OK") {
            $sftp = new Net_SFTP($this->depotUrl);
            $key = new Crypt_RSA();
            $key->loadKey($this->depotPrivateKey);
            if (!$sftp->login(PARAM("GAR_CODE"), $key)) {
                throw new \Exception("Impossible de se connecter au dépot");
            }
            $sftp->chdir(PARAM("GAR_CODE"));

            foreach($files as $file) {
                if (!$sftp->put($file["name"],$file["file"],NET_SFTP_LOCAL_FILE)) {
                    throw new \Exception("Impossible de déposer ".$file["name"]);
                }
            }

            $sftp->disconnect();
            $this->checkArchive   = json_encode(["status"    => "waiting",
                                           "name"      => $name, 
                                           "timestamp" => $date->getTimestamp(),
                                           "message"   => "Archive déposée via api le " . date("Y-m-d H:i:s"). " en attente de traitement",
                                           "date"      => time()]);
        } else {
            $this->checkArchive   = json_encode(["status"    => "error",
                                           "aaf2gar-error" => true,
                                           "name"      => $name, 
                                           "timestamp" => $date->getTimestamp(),
                                           "message"   => "Le log de la génération des fichiers GAR indique au moins une erreur, archive non déposée",
                                           "date"      => time()]);
            $this->lastArchiveLog = json_encode(["name"=>$name, "content"=>base64_encode($log)]);
            // Sauvegarde l'état et on lève une exception
            R::store($this);
            throw new \Exception("Archive non déposée car le log de génération AAF2GAR indique au moins une erreur");
        }
        
        

        

        $this->lastArchiveLog = json_encode(["name"=>$name, "content"=>base64_encode($log)]);

    }

    // vérification de la concordance du certificat et de la clef privée
    public function checkerCertificat($bforce=false) {

        if ($bforce || !$this->checkCertificat) {

            if (!$this->isWebServiceConfValid()) {
                $this->checkCertificat =  json_encode(["status"=>"inconnu","message"=>"non configuré","date"=>time()]);
            } else {
                // vérification du certificat avec la CSR et la private Key 
                $rsa = new Crypt_RSA();
                $rsa->loadKey($this->wsKey);
                $pubkey1 = $rsa->getPublicKey();

                $x509 = new File_X509();
                $x509->loadX509($this->wsPem);
                $pubkey2 = $x509->getPublicKey();

                $csr = new File_X509();
                $csr->loadCSR($this->wsCSR);
                $pubkey3 = $csr->getPublicKey();

                // première vérif
                if (($pubkey1 != $pubkey2) || ($pubkey2 != $pubkey3)) {
                    $ret = json_encode(["status"=>"error",
                                        "message"=>"Les clefs publiques des CSR/private key/public key ne correspondent pas",
                                        "date"=>time()]);
                } else 
                {
                    $check = openssl_x509_check_private_key($this->wsPem,$this->wsKey);
                    if ($check) {
                        $ret = json_encode(["status"=>"success","message"=>"OK","date"=>time()]);
                    } else {
                        $ret = json_encode(["status"=>"error","message"=>"Le certificat et la clef privée ne correspondent pas",
                                    "date"=>time()]);
                    }
                }

                $this->checkCertificat = $ret;
            }
        }

        return $this->checkCertificat ;

    }

    // Extraction de entityID d'une Métadata saml
    private function _getEntityID($urlOfMetadata) {
        $xml = file_get_contents_withProxy($urlOfMetadata);
        if ($xml instanceof \Exception) {
            return $xml->getMessage();
        }
        try {
            $doc = new DomDocument();
            $doc->loadXML($xml);
            $elt = $doc->getElementsByTagName("EntityDescriptor")->item(0);
            $array=[];
            if ($elt->hasAttributes()) 
            { 
                foreach ($elt->attributes as $attr) { $array[$attr->nodeName] = $attr->nodeValue; } 
            } 
            if (isset($array['entityID'])) {
                return $array['entityID'];
            }
        } catch (\Exception $e) {
            return $e->getMessage();
        }

        return "";
    }

    private function _checkSaml($entityID) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, true);

        $proxy=PARAM("proxy");
        if ($proxy) {curl_setopt($ch,CURLOPT_PROXY,$proxy);}
        $sso = "https://".PARAM("SERVEUR_SSO","").":".PARAM("PORT_SSO","")."/saml?sp_ident=" . urlencode($entityID);
        curl_setopt($ch, CURLOPT_URL, $sso);

        $ret=["status"=>"inconnu","message"=>"non vérifié","date"=>time()];

        $response = curl_exec($ch);
        
        // On tente hors proxy, parfois le sso ne nécessite pas de proxy (Besac)
        if (!$response && $proxy) {
          curl_setopt($ch,CURLOPT_PROXY,null);
          curl_setopt($ch, CURLOPT_URL, $sso);
          $response = curl_exec($ch);
        }

        if ($response) {
            // entityID non trouvée
            if (strpos($response,"indisponible")!==false) {
                $ret = ["status"=>"error",
                        "message"=>"metadata=".$entityID." absent sur ".PARAM("SERVEUR_SSO","").":".PARAM("PORT_SSO",""),
                        "infos" => "Veuillez vérifier que les metadata sont bien intégrés au serveur SSO",
                        "response" => $response,
                        "date"=>time()];
            } else 
            // Si entityID est trouvé, il y a une redirection HTTP 303
            // vers la mise sso
            {
                $status   = curl_getinfo($ch,CURLINFO_HTTP_CODE);
                if ($status==303) {
                    $ret = ["status"=>"success",
                        "message"=>"OK",
                        "infos" => "metadata=".$entityID." déclaré sur ".PARAM("SERVEUR_SSO","").":".PARAM("PORT_SSO",""),
                        "date"=>time()];
                } else {
                    $ret=["status"=>"error","message"=>"Error code ".$status,"date"=>time(),"response"=>$response];
                }
            }
        } else {
            $status   = curl_getinfo($ch,CURLINFO_HTTP_CODE);
            $ret = ["status"=>"error",
                        "message"=>"ERREUR Accès impossible à ".PARAM("SERVEUR_SSO","").":".PARAM("PORT_SSO",""),
                        "infos" => "",
                        "date"=>time()];
        }
        

        return json_encode($ret);

    }

    // Vérification de l'intégration des metadata SAML de
    // l'accès aux ressources
    public function checkerSamlRes($bforce=false) {
        if (!$this->samlResEntityID || $bforce) {
            //$this->samlResEntityID = $this->_getEntityID($this->samlRes);
            $this->samlResEntityID  = "econnect-gar-res-" . $this->tag;
        }

        if (!$this->samlResEntityID) {
            return json_encode(["status"=>"error",
                                "message"=>"entityID non défini",
                                "date"=>time()]);
        }

        if ($bforce || !$this->checkSamlRes) {
            $this->checkSamlRes = $this->_checkSaml($this->samlResEntityID);
        }

        return $this->checkSamlRes;
    }

    // Vérification de l'intégration des metadata SAML de
    // l'accès au module d'affecation
    public function checkerSamlAff($bforce=false) {
        if (!$this->samlAffEntityID || $bforce) {
            //$this->samlAffEntityID = $this->_getEntityID($this->samlAff);
            $this->samlAffEntityID  = "econnect-gar-aff-" . $this->tag;
        }

        if (!$this->samlAffEntityID) {
            return json_encode(["status"=>"error",
                                "message"=>"entityID non défini",
                                "date"=>time()]);
        }

        if ($bforce || !$this->checkSamlAff) {
            $this->checkSamlAff = $this->_checkSaml($this->samlAffEntityID);
        }

        return $this->checkSamlAff;
    }

    // Récupération du fichier contennant le certificat
    public function getWsPem()  {
        $filename = sys_get_temp_dir() . "/garWSCert-". $this->name . "-". md5($this->wsPem) . ".pem";
        if (!file_exists($filename)) {file_put_contents($filename,$this->wsPem);}
        return $filename;
    }

    // récupération du fichier contenant la clef privée du certificat
    public function getWsKey()  {
        $filename = sys_get_temp_dir() . "/garWSCert-". $this->name . "-". md5($this->wsKey) . ".key";
        if (!file_exists($filename)) {file_put_contents($filename,$this->wsKey);}
        return $filename;
    }

    // Retourne les uajs actif pour ce gar
    public function getUajs($step=Model_Gar::STEP_REQUESTED) {
        $all=R::findAll('context', 'actif = ?',array(1));
        $ret=[];
        foreach($all as $c) {
            if ($c->garStep<$step) {continue;}
            if ($this->isDefaut() && ! $c->gar ) {
                $ret[]=$c->tag;
            } elseif ($c->gar && $c->gar->id == $this->id) {
                $ret[]=$c->tag;
            }
        }
        return $ret;
    }
}

// ===== PROFIL =======================================
class Model_Profil extends Model_First {

    public function isContextuable() {return true;}
    public function isVisible()      {return $this->hasRight(self::$RIGHT_READ);}

    public function json() {
         $a=array("id"=>$this->id,"name"=>$this->name,"description"=>$this->description,
                    "tag"=>$this->tag,"context"=>$this->context,"text"=>$this->text,
                    "expression"=>$this->expression,
                    "human" => ($this->human?$this->human:$this->text),
                    "writable"=>false,"locked"=>$this->isLocked(),
                    "deletable"=>$this->isDeletable(),
                    "editable"=>$this->isEditable());

         if ($this->user) $a["user"]=$this->user->json();

         return $a;

    }

    public function isDeletable() {
        if ($this->id==PROFIL_ADMIN()->id) return false;
        if ($this->id==PROFIL_ADMINLOCAL()->id) return false;
        if ($this->id==PROFIL_ALL()->id) return false;
        return parent::isDeletable();
    }

    // Importation d'un profil
    public static function import($datas,$app) {
        foreach ($datas as $data)
        {
                $profil = R::findOne('profil', 'tag = ?',array(normalizeTag($data->{'tag'})));
                if (!$profil)               {$profil=R::dispense('profil');   }
                if (!$profil->isEditable()) continue;
                $profil->tag=$data->{'tag'};
                $profil->name=$data->{'name'};
                $profil->description=$data->{'description'};
                $profil->expression=$data->{'expression'};
                $profil->text=$data->{'text'};
                $profil->importAutorisations($data);
                R::store($profil);
        }
    }

}
//===========================================================




class Model_User extends RedBean_SimpleModel {

    public function load(){
        $this->profil=array();
    }

    public function open() {
        $this->bean->setMeta("garAdminContext",json_decode($this->garAdminOf,true));
    }

    public function update(){
        if (!$this->token) {
            $this->token=_GUID();
        }
       
        $this->garAdminOf = json_encode($this->bean->getMeta("garAdminContext"));
    
    }

    public function isDir()         {return $this->title=="dir" || $this->profil=="direction" || $this->profil=="national_4"; }
    public function isDoc()         {return $this->title=="doc" || $this->profil=="documentaliste"; }
    public function isEleve()       {return $this->profil=="eleve" || $this->profil=="national_1"; }
    public function isResponsable() {return $this->profil=="responsable" || $this->profil=="national_2"; }
    public function canbeRespAffectation() {return !$this->isEleve() && ! $this->isResponsable(); }

    public function getUajs() {
        $uajs = explode("|",strtoupper($this->rne));
        return $uajs;
    }
 
    public function isGarAdminOf($uaj) {
        $arr = $this->bean->getMeta("garAdminContext");
        if (!is_array($arr)) {return false;}
        return isset($arr[$uaj]);
    }

    public function getGarUajAdminOf() {
        $arr = $this->bean->getMeta("garAdminContext");
        if ($arr == null ) {return [];}
        $keys = array_keys($arr);
        return array_unique($keys);
    }

    public function resetGarAdminContext() {
        $this->bean->setMeta("garAdminContext",[]);
    }

    public function isGarAdmin() {
        $arr = $this->bean->getMeta("garAdminContext");
        if (!is_array($arr)) {return false;}
        return count($arr) != 0;
    }

    // Ajoute un établissement d'administration du GAR
    public function addGarAdminOf($uaj) {
        $arr = $this->bean->getMeta("garAdminContext");
        if (!$arr) {$arr = array();}
        $arr[$uaj] = USER()->fullname. "|". date(DateTime::ISO8601); 
        $this->bean->setMeta("garAdminContext",$arr);
        $this->garAdminOf = json_encode($arr);
    }

    // Suppression un établissement d'administration du GAR
    public function removeGarAdminOf($uaj) {
        $arr = $this->bean->getMeta("garAdminContext");
        if (!is_array($arr)) {return;}
        unset($arr[$uaj]);
        $this->bean->setMeta("garAdminContext",$arr);
        $this->garAdminOf = json_encode($arr);
    }

    // Permet d'importer des administrateurs
    public static function import($datas,$app) {
        if (!is_array($datas)) {
            $app->sendError("Format de données incorrect");
        }
        foreach ($datas as $data)
        {
            if (property_exists($data, 'email')) {$field='email';}
            if (property_exists($data, 'uid'))   {$field='uid';}
            if (property_exists($data, 'user'))  {$field='user';}

            $users = R::find('user', "$field = ?",array($data->{$field}));
            foreach($users as $user) {
                if (property_exists($data, 'admin'))   {$user->admin=strtoupper($data->{'admin'});}
            }
            R::storeAll($users);
        }
    }

    public function getUid() {
        return $this->uid;
    }

    public function isAdmin() {
        return $this->uid=="admin" || $this->admin=="GLOBAL" ||
               array_key_exists(PROFIL_ADMIN()->id,$this->getProfils());
    }

    public function isAdminLocal() {
        return $this->admin=="LOCAL" || $this->isDir() ||
               array_key_exists(PROFIL_ADMINLOCAL()->id,$this->getProfils());
    }

    public function isGestAcad() {
        return array_key_exists(PROFIL_ACADEMIQUE()->id,$this->getProfils());
    }

    public function isGar() {
        return $this->uid=="_gar_api";
    }

    public function isAdministrateur() {
        return $this->isAdmin() || $this->id==ADMIN()->id;
    }

    public function jsonWithContext($context) {
        $data = $this->json();
        $data["garAdmin"] = $this->isGarAdminOf($context->tag);
        $data["dir"]      = $this->isDir();
        return $data;
    }

    public function json() {
        return array("id"=>$this->id,"fullname"=>strtoupper($this->lastname). " " .ucfirst($this->firstname),
                     "context"=>$this->getArrContext(),"garStatus" => $this->garStatus,
                     "profil"=>FORMAT_PROFIL($this->profil));
    }

    public function isVisible() {
        $USER     = USER();

        if ($USER->isAdmin()) {return true;}
    
        
        if ($USER->isGestAcad()) {return true;}

        $uajs     = $this->getUajContext();
        $garAdmin = false;
        foreach($uajs as $uaj) {
            if ($USER->isGarAdminOf($uaj)) {$garAdmin=true;break;}
        }

        if ($garAdmin) return true;
        
        return false;
    }

     public function me() {


        $data=array();
        $data["id"]=$this->id;
        $data["fullname"]=strtoupper($this->lastname). " " .ucfirst($this->firstname);
        $data["context"]=$this->getArrContext();
        $data["admin"]=$this->isAdmin();
        $data["adminlocal"]=$this->isAdminLocal();
        $data["gestacad"]=$this->isGestAcad();
        $data["dir"]=$this->isDir();
        $data["garStatus"] = $this->garStatus;

        if ($this->isAdmin()) {
            $data["gar"] = [
                "api"   => BASE_URL(). "/gar/",
                "publicapi"   => BASE_URL(). "/public/gar/",
                "token" => GAR_USER()->token
            ];
        }


        $data["garAdmin"] = $this->isGarAdmin();
        $contexts=$this->getContext();
        $garAvailable = false; 
        $garActif = false; 

        // GAR Configuré ? 
        // oui => on va récupérer les Etablissements actifs
        if (PARAM("GAR_CODE",false)) {
            foreach ($contexts as $c) {
                if ($c->isGarAvailable()) {$garAvailable = true;}
                if ($c->isActif())        {$garActif     = true;}
            }
        }
        
        $data["garAvailable"]=$garAvailable;
        $data["garActif"]    =$garActif;

        $data["canfetchimage"]=(PARAM("API_SCREENSHOT","")!="");

        $data["droits"]=array("admin"=>$this->isAdmin(),"adminlocal"=>$this->isAdminLocal());

        foreach ($this->getProfils() as $profil) {
            $data["profils"][]= $profil->name;
        }

        foreach ($this->getAttributes() as $key=>$attribute) {
            $data["attributes"][]= array("key"=>$key , "value" => $attribute);
        }

        return $data;

    }

    public function getProfils()    {return PROFILS_USER();}

    public function getAttributes() {return CAS_ATTRIBUTES();}

    public function getContext()    {return USER_CONTEXT(); }

    public function getArrContext() {
        $all=$this->getContext();
        $ret=array();
        foreach ($all as $c)
        {
            $ret[]=$c->json();
        }
        return $ret;
    }

    // Tous les UAJ du context du user
    public function getUajContext() {
        $all=$this->getContext();
        $ret=array();
        foreach ($all as $c){$ret[]=$c->tag;}
        return $ret;
    }

    public function hasContext($context) {
        $all=$this->getContext();
        foreach ($all as $c)
        {
            if ($c->id==$context->id) return true;
        }
        return false;
    }

    public function hasProfil($profilid) {
        return array_key_exists($profilid,$this->getProfils()) ;
    }

    public function matchProfil($profil) {
        $rep=preg_replace('/{([a-z]*)}/i','$this->${1}',$profil->text );
        /*if (strpos($profil->text,"preg_grep") !== false) {
            print_r(CAS_ATTRIBUTES());
            echo "[".$this->email."]\n";
            die($rep);
        }*/
        try {
            return eval(' try { return '.$rep.'; } catch (Exception $ex) { return false;}');
        } catch (Exception $ex) {
            return false;
        }
    }
}




?>
