<?php

// Timestamp actuel
$d=new DateTime();
$_SESSION["timestamp"]=$d->getTimestamp();

function startsWith($haystack, $needle)
{
     $length = strlen($needle);
     return (substr($haystack, 0, $length) === $needle);
}

function getProfil() {
  $user=USER();
  if (!$user) return "";
  return $user->profil;
}

function FORMAT_PROFIL($profil) {
    switch ($profil) {
        case "national_1": return "Eleve";break;
        case "national_2": return "Responsable";break;
        case "national_3": return "Enseignant";break;
        case "national_4": return "Chef Etablissement";break;
        case "national_5": return "Vie Scolaire";break;
        case "national_6": return "Administratif";break;
        case "national_7": return "Inspecteur";break;
        // profil GAR
        case "doc":        return "Documentaliste";break;
        case "ens":        return "Enseignant";break;
        case "dir":        return "Direction";break;
    }

    return $profil;
}

function CONFIG($key,$default=false) {
    global $config;
    if (isset($config[$key])) return $config[$key];
    return $default;
}

function USER() {
    return $_SESSION["user"];
}

function ADMIN() {
    return $_SESSION["admin"];
}

// GAR API USER
function GAR_USER() {
    return $_SESSION["GAR_USER"];
}

// Configuration GAR par défaut
function GAR_DEFAULT() {
    return $_SESSION["gar_default"];
}

function PROFIL_ADMIN() {
    return $_SESSION["profil_admin"];
}

function PROFIL_ACADEMIQUE() {
    return $_SESSION["profil_academique"];
}

function CAS_ATTRIBUTES() {
    return $_SESSION["cas_attributes"];
}

function PROFIL_ALL() {
    return $_SESSION["profil_all"];
}

function PROFILS_USER() {
    if (isset($_SESSION["profils_user"])) return $_SESSION["profils_user"];
    return array();
}

function PROFIL_ADMINLOCAL() {
    return $_SESSION["profil_adminLocal"];
}

function GLOBAL_CONTEXT() {
    return $_SESSION["global_context"];
}

function CATEGORY_NONE() {
    return $_SESSION["category_none"];
}

function USER_CONTEXT() {
    if (isset($_SESSION["user_context"])) return $_SESSION["user_context"];
    return array();
}

function LIBRARIES_CONTEXT() {
    return $_SESSION["libraries_context"];
}

function ANONYMISE($string) {
    if (!$string || strlen($string)<2) {return $string; }
    $string = strtoupper($string);
    return $string[strlen($string)-1] . str_pad("",strlen($string)-2,"x") . $string[0];
}

function file_get_contents_withProxy($url) {
    $opts = array();
    $proxy=PARAM("proxy");
    if ($proxy) {
        $opts['http'] = array( 'proxy' => "tcp://$proxy",'request_fulluri' => true );
        $opts['https'] = array( 'proxy' => "tcp://$proxy",'request_fulluri' => true );
        $info="(proxy=$proxy)";
    }
    $context = stream_context_create($opts);
    try {
        return file_get_contents($url,false,$context);
    } catch (\Exception $e) {
        return $e;
    }
}

function replaceParams($string) {
    $pattern = '/\[(.*?)\]/';
    preg_match_all($pattern, $string, $matches, PREG_OFFSET_CAPTURE);
    foreach($matches[1] as $match) {
        $pat=$match[0];
        $param= R::findOne('parameter', 'name = ?',array($pat));
        if ($param) {
            $string=str_replace("[$pat]",$param->value,$string);
        }
    }
    return $string;
}

function uuid_make($string){
    $string = substr($string, 0, 8 ) .'-'.
    substr($string, 8, 4) .'-'.
    substr($string, 12, 4) .'-'.
    substr($string, 16, 4) ; //.'-';
    //substr($string, 20);
    return $string;
  }

function _GUID(){
    if (function_exists('com_create_guid')){
        return com_create_guid();
    }
    else {
        mt_srand((double)microtime()*10000);//optional for php 4.2.0 and up.
        $charid = strtoupper(md5(uniqid(rand(), true)));
        $hyphen = ""; // chr(45);// "-"
        $uuid = "" 
            .substr($charid, 0, 8).$hyphen
            .substr($charid, 8, 4).$hyphen
            .substr($charid,12, 4).$hyphen
            .substr($charid,16, 4).$hyphen
            .substr($charid,20,12)
            ."";
        return $uuid;
    }
}

function BASE_URL() {
    $currentPath = $_SERVER['PHP_SELF']; 
    $pathInfo = pathinfo($currentPath); 
    $hostName = $_SERVER['HTTP_HOST']; 
    $protocol = "https://";
    return $protocol.$hostName.str_replace("/index.php","",$pathInfo['dirname'])."";
}

// Version des xsd GAR possibles
// TODO: Mettre en conf
function GAR_XSDVESRION() {
    return ["par défaut","1.6.3","1.7.0","1.8.0"];
}

function PARAM($name,$default=false) {
    return Model_Parameter::get($name,$default);
}

function setPARAM($name,$val) {
    Model_Parameter::set($name,$val);
}

function TIMESTAMP() {
    return $_SESSION["timestamp"];
}

$globalContext=R::findOne('context', 'tag = ?',array("GLOBAL"));
if (!$globalContext) {
    $globalContext = R::dispense("context");
    $globalContext->tag="GLOBAL";
    $globalContext->name="Tous les établissements";
    R::store($globalContext);
}
$_SESSION["global_context"]=$globalContext;

function getJsonLastError() {
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            return ' - Aucune erreur';
        break;
        case JSON_ERROR_DEPTH:
            return ' - Profondeur maximale atteinte';
        break;
        case JSON_ERROR_STATE_MISMATCH:
            return ' - Inadéquation des modes ou underflow';
        break;
        case JSON_ERROR_CTRL_CHAR:
            return ' - Erreur lors du contrôle des caractères';
        break;
        case JSON_ERROR_SYNTAX:
            return ' - Erreur de syntaxe: JSON malformé';
        break;
        case JSON_ERROR_UTF8:
            return ' - Caractères UTF-8 malformés, probablement une erreur d\'encodage';
        break;
        default:
            return ' - Erreur inconnue';
        break;
    }
    return "Aucune erreur";
}

function normalizeTag($tag) {
    if ($tag=="local") $tag="xlocal";
    return preg_replace('/[^A-Za-z0-9]/', '', $tag);
}


?>
