<?php
    // Pas de mode strict, sinon erreur levé par Slim
    if(defined('E_STRICT')){
        error_reporting(E_ALL^ E_NOTICE);
    }

    // Configuration
    include_once('config.php');
   
    // Accès à la base de données MySql
    include_once('rb.php');
    R::setup('mysql:host='.$config['dbhost'].';dbname='.$config['dbname'],
        $config['dblogin'],$config['dbpassword']);

    // Optimisation de la base
    // https://redbeanphp.com/manual3_0/index.php?p=/manual3_0/freeze
    // R::freeze( true );

    // Chargement des Models
    include_once('classes.php');

    // Gestionnaire GAR
    include_once('GAR.php');
    
    // Démarre la session
    session_name($config['sessionname']);
    session_start();

    // Fonction utiles
    include_once('fonctions.php');

    // Locale
    setlocale (LC_TIME, PARAM('locale','fr_FR.utf8'),PARAM('lang','fra')); 
    try {
        $timezone=PARAM("timezone","GMT");
        if ($timezone=="") $timezone="GMT";
        date_default_timezone_set($timezone);
    }  catch (Exception $e) {
        // Une erreur est survenue lors de la mise en place du timezone
        // => on fixe à GMT
        date_default_timezone_set("GMT");
    }
        
    // Récupération des éventuels paramètres en PUT
    if($_SERVER['REQUEST_METHOD'] == 'PUT') {
        parse_str(file_get_contents('php://input'), $_PUT);
    }

    $PUBLIC_ACCESS = false;
    if (strpos($_SERVER["SCRIPT_URI"],"/api/public/") === false) {
        // Lib CAS
        if (!isset($_POST["token"]) && !isset($_GET["token"]) && !isset($_PUT["token"] )) {
            include_once('CASauto.php');
        } 
        // Sinon Auth par Token (utile pour API)
        else 
        {
            include_once('TOKENauto.php');   
        }
    } else {
        $PUBLIC_ACCESS = true;
        $USER = R::dispense("user");
        $_SESSION["user"]=$USER;
    }

    
    
    $headers = getallheaders();
    if (isset($headers["Cache-Control"])) {
        if ($headers["Cache-Control"]=="no-cache") {
            unset($_SESSION["user"]);
        }
    }

    // On va charger les éléments de la session, si non éxistante
    if ( !$PUBLIC_ACCESS && ( !isset($_SESSION["user"]) || isset($_GET["reload"]) || $_SERVER["SCRIPT_NAME"]=="/econnect/index.php") ) {
        include_once('session.php');
    }
?>