<?php

/*
fixes #27057 : Désactivation du mode debug
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
*/

// Récupération des attributs
$attributes=$user_datas["details"];

// Est-ce que la clef permettant de retrouver l'utilisateur est présente ?
if (!isset($attributes[$config['cas_uid']]) && 
    !isset($attributes[$config['cas_garidentifiant']]) 
    )
{
    die("Attribut CAS ".$config['cas_uid'] . " ou ". $config['cas_garidentifiant'] ." non retrouvé");
}

$newUser = false;
$USER    = null;

// Recherche par garidentifiant si defini
if (isset($attributes[$config['cas_garidentifiant']])) {
    $id   = $attributes[$config['cas_garidentifiant']][0];
    if ($id) {$USER = R::findOne('user', 'garidentifiant = ?',array($id));}
}

// User non trouvé par garidentifiant
// recherche par uid
if (!$USER) {
    // Récupération de l'utilisateur
    $user=$attributes[$config['cas_uid']][0];
    if (!$user) {
        die("CAS user not found");   
    }

    // On va rechercher l'utilisateur
    
    $USER = R::findOne('user', 'uid = ?',array($user));
    if (!$USER) {
        $USER = R::dispense("user");
        $USER->uid=$user;
        $newUser = true;
        R::store($USER);
    }
}



// Met en paramètre la conf SSO
$attributessso=PARAM("ATTRIBUTSSSO");
if (!$attributes) {
    $attributessso=CONFIG("attributs_sso");
    setPARAM("ATTRIBUTSSSO",$attributessso);  
}

// Construction des attributs CAS pour la gestion des profils
$attrs=explode("\n",$attributessso);
$_SESSION['profil_attributes']=array();
foreach( $attrs as $attr ) {
    if (strpos($attr,"=")!==false) {
        $a=explode("=",$attr);
        $_SESSION['profil_attributes'][]=$a[0];
        // Initialisation du profil de l'utilisateur a false (sauf si uid=admin)
        // Le traitement des attributs CAS, les mettra à jour.
        if ($USER->uid != "admin" ) $USER[$a[0]]=false;
    }
}

// Modification du user avec les infos CAS
$USER->username=$attributes[$config['cas_username']][0];
$USER->lastname=$attributes[$config['cas_lastname']][0];
$USER->firstname=$attributes[$config['cas_firstname']][0];


// Si pas de fullname on va en fabriquer un avec le last et first
if (!isset($attributes[$config['cas_fullname']])) 
{
    $USER->fullname=$USER->firstname . " " . $USER->lastname;
} else {
    $USER->fullname=$attributes[$config['cas_fullname']][0];
}

// Sauvegarde
$_SESSION["user"]=$USER;


// Récupération et/ou création des groupes principaux ------------------------------------------
$admin=R::findOne('user', 'uid = ?',array("admin"));
if (!$admin) {
    $admin = R::dispense("user");
    $admin->uid="admin";
    $admin->fullname="administrateur";
    $admin->profil="admin";
    $admin->admin="global";
    $admin->locked="1";
    R::store($admin);
}
$_SESSION["admin"]=$admin;

// user gar 
$garUser=R::findOne('user', 'uid = ?',array("_gar_api"));
if (!$garUser) {
    $garUser            = R::dispense("user");
    $garUser->uid       = "_gar_api";
    $garUser->fullname  = "GAR API User";
    $garUser->token     = _GUID();
    $garUser->locked    = "1";
    R::store($garUser);
}
$_SESSION["GAR_USER"]=$garUser;


$profil_academique = R::findOne('profil', 'tag = ?',array("ACAD"));
if (!$profil_academique) {
    $profil_academique = R::dispense("profil");
    $profil_academique->tag="ACAD";
    $profil_academique->name="Gestionnaires academiques";
    $profil_academique->text="{uid} == 'admin'";
    $profil_academique->human="A définir";
    $profil_academique->user=ADMIN();
    $profil_academique->autorisations=json_encode(array(array("profil"=>PROFIL_ALL()->id,"right"=>Model_Base::$RIGHT_FORBIDEN)));
    $profil_academique->expression='{"operator":"ET","children",[{"type":"condition","comparator":"égal","field":"uid","value":"admin"}]}';
    $profil_academique->locked="0";
    R::store($profil_academique);
}
$_SESSION["profil_academique"]=$profil_academique;

$profil_all = R::findOne('profil', 'tag = ?',array("TOUS"));
if (!$profil_all) {
    $profil_all = R::dispense("profil");
    $profil_all->tag="TOUS";
    $profil_all->name="Tout le monde";
    $profil_all->text="true";
    $profil_all->human="aucun filtrage";
    $profil_all->user=ADMIN();
    $profil_all->locked="1";
    R::store($profil_all);
}
$_SESSION["profil_all"]=$profil_all;

$profil_admin = R::findOne('profil', 'tag = ?',array("ADMIN"));
if (!$profil_admin) {
    $profil_admin = R::dispense("profil");
    $profil_admin->tag="ADMIN";
    $profil_admin->name="administrateurs";
    $profil_admin->text="{uid} == 'admin'";
    $profil_admin->user=ADMIN();
    $profil_admin->autorisations=json_encode(array(array("profil"=>PROFIL_ALL()->id,"right"=>Model_Base::$RIGHT_FORBIDEN)));
    $profil_admin->expression='{"operator":"ET","children",[{"type":"condition","comparator":"égal","field":"uid","value":"admin"}]}';
    R::store($profil_admin);
}
$_SESSION["profil_admin"]=$profil_admin;

$profil_adminLocal = R::findOne('profil', 'tag = ?',array("ADMINLOCAL"));
if (!$profil_adminLocal) {
    $profil_adminLocal = R::dispense("profil");
    $profil_adminLocal->tag="ADMINLOCAL";
    $profil_adminLocal->name="administrateurs locaux";
    $profil_adminLocal->text="{uid} == 'admin'";
    $profil_adminLocal->user=ADMIN();
    $profil_adminLocal->autorisations=json_encode(array(array("profil"=>PROFIL_ALL()->id,"right"=>Model_Base::$RIGHT_FORBIDEN)));
    $profil_adminLocal->expression='{"operator":"ET","children",[{"type":"condition","comparator":"égal","field":"uid","value":"admin"}]}';
    R::store($profil_adminLocal);
}
$_SESSION["profil_adminLocal"]=$profil_adminLocal;

$none=R::findOne('category', 'tag = ?',array("NONE"));
if (!$none) {
    $none= R::dispense("category");
    $none->tag="NONE";
    $none->name="Non catégorisé";
    $none->user=ADMIN();
    R::store($none);
}
$_SESSION["category_none"]=$none;

//--------------------------------------------------------------------------------


// Paramètre de proxy
$proxy=PARAM("proxy");
if ($proxy) {
    stream_context_set_default(
     array(
      'http' => array(
       'proxy' => "tcp://$proxy",
       'request_fulluri' => true
      ),
     'https' => array(
       'proxy' => "tcp://$proxy",
       'request_fulluri' => true
      )
     )
    );
}

// CAS Attributes
$cas=array();
foreach($attributes as $key => $value)
{
    if (startsWith($key,$config['cas_prefix']))
    {
        $attribute=str_replace($config['cas_prefix'],"",$key);
        if ($attribute=="") continue;
        $val=strtolower(implode("|",$value));
        $cas[$attribute]=$val;
        $USER[$attribute]=$val;
    }  
}


R::store($USER);
$_SESSION["cas_attributes"]=$cas;

// Context -----------------------------------------------------------------------
$context=array();
$contextLibraries=array();
if ($USER->isAdmin()) {
    $context[]=GLOBAL_CONTEXT();
}

$fichier_etabs_ini = "api/utils/etabs.ini";
$ETABS=null;
$rnes=explode("|",strtoupper($USER->rne));
// Si le user est admin et la requete precise des rnes, on va les ajouter
// a la liste des rnes pour le user 
if ($USER->isAdmin() && isset($_GET["rne"])) {
 $all=explode(",",$_GET["rne"]);
 foreach ($all as $a) {
    $rnes[]=strtoupper($a);  
 }
}

// Le rne doit être unique
$rnes=array_unique($rnes);

// -------------------------------------------------------
// Mise à jour des contexts (etablissements) 
// de l'utilisateur
// ref #25164 et I-012443
$listDesContexts = [];
foreach ($USER->sharedContext as $contextForUser)
{
    if ($contextForUser->tag=="GLOBAL") {
        $listDesContexts[] = $contextForUser;
        continue;
    }

    if (in_array($contextForUser->tag,$rnes)) {
        $listDesContexts[] = $contextForUser;
    }
}
$USER->sharedContextList = $listDesContexts;
R::store($USER);
// -----------------------------------------------------

$bAdminGar = false;
foreach ($rnes as $rne )
{
    if ($rne=="") continue;
    
    // Récurépation du context
    $etab=R::findOne('context', 'tag = ?',array($rne));
    if (!$etab) {
        $etab=R::dispense('context');
        $etab->tag=$rne;
        $etab->name=$rne;
    }
      
    if (!$ETABS && file_exists($fichier_etabs_ini)) {
            $ETABS = parse_ini_file($fichier_etabs_ini,true,INI_SCANNER_RAW );
    }
        
    if (!file_exists($fichier_etabs_ini)) $ETABS=array();
        
    if (isset($ETABS[$rne])) {
            $etab->portail=$ETABS[$rne]["portail"];
            $etab->name=$ETABS[$rne]["libelle"];
    } 

    $etab->sharedUserList[] = $USER;
    //$USER->contextList[] = $etab;
    
    R::store($etab);
    $context[$etab->tag]=$etab;
    
    
    $nb=$etab->withCondition(' flag = ?  ', array(Model_Library::$FLAG_CONTEXT) )->countShared('library');

    if ($nb==0) {
        $lib=R::dispense("library");
        $lib->flag=Model_Library::$FLAG_CONTEXT;
        $lib->name=$etab->name;
        // Droits par défaut: Admin local en edittion et les autres en lecture
        $lib->autorisations=json_encode(array(array("profil"=>PROFIL_ADMINLOCAL()->id,"right"=>Model_Base::$RIGHT_WRITE),
                                              array("profil"=>PROFIL_ALL()->id,"right"=>Model_Base::$RIGHT_READ)
                                             ));
        $lib->sharedContext=array($etab);  
        $lib->user=ADMIN();
        // Mise à jour du nom
        $lib->name = strtoupper($etab->name);
        $lib->uaj  = strtoupper($etab->tag);
        R::store($lib);
        
        
    } else {
        $all=$etab->withCondition(' flag = ?  ', array(Model_Library::$FLAG_CONTEXT) )->sharedLibrary;
        // reset: permet de récupérer le premier élément
        $lib=reset($all); 
        $lib->uaj  = strtoupper($etab->tag);
        $lib->name=$etab->name;
        R::store($lib);
    }

    // (Nouveau User ou étab en cours d'intégration voir intégré intégré)  et c'est un Dir ou un Doc ou AdminLocal
    // il est admin GAR par défaut ( DIR ne poura être enlevé/décoché de l'IHM )
    // ref #29961
    if ( ( $newUser || $etab->garStep >= Model_Gar::STEP_REQUESTED  ) && ($USER->isDoc() || $USER->isDir() || $USER->isAdminLocal() ) ) {
        $bAdminGar = true;
        $USER->addGarAdminOf($etab->tag);
    }
    
    $contextLibraries[]=$lib;
    
}

// L'utilisateur doit disposer d'au moins un établissement
if (count($context)==0)
{
    die("Aucun établissement (context) trouvé, contacter l'administrateur");   
}

// C'est un admin GAR => sauvegarde des étabs de gestion GAR
if ($bAdminGar) {
    R::store($USER);
}

// Si title = DOC => force le profil à DOC ( pour le GAR)
if ($USER->title == "doc" && $USER->profil!="doc" ) {
    $USER->profil="doc";
    R::store($USER);
}


$_SESSION["user_context"]=$context;
$_SESSION["libraries_context"]=$contextLibraries;
//---------------------------------------------------------------------------------------

// ===== Gestion de la bibliothèque personnelle (tout le monde en dispose d'une)
$library=R::findOne('library', 'user_id = ? and flag = ? ',array($USER->id,Model_Library::$FLAG_PERSONEL));
if (!$library) {
    $library=R::dispense("library");
    $library->flag=Model_Library::$FLAG_PERSONEL;
    $library->user=$USER;
    $library->name="Mes ressources";
    $library->description="Bibliothèque personnelle, les ressources ne sont visibles que par vous.";
    R::store( $library );  
} else {
    $library->checkRessources();
}
// ===================================================================================

// Création parametre SSO
if (defined('__CAS_SERVER')) {
    $param = R::findOne("parameter", 'name = ?',array("SERVEUR_SSO"));
    if (!$param) {
            $param=R::dispense("parameter");     
            $param->name="SERVEUR_SSO";$param->value=__CAS_SERVER;
            $param->locked="1";
            R::store($param);
    }
}

if (defined('__CAS_PORT')) {
    $param = R::findOne("parameter", 'name = ?',array("PORT_SSO"));
    if (!$param) {
            $param=R::dispense("parameter");     
            $param->name="PORT_SSO";$param->value=__CAS_PORT;
            $param->locked="1";
            R::store($param);
    }
}


// ==== GAR configuration
if (PARAM("GAR_CODE",false)) {
    $gar = R::findOne("gar", 'tag = ?',array("test"));
    if (!$gar) {
        $gar = R::dispense("gar");
        $gar->tag         = "test";
        $gar->description = "Plateforme de test du GAR";
        $gar->wsKey  = PAD_DEFAULT_KEY;
        $gar->wsPem  = PAD_DEFAULT_KEY;

        $gar->depotPrivateKey  = PAD_DEFAULT_KEY;
        $gar->depotPublicKey   = PAD_DEFAULT_KEY;

        $gar->defaut          = 'n';
    }

    $gar->icon        = "fa-flask";
    $gar->name        = $gar->tag;
    $gar->defaut      = 'n' ;
    $gar->wsUrl       = "https://list-ressource.partenaire.test-gar.education.fr";             // Données pour le Webservice
    $gar->affUrl      = "https://affectation.partenaire.test-gar.education.fr";                // Module d'affectation
    $gar->samlRes     = "https://sp-auth.partenaire.test-gar.education.fr/saml/metadata";      // Metadonne pour accès aux ressources
    $gar->samlAff     = "https://affectation.partenaire.test-gar.education.fr/saml/metadata";  // Metadonne pour module affectation
    $gar->depotUrl    = "collecte-ent.partenaire.test-gar.education.fr";                       // Dépot de fichiers
    $gar->locked      = true;

    R::store($gar);


    // GAR PROD
    $gar = R::findOne("gar", 'tag = ?',array("prod"));
    if (!$gar) {
        $gar = R::dispense("gar");
        $gar->tag         = "prod";
        $gar->description = "Plateforme en production du GAR";
        $gar->wsKey  = PAD_DEFAULT_KEY;
        $gar->wsPem  = PAD_DEFAULT_KEY;

        $gar->xsdversion  = "par défaut";
    
        $gar->depotPrivateKey  = PAD_DEFAULT_KEY;
        $gar->depotPublicKey   = PAD_DEFAULT_KEY;
        $gar->defaut           = 'o';
    }
    
    $gar->icon        = "fa-industry";
    $gar->name        = $gar->tag;
    $gar->defaut      = 'o';
    $gar->wsUrl       = "https://list-ressource.gar.education.fr/";             // Données pour le Webservice
    $gar->affUrl      = "https://affectation.gar.education.fr";                 // Module d'affectation
    $gar->samlAff     = "https://affectation.gar.education.fr/saml/metadata";  // Metadonne pour module affectation
    $gar->samlRes     = "https://sp-auth.gar.education.fr/saml/metadata";      // Metadonne pour accès aux ressources
    $gar->depotUrl    = "collecte-ent.gar.education.fr";                       // Dépot de fichiers
    $gar->locked      = true;

    R::store($gar);

    $gar = R::findOne("gar", 'defaut = ?',array("o"));
    if ($gar) {
        $_SESSION["gar_default"]=$gar;
    }

    setPARAM("DEFAULT_GAR_XSD_VERSION","1.8.0");

    // ref #29553 //Ajout lien vers "mentions informatives RGPD "
    // RGPD_LINK
    $param=PARAM("RGPD_LINK","n/a");
    if ($param=="n/a") {
        setPARAM("RGPD_LINK","https://gar.education.fr/mentions-informatives-rgpd/");  
    }
    $param=PARAM("RGPD_TEXT","n/a");
    if ($param=="n/a") {
        setPARAM("RGPD_TEXT","Mentions informatives RGPD");  
    }

    
}

$param=PARAM("DB_VERSION",0);
// #30129 Afficher le code ARK pour chaque ressource du GAR
if (!$param<=0) {
    // unfreeze pour créer dynamiquement les champs dans la base
    R::freeze(false);
    $ressource      = R::dispense("ressource");
    $ressource->tag = "__DB_VERSION__";
    $ressource->idType        = "ARK";
    $ressource->idRessource   = "ark://xxxxxxx-yyyyyy-zzzzzzzzz-012345";
    R::store($ressource);

    $ressource = R::findOne("ressource", 'tag = ?',array("__DB_VERSION__"));
    R::trash($ressource);

    setPARAM("DB_VERSION",1);  

    R::freeze(true);

}



// Calcul des profils
$profils=R::findAll("profil");
$arrProfils[PROFIL_ALL()->id]=PROFIL_ALL();
foreach ($profils as $profil) 
{
    if ($USER->matchProfil($profil)) $arrProfils[$profil->id]=$profil;
}
$_SESSION["profils_user"]=$arrProfils;


   

?>
