<?php


// Ajout ou met a jour un user
$app->post('/admin/user/:id', function ($id) use ($app) {
        
    $app->requireAdmin();

    if (!$id) {
        $app->json("garidentifiant manquant");
        die();
    }
    
    $user=R::findOne('user', 'garidentifiant = ?',array($id));
    if (!$user) {
        $user=R::dispense('user');
        $user->garidentifiant=$id;
    }

    $req = $app->request();

    $uaj= $req->post("uaj");
    if (!$uaj) {
        $app->json("UAJ manquant");
        die();
    }
    
    
    $user->firstname=$req->post("firstname");
    $user->lastname=$req->post("lastname");
    $user->email=$req->post("email");
    $user->civil=$req->post("civilite");
    $user->fullname=$user->lastname . " " . $user->firstname;
    
    $user->rne=$uaj;

    $profil = strtolower($req->post("profil"));
    switch ($profil) {
        case  "doc": 
            $profil = "documentaliste";
            $user->title="doc";
            break;
        case  "ens": 
            $profil = "national_3";
            $user->title="ens";
            break;
        case  "dir": 
            $profil = "national_4";
            $user->title="dir";
            break;
        case  "eleve": 
            $profil = "national_1";
            $user->title=null;
            break;
    }
    $user->profil=$profil;

    // New user addGarAdminOf 
    if (!$user->id && ($user->isDoc() || $user->isDir()) ) {
        $user->addGarAdminOf($uaj);
    }

    // Récurépation du context et affectation du user ===================
    $etab=R::findOne('context', 'tag = ?',array($user->rne));
    if (!$etab) {
        $etab=R::dispense('context');
        $etab->tag=$rne;
        $etab->name=$rne;
    }
    $etab->sharedUserList[] = $user;
    R::store($etab);
    // ===================================================================


    R::store($user);
    
    $app->json($user);

});