<?php

    // Get all contextes
    $app->get('/contextes', function () use ($app) {$app->sendAll("context","ORDER BY tag ASC");});

    $app->get('/contexts', function () use ($app) {
        $elements=R::findAll("context","ORDER BY tag ASC");
        $a=array();
        foreach ($elements as $e) {if ($e->isVisible()) $a[]=$e->json(false);    }
        $app->outputArray($a);   
    });


    $app->get('/context/:id', function ($id) use ($app) {
        $app->requireAdmin();
        $context=$app->mustExistAndVisible("context",$id);

        $gars  = R::findAll('gar',"ORDER BY description ASC");

        $app->render('context-edit.php', array('context' => $context,'gars'=>$gars,'code'=>PARAM("GAR_CODE",false)));
    });


    // Activation ressource
    $app->post('/context/:id/activate', function ($id) use ($app) {
        $context=$app->mustExistAndVisible("context",$id);

        if (! $context->isActivable() ) {
            $app->sendForbiden("Context non activable");
        }

        $val=$app->request()->post("actif");
        $context->actif=($val=="true") || ($val=="1");
        // Pas encore de garStep : On positionne à STEP_REQUESTED ( demande en cours )
        if ($context->actif && (!$context->garStep || $context->garStep != Model_Gar::STEP_REQUESTED )) {
            $context->garStep    = Model_Gar::STEP_REQUESTED;
            $context->garStepMsg = "Activation demandée le " . date("c") ;
        }

        if (!$context->actif) {
            $context->garStep    = Model_Gar::STEP_INACTIF;
            $context->garStepMsg = "Désactivé le " . date("c") . " par " . USER()->fullname;
        }
        R::store($context); 
        
        $app->response->write(json_encode($context->json()));
    });

     // Activation d'un responsable d'affectation d'une ressource
     $app->post('/context/:id/user/:userid/activate', function ($id,$userid) use ($app) {

        // Récupération du contexte
        $context=$app->mustExistAndVisible("context",$id);
        if (! $context->isActif() ) {
            $app->sendForbiden("Etablissement non actif");
        }

        // Récupération du user
        $user = $app->mustExistAndVisible("user",$userid);
        if (! $user->isVisible() ) {
            $app->sendForbiden("Utilisateur hors perimètre");
        }

        $val=$app->request()->post("actif");
        if ($val==="true") {
            $user->addGarAdminOf($context->tag);
        } else {
            $user->removeGarAdminOf($context->tag);
        }

        R::store($user); 
        
        $app->response->write(json_encode($user->isGarAdminOf($context->tag)));
    });


    // Liste des users possiblent en Resp. Affectation GAR d'un contexte
    $app->get('/context/:id/users', function ($id) use ($app) {
        $context=$app->mustExistAndVisible("context",$id);

        if (! $context->isVisible() ) {
            $app->sendForbiden("Context non visible");
        }

        $arr = array();
        foreach($context->sharedUserList as $user )
        {
            if (! $user->isVisible()) {continue;}
            if (! $user->canbeRespAffectation()) {continue;}
            $arr[] = $user->jsonWithContext($context);
        }

        $app->outputArray($arr);
    });

    // Liste des ressources d'un contexte
    $app->get('/context/:id/ressources', function ($id) use ($app) {
        $context=$app->mustExistAndVisible("context",$id);

        if (! $context->isVisible() ) {
            $app->sendForbiden("Context non visible");
        }


        // Ressources du GAR
        $arr = array();
        foreach($context->sharedRessourceList as $ress )
        {
            if (! $ress->isVisible()) {continue;}
            $data = $ress->json(true); // sans les contexts
  
            $access = R::findOne("accessbycontext", 'context_id = ? AND ressource_id = ?',array($context->id,$ress->id));
            if ($access) {
                $data["accessContext"] = $access->nb;
            } else {
                $data["accessContext"] = 0;
            }
            $data["accessTotal"]   = $ress->access;
            $arr[] = $data;
        }

        // Ressources eConnect
        $lib=R::findOne('library','uaj = ?',array($context->tag));
        foreach($lib->ownInstance as $instance) {
            $arr[] = $instance->ressource->json(true); // sans les contexts
        }

        

        $app->outputArray($arr);
    });


    // Modification des informations sur un context
    $app->post('/context/:id', function ($id) use ($app) {
        
        $app->requireAdmin();
        $context = $app->mustExistAndEditable("context",$id);

        $req = $app->request();
        $gar = null;
        if ($req->post("garConfig")) {
            $gar  = R::findOne("gar","id = ?",array($req->post("garConfig")));
        }
        
        $context->name=$req->post("name");
        $context->gar=$gar;
        R::store($context);
        
        $app->json($context);
    
    });


?>