<?php

    function _formatGarInfos($data) {

        if (!isset($data["STATUT"])) {
            $statut =  "<span class='text-muted'>n/a</span>";
        } else {
            $statut =  "<span class='".$data["STATUT"]."'>".$data["STATUT"]."</span>";
        }

        $statut = " [ " . $statut . " ] ";

        $timer = "";
        if (isset($data["TIMER"])) {
            $timer =  "<span class='jaune'>".$data["TIMER"]."</span>";
        }

        return $statut . " " . $timer ;

    }

    // Script installation standalone
    $app->get('/public/aaf2gar', function () use ($app) {
        echo file_get_contents(__DIR__. "/../../../aaf2gar/standalone.sh");
        die();
    });

    // Get GAR Configuration
    $app->get('/gars', function () use ($app) {$app->sendAll("gar","ORDER BY description ASC");});

    // Redirection vers le module d'affectations
    $app->get('/gar/:tag/affectations', function ($tag) use ($app) {
        $gar=$app->getOne("gar",$tag);

        // Consctruction de l'url de fédération
        $url = "https://[SERVEUR_SSO]:[PORT_SSO]/?service=https%3A%2F%2F[SERVEUR_SSO]:[PORT_SSO]%2Fsaml%3Fsp_ident%3D". 
                $gar->samlAffEntityID ."%26RelayState%3D". $gar->affUrl;
        $url = replaceParams($url);

        // Redirection
        $app->response->redirect($url, 303);
    });

    // Comptabilisation des access pour une instance de ressource du gar
    $app->post('/gar/instance/:id/access', function ($id) use ($app) {
        $instance  = $app->mustExistAndVisible("garinstance",$id); 
        $instance->access = intval($instance->access) + 1;

        $ressource = $instance->ressource;
        $ressource->access = intval($ressource->access) + 1;

        $context  = $instance->context;

        // On mémorise le passage d'un accès GAR
        // pour faire le logout GAR uniquement s'il y a eu un accès a des ressources GAR
        $_SESSION["GAR_ACCESS"]  = true ;

        // ref ##28735 
        // Supprimer la partie concernant le décompte d'accès auc ressources
        // Plus nécessaire car stats réalisées par GAR
        /*if ($context) {
            $context->garAccess = intval($context->garAccess) + 1;

            // Comptabilisation par context
            if (!$instance->accessbycontext) {
                $access = R::findOne('accessbycontext', 'context_id = ? AND ressource_id = ?',array($context->id,$ressource->id));
                if (! $access ) {  
                    $access=R::dispense('accessbycontext');
                    $access->nb=0;
                    $access->context=$context;
                    $access->ressource=$ressource;
                }
                $instance->accessbycontext=$access;
            }
        }
        
        $instance->accessbycontext->nb=$instance->accessbycontext->nb+1;
        R::store($instance->accessbycontext);*/


        //R::store($ressource);
        //R::store($instance);

        

        $app->json($instance);


    });

    // closure pour récupérer les uajs actifs
    $garUajs = function($id,$step=Model_Gar::STEP_REQUESTED) use ($app) {
        //$app->requireGar();

        $gar  = $app->mustExistAndVisible("gar",$id);
        $uajs = $gar->getUajs($step);
     
        $app->json($uajs);
    };

    // Etablissements actifs pour le GAR
    $app->get('/gar/:id/uajs(/:step)', $garUajs);
    $app->post('/gar/:id/uajs(/:step)', $garUajs);

    // Route pour définir des paramètres du GAR
    $app->post('/gar/params', function () use ($app) {

        $app->requireAdmin();
        $academie = PARAM("GAR_ACADEMIE",false);
        if ($academie) {
            $app->sendError("Le GAR_ACADEMIE=$academie est déja configuré");
        }

        $code = PARAM("GAR_CODE",false);
        if ($code) {
            $app->sendError("Le GAR_CODE=$code est déja configuré");
        }

        $req      = $app->request();
        $code     = $req->post("code");
        $academie = $req->post("academie");

        if (preg_match('/^[A-Z,0-9]{2}$/',$code, $matches)==0) {
            $app->sendError("GAR_CODE=$code incorect");
        }


        setPARAM("GAR_CODE",$code);
        setPARAM("GAR_ACADEMIE",$academie);

        $app->json(["success"=>true]);


    });

    // Etablissements actifs pour le GAR
    $app->get('/gar/:id', function ($id) use ($app) {

        $app->requireAdmin();

        if ($id==0) {
            $gar = R::dispense("gar");
            $gar->tag         = "identifiant";
            $gar->icon        = "fa-code";
            $gar->description = "Nouvelle configuration du GAR";
            $gar->locked      = false;
        } else {
            $gar=$app->mustExistAndVisible("gar",$id);
        }

        $app->render('gar-edit.php', array('gar' => $gar,'versions'=>GAR_XSDVESRION(),"defaultVersion"=>PARAM("DEFAULT_GAR_XSD_VERSION")));


    });

     // Sauvegarde 
     $app->post('/gar/:id', function ($id) use ($app) {

        $app->requireAdmin();

        $gar = R::findOne('gar', 'id = ?',array($id));
        if (! $gar ) {  $gar=R::dispense('gar');}

        $req = $app->request();
        
        $gar->description=  $req->post("description");
        $gar->xsdversion =  $req->post("xsdversion"); 
        $gar->actif      =  $req->post("actif")=="true"?true:false; 

        if (!$gar->isLocked()) {
            // Si nouveau GAR on renseigne le tag
            if (!$gar->id) {
                $gar->tag  = $req->post("tag");
                $gar->name = $req->post("tag");
            }  
            $gar->wsUrl      =   $req->post("wsUrl");  
            $gar->samlRes    =   $req->post("samlRes"); 
            $gar->samlAff    =   $req->post("samlAff"); 
            $gar->affUrl     =   $req->post("affUrl"); 
            $gar->depotUrl   =   $req->post("depotUrl");  
            $gar->icon       =   $req->post("icon"); 
        }
        
        R::store($gar);         

    });


    // Vérification de l'état d'accrochage du GAR-----------------------------
    $checkGar = function($id) use ($app)  {
        $app->requireGar();

        $gar=$app->mustExistAndVisible("gar",$id);

        $data = $gar->json();

        $brefresh = false;
        $headers = getallheaders();
        if (isset($headers["Cache-Control"])) {
            if ($headers["Cache-Control"]=="no-cache") {
                $brefresh = true;
            }
        }

        // Force l'actualisation
        $data["check"] = [
            "depot"     =>json_decode($gar->checkerDepot($brefresh)),
            "archive"   =>json_decode($gar->checkerArchive($brefresh)),
            "certificat"=>json_decode($gar->checkerCertificat($brefresh)),
            "samlRes"   =>json_decode($gar->checkerSamlRes($brefresh)),
            "samlAff"   =>json_decode($gar->checkerSamlAff($brefresh)),
            "log"       =>$gar->getLastArchiveLog(),
        ];

        R::store($gar);

        $app->json($data);

    };

    // EElement d'accrochage pour le GAR
    $app->get('/gar/accrochage/:id', $checkGar );
    $app->post('/gar/accrochage/:id', $checkGar );
    $app->get('/gar/:id/check', $checkGar );
    // --------------------------------------------------------------------------

    // Responsable d'affectation 
    $respAff = function ($id) use ($app) {
        $app->requireGar();

        $gar  = $app->mustExistAndVisible("gar",$id);
        // fixes #26520 , on ne récupère que les UAJ qui sont déja intégrés
        $uajs = $gar->getUajs(Model_Gar::STEP_INTEGRATED);
        

        // Version grammaire GAR
        $version = $gar->xsdversion;
        if (!$version || $version=="par défaut") {
            $version = PARAM("DEFAULT_GAR_XSD_VERSION");
        }

        // Retour XML
        $xml = new DOMDocument( "1.0", "UTF-8" );
        $respAff = $xml->createElement( "men:GAR-ENT-RespAff" );
        $respAff->setAttribute("xmlns:men","http://data.education.fr/ns/gar");
        $respAff->setAttribute("Version",$version);
        $respAff->setAttribute("xmlns:xsi","http://www.w3.org/2001/XMLSchema-instance");
        $respAff->setAttribute("xsi:schemaLocation","http://data.education.fr/ns/gar GAR-ENT.xsd");

        // Tous les users admin gar
        $users = [];
        $users  = array_merge($users,R::findAll("user","gar_admin_of != 'null' and gar_admin_of != '[]'"));

        $bAnonymous = false; 
        $request = $app->request();
        if ($request->get("anonymat")=="oui") {
            $bAnonymous = true;
        }

        // Formatage json
        $ret = [];
        // fixes #27814 / dédoublonnage des responsables d'affectation
        $mapOfUsers=[];
        foreach($users as $user) {

            // fixes #27814 / dédoublonnage des responsables d'affectation
            if (isset($mapOfUsers[$user->garidentifiant])) {
                continue;     
            }

            // Les dir sont ajouté d'office par le script aaf2Gar
            // Pas la peine de les ajouter ici
            if ($user->isDir())   {continue;}

            // Vérification supplémentaire, un élève ou responsable ne peut être Resp.Aff
            if ($user->isEleve() || $user->isResponsable() ) {continue;}

            // Pas de GARIdentifiant on passe au suivant (ie pas encore connecté)
            if (!$user->garidentifiant) {
                continue;
            }

            $data           = [ "identifiant" =>  $user->garidentifiant ,  
                                "nom"         =>  strtoupper($user->lastname), "prenom" => ucfirst($user->firstname),
                                "civilite"    =>  $user->civil?ucfirst($user->civil):"",
                                "mail"        =>  $user->email 
                              ];

            // Si mode anonyme on transforme suivant algo de AAF2GAR
            if ($bAnonymous) {
                $data ["nom"]    = ANONYMISE($data ["nom"]);
                $data ["prenom"] = ANONYMISE($data ["prenom"]);
                $mailBouts       = explode("@",$data["mail"]);
                if (count($mailBouts)==2) {$data["mail"]="noreply@".$mailBouts[1];}
            }

            // fixes #27814 / map pour dédoublonnage des responsables d'affectation
            $mapOfUsers[$user->garidentifiant]=$user;

            $data["uajs"]   = $user->getGarUajAdminOf();
            $ret[] = $data;  

            $xmlUser = $xml->createElement( "men:GARRespAff" );
            
            $xmlUser->appendChild($xml->createElement( "men:GARPersonIdentifiant", $data["identifiant"]  ));
            $xmlUser->appendChild($xml->createElement( "men:GARPersonNom",         $data["nom"]          ));
            $xmlUser->appendChild($xml->createElement( "men:GARPersonPrenom",      $data["prenom"]       ));
        
            // Code civil
            if ($data["civilite"] && ( $data["civilite"]=="M." || $data["civilite"]=="Mme")  ) {
                $xmlUser->appendChild($xml->createElement( "men:GARPersonCivilite",        $data["civilite"]         ));
            }

            $xmlUser->appendChild($xml->createElement( "men:GARPersonMail",        $data["mail"]         ));

            // uajs du user
            $rneDuUser = $user->getUajs();
            
            // Permet de compter les établissements d'affectation réélement dans le périmètre GAR
            $nbUajDanslePerimetre=0; 
            foreach($data["uajs"] as $uaj) {
                // fixes #26520 , on ne récupère que les UAJ qui sont déja intégrés
                if (!in_array($uaj,$uajs))      {continue;}
                // fixes #30665, en cas de changement d'établissement on supprime la notion de RA sur l'ancien établissement
                if (!in_array($uaj,$rneDuUser)) {
                    continue;
                }

                $xmlUser->appendChild($xml->createElement( "men:GARRespAffEtab", $uaj ));
                $nbUajDanslePerimetre++;
            }
            
            // #26520 et #29604 / ne pas inclure des resp affectations sans UAI
            // NE pas remonter les RespAff qui n'ont plus d'établissement d'affectation dans périmètre GAR
            // Ce cas arrive lorsque 
            // le rne correspondant au positionnement de la responsabilité d'affectation
            // n'est plus dans les affectations actuelles et/ou Etablissement retiré du périmètre GAR
            // => $iUajDanslePerimetre == 0 signifie aucun RNE dans périmètre GAR
            if ($nbUajDanslePerimetre == 0 ) {continue;}


            $respAff->appendChild($xmlUser);

        }

        
        $xml->appendChild( $respAff );

        header( "content-type: application/xml; charset=UTF-8" );
        echo $xml->saveXML();
        die();

        //$app->json($ret);
    };

    // Check si le depot ftp est valide
    $app->get('/public/gar/:id/pem', function ($id) use ($app) {
        $gar=$app->getOne("gar",$id);

        if (!$gar->wsPem || $gar->wsPem == PAD_DEFAULT_KEY) {
            $app->sendNotFound("Aucun log a afficher");
        }

        $filename = $gar->getWsPem();
        header( "content-type: application/x-pem-file");
        header('Content-Disposition: attachment; filename="'. $gar->name . "-ws.pem" .'"');
        echo file_get_contents($filename);
        die();
    });

    $app->get('/gar/:id/respAff',$respAff );
    $app->post('/gar/:id/respAff',$respAff );

    // Check si le depot ftp est valide
    $app->get('/public/gar/:id/csr', function ($id) use ($app) {
        $gar=$app->getOne("gar",$id);

        // ACADEMIE
        $academie = PARAM("GAR_ACADEMIE",false);
        if (!$academie) {
            $app->sendError("GAR_ACADEMIE non renseigné");
        }

        // Génération de la clef privée
        if (!$gar->wsKey || $gar->wsKey == PAD_DEFAULT_KEY) {
            $res = openssl_pkey_new(array(
                "private_key_bits" => 2048,
                "private_key_type" => OPENSSL_KEYTYPE_RSA,
            ));
            openssl_pkey_export($res, $privKey);
            $gar->wsKey= $privKey;
            R::store($gar);
        }

        // Génération du CSR
        if (!$gar->wsCSR) {
            $dn=[
                "countryName"           => "FR",
                "stateOrProvinceName"   => ".",
                "localityName"          => PARAM("GAR_LOCALITY","Saint-Denis"),
                "organizationName"      => ".",
                "organizationalUnitName"=> "GAR " . $academie,
                "commonName"            => $_SERVER['HTTP_HOST'],
                "emailAddress"          => $gar->email?$gar->email:"isr-tests@education.gouv.fr"
            ];
            $csr = openssl_csr_new($dn, $gar->wsKey, array('digest_alg' => 'sha256'));
            openssl_csr_export($csr, $csrout);
            $gar->wsCSR =  $csrout;
            R::store($gar);
        }

        header("Content-Type: text/plain");
        echo $gar->wsCSR;
        die();


    });

    $logFunction = function ($id) use ($app) {
        $app->requireGar();
        $gar=$app->mustExistAndVisible("gar",$id);

        $lastLog = $gar->lastArchiveLog;
        if ( ! $lastLog ) {
            $app->sendNotFound("Aucun log a afficher");
        }

        $lastLog =json_decode($lastLog,true);
        if (!isset($lastLog["content"])) {
            $app->sendNotFound("Aucun contenu a afficher");
        }

        $request = $app->request();
        if ($request->get("format")=="xml") {
            header( "content-type: application/xml; charset=UTF-8" );
            echo (base64_decode($lastLog["content"]));
            die();
        }

        $xml = simplexml_load_string(base64_decode($lastLog["content"]), "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array = json_decode($json,TRUE);
        $array["a"]    = $array;
        $array["name"] = $lastLog["name"];
        $array["gar"]  = $gar;
        $array["url"]  = "https://" .$_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];

        $app->render('log.php',$array );

    };

    $app->get('/gar/:id/log', $logFunction );
    $app->post('/gar/:id/log', $logFunction );

    // PUT d'un fichier d'archive pour le déposer au GAR
    $app->post('/gar/:id/archive', function ($id) use ($app) {
        $app->requireGar();
        $gar=$app->mustExistAndVisible("gar",$id);

        $request = $app->request();
    
        if (!PARAM("GAR_CODE",false)) {
            $app->sendError("La configuration GAR de eConnect semble incorrecte. paramètre GAR_CODE non trouvé");
        }

        // Si GAR inactif, pas de dépot de fichier possible
        if (!$gar->actif) {
            $app->sendError("Le GAR est inactif");
        }

        // Fichier d'archive
        if (!isset($_FILES['archive']) || !isset($_FILES['archive']['tmp_name']) ) {
            $app->sendError("Fichier manquant");
        }

        // Fichier de log
        if (!isset($_FILES['log']) || !isset($_FILES['log']['tmp_name']) ) {
            $app->sendError("Fichier de log manquant");
        }

        // Le md5
        if ( !$request->post("md5") ) {
            $app->sendError("md5 absent");
        }

        $name       =  $_FILES['archive']["name"]; 
        $filename   =  $_FILES['archive']['tmp_name'];
        $md5file    =  tempnam(sys_get_temp_dir(), 'econnect-gar');

        // Fichier de LOG
        $nameLog       =  $_FILES['log']["name"]; 
        $filenameLog   =  $_FILES['log']['tmp_name'];

        // Récupération du CODE de PROJET ENT
        // on s'assure que le fichier se termine par .tar.gz
        preg_match_all(Model_GAR::ARCHIVE_PATTERN,$name,$matches);
        if ($matches[0][0]!=$name) {
            $app->sendError(
                "Impossible de récupérer le idENT dans le nom du fichier\n".
                "Le nom de l'archive doit avoir la syntaxe suivante \n".
                "<idENT>_GAR-ENT_Complet_<AAAAMMJJ_HHMMSS>.tar.gz\n"
            ); 
        }

        // Correspondance du idENT de l'archive et du CODE_GAR du projet
        if ($matches[1][0]!=PARAM("GAR_CODE")) {
            $app->sendError(
                "Le code ". $matches[1][0] . " ne correspond pas au code déclaré dans eConnect (". PARAM("GAR_CODE") . ")\n"
            ); 
        }
        
        // Calcul du MD5 et vérification
        $md5 = md5_file($filename);
        if ($md5 !=  $request->post("md5") ) {
            $app->sendError("Le checksum md5 ne correspond pas ". $md5 . "!=" . $request->post("md5") );
        }

        file_put_contents($md5file,$md5 . "  " . $name);

        // On va essayer de déposer l'archive
        try {
            $gar->deposerFichiers($name, [
                                    ["name"=>$name,"file"=>$filename],                            // Fichier
                                    ["name"=>str_replace(".tar.gz",".md5",$name),"file"=>$md5file] // son md5
                                  ],file_get_contents($filenameLog));
        } catch (\Exception $e) {
            $app->sendError($e->getMessage());
        }

        R::store($gar);

        echo "OK\n";
        unlink($md5file);


    });

    // Post le PEM pour l'accès au WebService des ressources
    $app->post('/gar/accrochage/:id/pem', function ($id) use ($app) {
        $app->requireAdmin();
        $gar=$app->mustExistAndVisible("gar",$id);

        if (!isset($_FILES['file-0']) || !isset($_FILES['file-0']['tmp_name']) ) {
            $app->sendError("Fichier manquant");
        }

        $content =file_get_contents($_FILES['file-0']['tmp_name']);

        // Est-ce bien un certificat ?
        try {
            $x509_res = openssl_x509_read($content);
            if(empty($x509_res)) {
                $app->sendError("Ce fichier n'est pas un certificat");
            }
        } catch(\Exception $e) {
            $app->sendError("Ce fichier ne semble pas être un certificat .PEM <br>" . $e->getMessage());
        }

        // vérification du certificat avec la CSR et la private Key 
        $rsa = new Crypt_RSA();
        $rsa->loadKey($gar->wsKey);
        $pubkey1 = $rsa->getPublicKey();

        $x509 = new File_X509();
        $x509->loadX509($content);
        $pubkey2 = $x509->getPublicKey();

        $csr = new File_X509();
        $csr->loadCSR($gar->wsCSR);
        $pubkey3 = $csr->getPublicKey();

        if (($pubkey1 == $pubkey2) && ($pubkey2 == $pubkey3)) {
            $gar->wsPem = $content;
            $gar->checkerCertificat(true);
            R::store($gar);
            $app->json(["success"=>true]);
        } else {
            $app->sendError("Ce fichier ne correspondant pas au CSR et à la clef privée");
        }


        
    

    });


    // Check si le depot ftp est valide
    $app->get('/gar/:id/depot/check', function ($id) use ($app) {

        $app->requireAdmin();

        if (!PARAM("GAR_CODE",false)) {
            $app->sendError("La configuration GAR de eConnect semble incorrecte. Paramètre GAR_CODE non trouvé");
        }

        $gar=$app->mustExistAndVisible("gar",$id);
        $ssh = new Net_SSH2($gar->depotUrl);
        $key = new Crypt_RSA();
        $key->loadKey($gar->depotPrivateKey);
        try {
            if (!$ssh->login(PARAM("GAR_CODE"), $key)) {
                exit('Login Failed');
            }

            echo $ssh->exec('pwd');
            echo $ssh->exec('ls -la');
            die();
        } catch (\Exception $e) {
            $msg = "Echec de connexion à " . $gar->depotUrl;
            $app->json(["success"=>false,"message"=>$msg]);
        }

    });

    // Retourne la clef publique a communiquer au GAR
    $app->get('/public/gar/:id/publicKey', function ($id) use ($app) {

        $gar=$app->getOne("gar",$id);

        // Clef déja créé ?
        // Non => on va en créer une
        if (!$gar->isDepotKeyValid()) {
            $key = new Crypt_RSA();
            $key->setPublicKeyFormat(CRYPT_RSA_PUBLIC_FORMAT_OPENSSH);
            $key->setComment("econnect-".$gar->tag."-".$_SERVER['HTTP_HOST']."-key");
            $arr = $key->createKey(2048);
            $gar->depotPrivateKey = $arr["privatekey"];
            $gar->depotPublicKey  = $arr["publickey"];
            R::store($gar);
        }
        
        header("Content-Type: text/plain");
        echo $gar->depotPublicKey;
        die();

    });


    // Script d'installation a lancer sur le serveur SSO
    $garSetup = function ($id) use ($app) {

        $app->requireGar();
        $gar=$app->mustExistAndVisible("gar",$id);

        $data = [
            "api"   => BASE_URL(),
            "token" => GAR_USER()->token
        ];

        $app->response->headers->set('Content-Type', 'text/plain');
        $app->render('gar-setup.sh', array('gar' => $gar,"data"=>$data));

    };

    $app->get('/gar/:id/setup/sso', $garSetup);
    $app->post('/gar/:id/setup/sso', $garSetup);



    $app->post('/gar/:id/setup/user_infos.py', function ($id) use ($app) {
        if (!PARAM("GAR_CODE",false)) {
            $app->sendError("La configuration GAR de eConnect semble incorrecte. paramètre GAR_CODE non trouvé");
        }
        $app->render('gar-ecs_z_gar.py', array('code' => PARAM("GAR_CODE")));
    } );

    $app->get('/gar/:id/setup/user_infos.py', function ($id) use ($app) {
        if (!PARAM("GAR_CODE",false)) {
            $app->sendError("La configuration GAR de eConnect semble incorrecte. paramètre GAR_CODE non trouvé");
        }
        $app->render('gar-ecs_z_gar.py', array('code' => PARAM("GAR_CODE")));
    } );

    // ========== AAF2GAR =========================================================

    // Dockerfile
    $AAf2GARDockerfile = function ($id) use ($app) {
        $app->requireGar();
        $gar=$app->mustExistAndVisible("gar",$id);

        $a=explode("/api",$app->request()->getPath());
        $url="https://".$_SERVER['HTTP_HOST'].$a[0];

        $data = [
            "url"     => $url,
            "token"   => GAR_USER()->token,
            "gar"     => $gar
        ];

        $app->response->headers->set('Content-Type', 'text/plain');
        $app->render('aaf2gar-dockerfile', $data);
    };

    $app->get('/gar/:id/setup/aaf2gar-dockerfile',  $AAf2GARDockerfile);
    $app->post('/gar/:id/setup/aaf2gar-dockerfile', $AAf2GARDockerfile);

    // GENERATION DE L'ARCHIVE 
    $AAf2GARScript = function ($id) use ($app) {
        $gar=$app->mustExistAndVisible("gar",$id);

        $archive_name = tempnam("/tmp","aaf2gar").".tar";
        //die($archive_name);
        $dir_path     = __DIR__. "/../../aaf2gar/";

        $archive = new PharData($archive_name);
        $archive->buildFromDirectory($dir_path);

        $a=explode("/api",$app->request()->getPath());
        
        $URL="https://".$_SERVER['HTTP_HOST'].$a[0];
        $CODE=PARAM('GAR_CODE');
        $TOKEN=GAR_USER()->token;

        $PARAMS="#!/bin/bash
WEBSERVICE='{$URL}'
ENT='{$CODE}'
MODE={$gar->name}
TOKEN={$TOKEN}
        ";
        $archive->addFromString('param.sh', $PARAMS);

        $archive->compress(Phar::GZ);
        unlink($archive_name);

        header("Content-Type: application/x-gtar");
        header("Content-Disposition: attachment; filename='"."aaf2gar.tar.gz"."'");
        header("Content-Length: ". filesize($archive_name.".gz" ) );    
        header("Content-Transfer-Encoding: binary");
        echo file_get_contents($archive_name.".gz");

        unlink($archive_name.".gz");
        die();

    };

    $app->get('/gar/:id/setup/aaf2gar.tar.gz', $AAf2GARScript);
    $app->post('/gar/:id/setup/aaf2gar.tar.gz', $AAf2GARScript);

    // Script d'installation
    $AAf2GARSetup = function ($id) use ($app) {
        $app->requireGar();
        $gar=$app->mustExistAndVisible("gar",$id);

        $data = [
            "api"     => BASE_URL(),
            "token"   => GAR_USER()->token,
        ];

        $app->response->headers->set('Content-Type', 'text/plain');
        $app->render('aaf2gar.sh', array('gar' => $gar,"data"=>$data));
    };

    $app->get('/gar/:id/setup/aaf2gar.sh',  $AAf2GARSetup);
    $app->post('/gar/:id/setup/aaf2gar.sh', $AAf2GARSetup);

    // Config
    $AAf2GARConfig = function ($id) use ($app) {
        $app->requireGar();
        $gar=$app->mustExistAndVisible("gar",$id);

        // Version grammaire GAR
        $version = $gar->xsdversion;
        if (!$version || $version=="par défaut") {
            $version = PARAM("DEFAULT_GAR_XSD_VERSION");
        }

        $data = [
            "api"     => BASE_URL(),
            "token"   => GAR_USER()->token,
            "MOTIF"   => "*ENT2D_Complet_*_",
            "ANONYMAT"=> "non",
            "ELVUUID" => uuid_make(md5(PARAM("GAR_CODE")."eleve\n")),
            "ENSUUID" => uuid_make(md5(PARAM("GAR_CODE")."enseignant\n")),
            "VERSION" => $version
        ];

        $app->response->headers->set('Content-Type', 'text/plain');
        $app->render('aaf2gar-config.xml', array('gar' => $gar,"data"=>$data));
    };

    $app->get('/gar/:id/setup/aaf2gar-config.xml',  $AAf2GARConfig);
    $app->post('/gar/:id/setup/aaf2gar-config.xml', $AAf2GARConfig);
        

    





    

    
