<?php

    $app->get('/me',function () use ($app) {
        
        $app->outputArray(USER()->me());

    }); 
    
    // logout appel le logout GAR ( si configuré )  et redirige sur /logout_sso 
    $app->get('/logout',function () use ($app) {

        $gar = false;
        if (isset($_SESSION["GAR_ACCESS"]) && PARAM("GAR_CODE",false)) {
            $gar = true;
        }
        $app->render('logout.php',["url"=>  BASE_URL(), "gar" => $gar , "garadmin" => USER()->isGarAdmin() ]);
    }); 

    $app->get('/logout_sso',function () use ($app) {
        
        EolephpCAS::logout(["service"=>  "https://".PARAM("SERVEUR_SSO").":".PARAM("PORT_SSO")."/logout"  /*str_replace("/api","",BASE_URL())*/ ]);

    }); 

    $app->get('/user/:id',function ($id) use ($app) {
        
        if ($id!=USER()->id) $app->sendForbiden("");
        $app->render('user-show.php');

    }); 

    // List des profils
    $app->get('/profils', function () use ($app) {
        $app->requireAdminLocal();
        $app->sendAll("profil");
    });

    // Supression
    $app->delete('/profil/:id', function ($id) use ($app) {
        $app->requireAdminLocal();
        $profil = $app->mustExistAndDeletable("profil",$id);
        R::trash( $profil );
    });

    // Edit
    $app->get('/profil/:id', function ($id) use ($app) {
        
        $app->requireAdminLocal();

        $profil = R::findOne('profil', 'id = ?',array($id));
        if (! $profil ) { $profil=R::dispense('profil'); }

        $app->render('profil-edit.php', 
                     array('profil' => $profil,
                           'profil_attributes' => json_encode($_SESSION['profil_attributes'])));

    });

    // Edit
    $app->get('/profil/:id/json', function ($id) use ($app) {
        
        global $config;
        $app->requireAdminLocal();

        $profil = R::findOne('profil', 'id = ?',array($id));
        if (!$profil ||  !$profil->isVisible()) {$app->pass(); }

        echo json_encode($profil->json());

    });

    // Sauvegarde 
    $app->post('/profil/:id', function ($id) use ($app) {
        
        $app->requireAdminLocal();

        $profil = R::findOne('profil', 'id = ?',array($id));
        if (! $profil ) {  $profil=R::dispense('profil');}
        
        if (!$profil ||  !$profil->isEditable()) {$app->pass(); }

        $req = $app->request();
        $profil->name=$req->post("name");
        $profil->description=$req->post("description");  
        $profil->expression=$req->post("expression");
        $profil->human=$req->post("human");
        
        $text=strtolower($req->post("text")); 
        $text=str_replace("égal","==",$text); 
        $text=str_replace("différent","!=",$text); 
        
        $profil->text=$text;  

        R::store($profil);         

    });


?>
