<?php

     // Retourne tous les filtres SSO des ressources 
    $app->get('/ressources/sso', function () use ($app) {
       $app->requireAdmin();
       $elements=R::find('ressource'," sso_attr != '' ORDER BY name ASC ");
       $apps=array();

       // Self SSO
       $apps[]=array("name"=>"econnect",
                     "baseurl"=>CONFIG("path"),
                     "scheme"=>"both",
                     "addr"=>"0/0",
                     "typeaddr"=>"ip",
                     "filter"=>PARAM("ATTRIBUTSSSO",CONFIG("attributs_sso")));        
        
       foreach ($elements as $e) {
           if ($e->hasSso() and $e->isActif()) {
               $r=$e->sso();   
               if ($r!=null) $apps[]=$r; 
           }
       }
       $app->outputArray($apps);

    });

   // Gestion des ressources ================================= 

    // Edit 
    $app->get('/ressource/:id', function ($id) use ($app) {

        $ressource = R::findOne('ressource', 'id = ?',array($id));
        if (! $ressource ) { $ressource=R::dispense('ressource'); }

        $app->render('ressource-edit.php', array('ressource' => $ressource));

    });

    // format json 
    $app->get('/ressource/:id/json', function ($id) use ($app) {
        $res = $app->mustExistAndVisible("ressource",$id);
        $app->outputArray($res->json());
    });

    // Edit 
    $app->get('/ressource/fetch/:domaine/image', function ($domaine) use ($app) {
            $req = $app->request();
            $API_KEY=PARAM("API_SCREENSHOT");
            if (!$API_KEY) {$app->pass();return;}
        
            // fixes: #8564, Timeout pour l'api screenshot, par défaut 1000ms
            $API_TIMEOUT=PARAM("API_SCREENSHOT_TIMEOUT",1000);
        
            $SERVICE="http://api.screenshotmachine.com/?key=".$API_KEY."&size=N&format=PNG&timeout=".$API_TIMEOUT."&url=";
            $opts = array();
            $proxy=PARAM("proxy");
            if ($proxy) {
                    $opts['http'] = array( 'proxy' => "tcp://$proxy",'request_fulluri' => true );
                    $opts['https'] = array( 'proxy' => "tcp://$proxy",'request_fulluri' => true );
                    $info="(proxy=$proxy)";
            }
            $context = stream_context_create($opts);
            $content=file_get_contents($SERVICE.$domaine,false,$context);
        
            $app->response->headers->set('Content-Type', 'image/png');
            $app->response->headers->set('Content-Length', strlen($content));
            
            echo $content;
    });

    $app->get('/ressource/fetch/:domaine/meta', function ($domaine) use ($app) {  
            $arr=array();
            $info="";
            try {
                $opts = array();
                $proxy=PARAM("proxy");
                if ($proxy) {
                    $opts['http'] = array( 'proxy' => "tcp://$proxy",'request_fulluri' => true );
                    $opts['https'] = array( 'proxy' => "tcp://$proxy",'request_fulluri' => true );
                    $info="(proxy=$proxy)";
                }
                $context = stream_context_create($opts);
                $content=file_get_contents("http://".$domaine,false,$context);
            } catch (Exception $e) {
                $arr["title"]="Impossible de récupérer les informations $info";
                $arr["description"]=$e->getMessage();
                $app->outputArray($arr);
                return;
            }
             
    
                $doc = new DOMDocument();
                @$doc->loadHTML($content);
                $nodes = $doc->getElementsByTagName('title');

                //get and display what you need:
                $title = $nodes->item(0)->nodeValue;

                $metas = $doc->getElementsByTagName('meta');

                for ($i = 0; $i < $metas->length; $i++)
                {
                    $meta = $metas->item($i);
                    if($meta->getAttribute('name') == 'description')
                        $arr["description"] = $meta->getAttribute('content');
                    if($meta->getAttribute('name') == 'keywords')
                        $arr["keywords"] = $meta->getAttribute('content');
                }
            
         
              $arr["title"]=$title;
             /* $arr["keywords"]=$keywords;
              $arr["description"]=$description;*/
              $app->outputArray($arr);
   
    });



    // logo 
    $app->get('/ressource/logo/:id/:timestamp', function ($id,$timestamp) use ($app) {

        $ressource = R::findOne('ressource', 'id = ?',array($id));
        if (! $ressource || ! $ressource->isVisible() ) { $ressource=R::dispense("ressource");$ressource->logo="NO"; }
        
        $data="";
        $app->response->headers->set('Content-Type', 'image/png');
        if (strpos($ressource->logo,"data:image")!==false)
        {
            $str="data:image/png;base64,"; 
            $data=str_replace($str,"",$ressource->logo); 
            $data = base64_decode($data);
        }elseif  (strpos($ressource->logo,"http")!==false)
        {
           
        } elseif ($ressource->logo && file_exists(Model_Ressource::$LOGO_PATH.$ressource->logo))
        {
            $data=file_get_contents(Model_Ressource::$LOGO_PATH.$ressource->logo  ); 
        } else
        {
            
            $data=file_get_contents(Model_Ressource::$LOGO_PATH."default.png"  ); 
        }
        
        header('Cache-control: max-age='.(60*60*24*2));
        header('Expires: '.gmdate(DATE_RFC1123,time()+60*60*24*2));
        header("Pragma: cache");
        header("Content-Length: " . strlen($data));
        echo $data;
        

    });


    // Instantiate edit
    $app->get('/ressource/instantiate/:id', function ($id) use ($app) {

        $ressource = R::findOne('ressource', 'id = ?',array($id));
        if (! $ressource || ! $ressource->isVisible() ) { $app->pass(); }


        $app->render('ressource-instantiate.php', array('ressource' => $ressource));

    });

    // Instantiate save -> creation d'une instance
    $app->post('/ressource/instantiate/:id', function ($id) use ($app) {

        $req = $app->request();
        
        $ressource = R::findOne('ressource', 'id = ?',array($id));
        if (! $ressource || ! $ressource->isVisible() )     
        {  $app->sendError("Ressource #${id} introuvable où droit insuffisant"); }
        
        $library_id=$req->post("library"); 
        $library = R::findOne('library', 'id = ?',array($library_id)); 
        $instance=$ressource->instantiate($library,$app);
        if ($instance==null) {
            $app->sendError("Cette Ressource existe déja dans ".$library->name);
        }
        
        $app->json($instance);

    });

    // Supression ressource
    $app->delete('/ressource/:id', function ($id) use ($app) {
        $ressource=$app->mustExistAndDeletable("ressource",$id);
        R::trash( $ressource );
    });

    $app->post('/ressources/import', function () use ($app) {
       if(isset($_FILES)){
            $content=file_get_contents($_FILES['file']['tmp_name']); 
            $datas=json_decode($content);
            if (!$datas) {
                $app->sendError("Format de données incorrect"); 
            }
            Model_Ressource::import($datas,$app);
        }
    });

    // Activation ressource
    $app->post('/ressource/:id/activate', function ($id) use ($app) {
        $ressource=$app->mustExistAndVisible("ressource",$id);
        $val=$app->request()->post("actif");
        $ressource->actif=($val=="true") || ($val=="1");
        R::store($ressource); 
        
        $app->response->write($ressource->actif);
    });


    // Sauvegarde ressource
    $app->post('/ressource/:id', function ($id) use ($app) {

        $req = $app->request();

        // Recupère la ressource
        $ressource = R::findOne('ressource', 'id = ?',array($id));
        if (! $ressource ) { $ressource=R::dispense('ressource'); $ressource->user=USER(); $ressource->actif=true; }
        
        if ( ! $ressource->isWritable() )
        { $app->sendError("droit insuffisant"); } 
        
        // Est-ce qu'une lib a été passé en parametre ?
        $library=null;
        $catalogue=null;
        if ($req->post("library") ) {
            $library = R::findOne('library', 'id = ?',array($req->post("library")));   
        }
        
        $catalogue = R::findOne('catalogue', 'id = ?',array($req->post("catalogue")));
        
        // Pas de lib, un catalogue en écriture est exigé
        if (!$library) {
            if (! $catalogue || ! $catalogue->isWritable()  ) 
            { $app->sendError("catalogue introuvable ou droit insuffisant"); return; }
        }
        
        // Est-ce que cette ressource dépenb d'une autre ressource ?
        $ressourceDep=null;
        if ($req->post("ressource") ) {
            $ressourceDep = R::findOne('ressource', 'id = ?',array($req->post("ressource"))); 
            if (! $ressourceDep || ! $ressourceDep->isVisible()  ) 
            { $app->sendError("ressource dépendante introuvable"); return; }
        }
        
        // Mise en place du filtre SSO
        if ($req->post("sso_attr") ) {
            $ressource->sso_attr=$req->post("sso_attr");        
        } else
        {
            $ressource->sso_attr=" "; 
        }
        
        
        
        // Modification des paramètres
        $ressource->name=$req->post("name");
        $ressource->description=$req->post("description");   
        $ressource->url=$req->post("url"); 
        $ressource->urlaccess=$req->post("urlaccess"); 
        $ressource->logo=$req->post("logo"); 
        
        if ($ressourceDep) $ressource->ressource=$ressourceDep;
        
        if ($req->post("category") ) {
            $category=$app->mustExistAndVisible("category",$req->post("category"));
            $ressource->category=$category;
        }
        
        
        if ($catalogue && $catalogue->isWritable()) { 
            $ressource->catalogue=$catalogue;
            $catalogue->ownRessourceList[]=$ressource;
        }
        
        R::store($ressource); 
        if ($catalogue) R::store($catalogue);   
        
        $arr=array();
        // Si une lib est passé en paramètre, on va instantier
        if ($library)  {
           $instance=$ressource->instantiate($library,$app);  
           if ($instance) $arr[]=$instance->json();
        } else
        {
           $arr[]=$ressource->json();  
        }

        $app->outputArray($arr);
        

    });

?>
