#!/bin/bash
# Script d'installation du KIt de transformation de 
# AAF en fichier GAR

TOKEN="<?= $data["token"]?>"
URL_API="<?= $data["api"] . "" ?>"

DOSSIER="aaf2gar-<?= $gar->name ?>"
LOG="/tmp/aaf2gar-setup.log"

[ -e $LOG ] && rm -rf $LOG

[ -d $DOSSIER ] && echo "le dossier $DOSSIER existe " && exit 1

mkdir $DOSSIER
cd $DOSSIER

die(){
    echo "$1, consulter $LOG" && exit 1
}


# Vérification de la précense des applications xmlstarlet, java
xmlstarlet --version >$LOG 2>&1
[ $? -ne 0 ] && die "verifier que xmlstarlet est installé"

java  -version >$LOG 2>&1
[ $? -ne 0 ] && die "verifier que java (default-jre)  est installé"

[ ! -e /usr/share/java/saxonb.jar ] && "vérifier que libsaxonb-java est installé" && exit 1

# XSL + Script 
wget --header="Content-Type: application/x-www-form-urlencoded" --post-data "token=$TOKEN"  $URL_API/aaf2gar.tar.gz  -O /tmp/aaf2gar.tar.gz -o $LOG
tar -zxvf /tmp/aaf2gar.tar.gz >$LOG  2>&1
[ $? -ne 0 ] && die "Erreur lors de l'extraction de l'archive"

chmod u+x aaf2gar.sh
chmod u+x param.sh

# Config 
wget --header="Content-Type: application/x-www-form-urlencoded" --post-data "token=$TOKEN"  $URL_API/aaf2gar-config.xml  -O config.xml  -o $LOG
[ $? -ne 0 ] && die "Erreur lors de la récupération de la config"

# Params


