# -*- coding: utf-8 -*-

use_cache = True
import md5
import uuid

import sys
sys.path.append("..")

GAR_CODE_PROJET = "<?= $code ?>"

# Récupération du title
def getTitle(user_infos):
    title=user_infos.get("title")
    if title != None  and title != ['']:
        return title[0].strip().upper()
    return None


# Determination des prefix GAR
def _garGenPrefix(profil):
    digest = md5.new("%s%s\n" %  (GAR_CODE_PROJET,profil)).hexdigest()
    data  = str(uuid.UUID(digest)).split("-")
    return '-'.join(data[:-1])

GAR_PREFIX_ENS   = _garGenPrefix("enseignant")
GAR_PREFIX_ELEVE = _garGenPrefix("eleve")

def calc_info(user_infos):
    RET={}
    RET["ecs_gar_project_code"] = [GAR_CODE_PROJET] 
    RET["ecs_gar_identifiant"]  = []

    # Pour la preprod, vérification de la source d'authentification
    #isDemoSourceAuth = user_infos.get('COMPTES_DEMO',False)
    #if not isDemoSourceAuth:
    #    return  RET

    title = getTitle(user_infos)
    if title == "DOC":
        RET["ecs_profil"]  = "documentaliste"

    # Récupération du profil pour calcul ecs_gar_identifiant
    profils = user_infos.get('ecs_profil', [])

    # intid : Correspond a la valeur de ENTPersonJointure
    intid   = user_infos.get('intid', [''])[0]
    # Cas d'un SSO central => check RUNENTPersonJointure ( attribut SSO livré avec EoleSSO)
    if not intid:
        intid   = user_infos.get('RUNENTPersonJointure', [''])[0]
    if not intid:
        intid   = user_infos.get('FederationKey', [''])[0]

    # Enseignant par défaut
    PREFIX = GAR_PREFIX_ENS

    # Eleves
    if ("National_1" in profils ):
        PREFIX = GAR_PREFIX_ELEVE


    RET["ecs_gar_project_code"] = [GAR_CODE_PROJET]  
    RET["ecs_gar_identifiant"]  = ["%s-%s" %  (PREFIX,intid.rjust(12, '0'))]

    return RET
