#!/bin/bash

SSO="/usr/share/sso"
TEMP="/tmp/sso-gar"

[ -d $TEMP ] && rm -rf $TEMP
mkdir $TEMP

# Positionnement du proxy 
type CreoleGet > /dev/null 2>&1
if [ $? -eq 0 ]; then
    RunCmd=CreoleRun
    proxy_client_adresse=$(CreoleGet proxy_client_adresse "") 
    proxy_client_port=$(CreoleGet proxy_client_port "") 
    [ ! -z "$proxy_client_adresse" -a ! -z "$proxy_client_port" ] && export https_proxy="$proxy_client_adresse:$proxy_client_port"
fi

# Création dossiers temp ==
[ ! -d $TEMP/metadata ]     && mkdir $TEMP/metadata
[ ! -d $TEMP/app_filters ]  && mkdir $TEMP/app_filters
[ ! -d $TEMP/user_infos ]   && mkdir $TEMP/user_infos

# ========== Récupération des Metadata ==================================

echo -n " Récupération de la metadata d'accès aux ressources : "
TMP="/tmp/econnect-gar-res-<?= $gar->tag ?>.xml";
wget <?= $gar->samlRes ?> -O $TMP -o /dev/null
[ $? -ne 0 ] && echo "Impossible de récupérer la ressource <?= $gar->samlRes ?>" && exit 4

cp $TMP $TEMP/metadata

echo " OK";

echo -n " Récupération de la metadata d'accès au module d'affectation : "
TMP="/tmp/econnect-gar-aff-<?= $gar->tag ?>.xml";
wget <?= $gar->samlAff ?> -O $TMP -o /dev/null
[ $? -ne 0 ] && echo "Impossible de récupérer la ressource <?= $gar->samlAff ?>" && exit 4

cp $TMP $TEMP/metadata

echo " OK";

# Filtres econnect_gar =========================================
echo "
[default]
idEnt=ecs_gar_project_code
GARPersonIdentifiant=ecs_gar_identifiant
" > $TEMP/app_filters/econnect_gar-<?= $gar->tag ?>.ini


echo "
[gar-<?= $gar->tag ?>]
baseurl=/saml/SSO
scheme=both
addr=^<?= $gar->samlResHost() ?>$
typeaddr=regex
filter=econnect_gar-<?= $gar->tag ?>



[gar-affectation-<?= $gar->tag ?>]
baseurl=/saml/SSO
scheme=both
addr=^<?= $gar->samlAffHost() ?>$
typeaddr=regex
filter=econnect_gar-<?= $gar->tag ?>

[gar-portail-<?= $gar->tag ?>]
baseurl=/login
scheme=both
addr=^<?= $gar->samlPortailHost() ?>$
typeaddr=regex
filter=econnect_gar-<?= $gar->tag ?>
" > $TEMP/app_filters/econnect_gar-<?= $gar->tag ?>_apps.ini
# ====================================================================


echo -n " Récupération de l'attribut calculé <?= $data["api"] . "/user_infos.py" ?> : "
curl -skF token=<?= $data["token"]?> <?= $data["api"] . "/user_infos.py" ?> > $TEMP/user_infos/ecs_z_gar.py
[ $? -ne 0 ] && echo "Erreur" && exit 2

echo " OK"

# Vérif existance SSO
if [ ! -d $SSO ] ; then 
   echo ""
   echo "EoleSSO n'est pas installé sur ce serveur"
   echo "Le dossier a copier sur SSO est dans $TEMP"
   exit 3
fi

cp -a $TEMP/* $SSO
/etc/init.d/eole-sso reload
