var Categories = CItem.extend({
    initialize : function(data) { 
        this.api_tag="";
        this.api_elementsTag="categories";
        this.class_element="Category";
        this.getElements(); // Récupération des categories
    }
});

var AllInstances = CItem.extend({
    initialize : function(data) { 
        this.api_tag="";
        this.api_elementsTag="";
        this.class_element="";
    }
});

var Category = CItem.extend({
    initialize : function(data) { 
        var self=this;
        this.api_tag="category";
        
        this.toogle=function(data,event) {
            event.stopPropagation();
            this.isChecked(! this.isChecked());
            this.isFiltered(! this.isFiltered());
            this.filterAll(this.isFiltered());
            appViewModel.showRessources("ressources3-template");
        }
        
        this.check=function(val) {
            this.isChecked(val);
            this.isFiltered(val);
            this.filterAll(val);
        }
        
        this.xToogle=function(data,event) {
            
            event.stopPropagation();
            
            var elts=this.parent.elements;
            for ( e in elts ) {
                elts[e].isFiltered(false);
                elts[e].isChecked(false);
                elts[e].filterAll(false);
            }
            this.isFiltered(true);
            this.isChecked(true);
            this.filterAll(true);
            appViewModel.showRessources("ressources3-template");
        }
        
        this.color=this.data.color || '#'+Math.floor(Math.random()*16777215).toString(16);
        
        this.isChecked(/*this.data.checked*/true);
    }
});


// ===== Catalogues =========================================
var Catalogues = CItem.extend({
    initialize : function(data) { 
        this.api_tag="";
        this.api_elementsTag="catalogues";
        this.class_element="Catalogue";
        this.menu="catalogue";
        this.getElements(); // Récupération des catalogues
        this.hash="catalogues"
        
        this.libelleCreate("un catalogue");
        this.libelleListe("Liste des catalogues");
        
        this.isWritable = function() { return appViewModel.user.canCreateCatalogue();}
    }
});

Catalogues.prototype.check=function(value) {}
Catalogues.prototype.toogle=function(value) {}

// Récupération de toutes les ressources sélectionnées de tous les catalogues
Catalogues.prototype.getSelectedRessources = function($target) {
    var elts=this.getElements();
    var arr=[]
    for (var e in elts){
        var elt=elts[e]
        arr=arr.concat(elt.getSelectedElementsId());
    }
    return arr
}

Catalogues.prototype.getRessources = function($target) {
    var elts=this.getElements();
    var arr=[]
    for (var e in elts){
        var elt=elts[e]
        var children=elt.getElements(true);
        for (var z in children)
            arr.push(children[z])
    }
    return arr
}

// On enlève la selection sur tous 
Catalogues.prototype.unSelectRessources = function($target) {
    var elts=this.getElements();
    var arr=[]
    for (var e in elts){elts[e].uncheckAll();}
    return arr
}

Catalogues.prototype.fillSelect = function($target) {
    var elts=this.getElements();
    var i=0
    for (var e in elts){
        var catalogue=elts[e]
        var $option=$("<option>").attr("value",catalogue.id)
                                 .append(catalogue.data.name);
        if (i==0) $option.attr("selected","selected");
        $target.append($option);
        i=i+1;
    }
    
}


// ===== Catalogue =========================================
var Catalogue = CItem.extend({
    initialize : function(data) { 
        var self=this;
        this.api_tag="catalogue";
        this.api_elementsTag="ressources";
        this.class_element="Ressource";
        this.menu="catalogue";
        if (this.data) this.data.action="ressources"
        
        
        this.template="catalogue-elements-template"
        //this.template="t2"
        
        this.libelleCreate("une ressource");
        this.libelleListe("Ressources pour le catalogue "); 
    }
});


Catalogue.prototype.add = function() {
    ressource=new Ressource();
    ressource.data.writable=true;
    ressource.data.deletable=true;
    ressource.data.editable=true;
    ressource.setCatalogue(this.id);
    ressource.edit();
};

// ==========================================================
