// definiting the base constructor for all classes, which will execute the final class prototype's initialize method if exists
var CItem = function(data) {
    var self=this;
    // Initialisation de data
    this.data=data;
    if (!this.data) this.data={}
    if (!this.data.id) this.data.id=0;
    
    self.locked=JSON.parse( (self.data.locked!=undefined)?self.data.locked:false )
    
    self.id=this.data.id;
    self.nom=ko.observable(this.data.nom);
    this.data.description = this.data.description || ""
    this.data.description=this.data.description.replace(/\n/g,"<br />");
    self.description=ko.observable(this.data.description);
    self.total=ko.computed(function() {return (self.data.recordsTotal?self.data.recordsTotal:0)})
    self.isBig=ko.computed(function() {return self.total() > 100;})
    self.filter=undefined;
    
    self.timestamp=parseInt(this.data.timestamp)*1000;
    
    // Recent < 1day
    self.recent=new Date().getTime()-self.timestamp < 24*60*60*1000
    
    self.libelleCreate=ko.observable("??");
    self.libelleListe=ko.observable("!!!");
    self.canRefresh=ko.observable(true);
    
    self.isChecked=ko.observable(false);
    self.allSelected=ko.observable(false);
    self.hasChecked=ko.observable(false);
    
    self.menu="";
    
    
    // Evalutes to a positive value, so initially we apply the "profitPositive" class
    self.cssStatus = ko.computed(function() {
        return self.isChecked()  ? "checked" : "unchecked";
    },self);

    // Récupération des autorisations
    this.arrAutorisations=ko.observableArray([]);
    if (data && data.autorisations) 
    {
            var parsed=JSON.parse(data.autorisations);
            for (var i=0;i<parsed.length;i++)
            {
                var right=new Right(parsed[i],self)
                this.arrAutorisations.push(right);
            }
    }
    
    // Suppression d'u droit
    this.deleteRight=function(e) {
        self.arrAutorisations.remove(e)
    }
    
    // Ajout d'un droit
    this.addRight=function() {
        var right=new Right(undefined,self);
        right.editing(true); // Editer par défaut
        self.arrAutorisations.push(right);
    }
    
    this.hasAutorisation=function() {self.arrAutorisations().length!=0}
    this.noAutorisation=function() {self.arrAutorisations().length==0}
    //-----------------
    
    
    this.user = ko.computed(function ()              {
        return (self.data&&self.data.user)?data.user.fullname:"n/a" 
    })
    
    self.displayContext= ko.computed(function() {
        if (!self.data.context || self.data.context.length==0) return "n/a";
        var a=self.data.context[0].name;   
        if (self.data.context.length>1) a=a+"...";
        return a;
    })   
    
    self.displayName=function() {
            var n = self.data.name.toLowerCase().split(" ");
            var ret=[]
            var c=0;
            for (var i=n.length-1;i>=0;i--)
            {
                if ((c+n[i].length)>20) {
                    if (ret.length==0) ret.push(n[i])
                    break;
                }
                    
                c=c+n[i].length;
                ret.push(n[i])
            }
            return ret.reverse().join(" ");
    }
    
    // Template d'affichage
    this.template="simple-elements-template"
    
    this.name=ko.observable(this.data.name || "");
    
    // List des elements
    this.elements=undefined;
    this.children=ko.observableArray([]);
    this.filteredChildren = this.children.filterByProperty("isFiltered", true);
    this.isFiltered=ko.observable(true);
    this.count=ko.computed(function() { return self.children().length;})
    
    // Initialisation
    this.initialize && this.initialize.apply(this, this.data);
    
    this.tableHeaders=undefined;
    this.chosenContext = ko.observableArray([]) 
    if (self.data.context) {
        for (var i=0;i<self.data.context.length;i++) this.chosenContext.push(data.context[i].id);
    }
    
};

// Definition de la méthode d'héritage
CItem.extend = function(childPrototype) { // defining a static method 'extend'
    var parent = this;
    var child = function() { // the child constructor is a call to its parent's
        return parent.apply(this, arguments);
    };
    child.extend = parent.extend; // adding the extend method to the child class
    var Surrogate = function() {}; // surrogate "trick" as seen previously
    Surrogate.prototype = parent.prototype;
    child.prototype = new Surrogate;
    for(var key in childPrototype){
        child.prototype[key] = childPrototype[key];
    }
    return child; // returning the child class
};

//CItem.prototype.id = function()                     {return this.data?this.data.id:0 }

CItem.prototype.clear = function()                  
{ 
    for (e in this.elements)
    {
        var elt=this.elements[e];
        if (elt.category) elt.category.removeElement(elt.id)
    }
    delete this.elements;
    this.children.removeAll(); 

}


CItem.prototype.urlOfElements = function()  {
    if (this.api_tag) return "api/"+this.api_tag+"/"+this.api_elementsTag+"/"+this.id
    else return "api/"+this.api_elementsTag
}

// A surcharger
CItem.prototype.actionChecked = function() {}

// =============================================================
// Gestion de la selection des éléments 
CItem.prototype.toogle=function(data,event) {
    var b=this.isChecked();
    this.isChecked(! b);
    if (this.parent) this.parent.countChecked(  )
}

CItem.prototype.check=function(value) {
    this.isChecked(value);
    if (this.parent) this.parent.countChecked(  )
}

CItem.prototype.toogleAll = function(data,event) 
{
    if (event) event.stopPropagation();
    var b=this.allSelected();
    this.allSelected(!b)
    for (e in this.elements)
    {
       var el=this.elements[e];
       // Si élement non visible, on passe au suivant
       if ($(".datatable tr[data-id='"+el.id+"']").length==0) continue 
       el.check(!b);
    }
}

CItem.prototype.countChecked = function() 
{
    var z=false
    for (e in this.elements)
    {
       var el=this.elements[e];
       if (el.isChecked()) { z=true; break;}
    }
    this.hasChecked(z)
}

CItem.prototype.uncheckAll = function(data,event) 
{
    if (event) event.stopPropagation();
    for (e in this.elements)this.elements[e].check(false);
}

CItem.prototype.filterAll = function(val) 
{
    for (e in this.elements)this.elements[e].isFiltered(val);
}

CItem.prototype.checkAll = function(data,event) 
{
    if (event) event.stopPropagation();
    for (e in this.elements)
    {
       var el=this.elements[e];
       el.check(true);
    }
}
// =============================================================



CItem.prototype._show = function() {
    
}


CItem.prototype.sortItem = function()                    { return this.data.name || ""}
CItem.prototype.owner = function()                       { return this.data.user.fullname}
CItem.prototype.isOwner = function()                     { return  this.data.user && this.data.user.id==appViewModel.user.id;}
CItem.prototype.isWritable = function()                  { return this.data.writable}
CItem.prototype.isDeletable = function()                 { return this.data.deletable &&  ! this.locked;}
CItem.prototype.isEditable = function()                  { return this.data.editable  &&  ! this.locked;}
CItem.prototype.canCreateElements = function()           { return true;}

CItem.prototype.setTableHeaders= function(headers)    {this.tableHeaders=headers;}

CItem.prototype.createElement = function (data ) { el=eval("new "+this.class_element+"(data)"); el.parent=this; return el}
CItem.prototype.getElement    = function (id)    { return (this.elements?this.elements[id]:null) }
CItem.prototype.removeElement = function (id)    { 
    if (!this.elements) return;
    var el=this.elements[id];
    delete this.elements[id];
    this.children.remove(el) 
}
CItem.prototype.addElement = function (element)    
{ 
  if (this.elements && this.elements[element.id]) {
      /*var e=this.elements[element.id];
      this.children.remove(e);*/
      return;
  }
  if (!this.elements) this.elements={}
  var ePrev=this.elements[element.id]
  this.elements[element.id]=element;
  this.children.push(element);
  element.parent=this;
    
  // Gestion de la categorie, si necesaire 
  /*if (ePrev && ePrev.category && element.category) {
        ePrev.category.removeElement(ePrev);
        element.category.addElement(element);
  }*/
}

// récupération des éléments (children)
CItem.prototype.getElements   = function (bOnlyLatest) {
    var self=this;
    
    // Pas encore de ressources, on va les charger en mode synchrone
    // Si on ne demande pas uniquement les dernières ressources
    // et que le chargements est partiel, on récupère toutes les ressources
    if ( ! self.elements || (self.partial && ! bOnlyLatest) )
    {
        self.elements={}
        self.children.removeAll()

            $.ajax({url: self.urlOfElements(),dataTye:"json",async:false,data:{latest:bOnlyLatest,filter:self.filter}}).done(function (data) {
                if (data.constructor == String) {
                    console.error("ERREUR: "+self.urlOfElements()+" a retourner une valeur erronée");
                    return;   
                }
                var elements=data;var total=0
                if (data.data) {elements=data.data;total=data.recordsTotal} 
                for (var i=0;i<elements.length;i++) {
                    element=self.createElement(elements[i])
                    self.addElement(element)
                }
                self.partial=total && elements.length<total;
            })
            self.children.sort(function(left, right) 
                        { return left.sortItem().localeCompare(right.sortItem()) }
            )

    }
    return this.elements;
}

CItem.prototype.initAndEdit = function() {
    this.data.writable=true;
    this.data.deletable=true;
    this.data.editable=true;
    this.edit();
}

// Ajout d'un élément
CItem.prototype.add = function() {
    element=this.createElement({})
    element.data.writable=true;
    element.data.deletable=true;
    element.data.editable=true;
    element.edit();
};

// Affichage des elements sous forme de tableau
CItem.prototype.show = function() {
    if (!this.class_element) return;
    
    var self=this;
    $('html, body').animate({scrollTop:0}, 'fast',function(){appViewModel.show(self)});
    
}

CItem.prototype._show = function() {

    var self=this;
    

    $(".row.content").empty();
    $(".row.content").attr("id","kkk");
    $(".row.content").html('<div class="table-responsive" data-bind="template: { name: \''+self.template+'\' }"></div>')
    
    $(".row.content").block({ css: { 
            padding: '15px',
            marginTop: '10px',
            backgroundColor: '#000',
            border: '2px solid white',
            '-webkit-border-radius': '10px', 
            '-moz-border-radius': '10px', 
            opacity: 0.7, 
            color: '#fff' 
        },message:"Veuillez patienter",
        onBlock: function() {
            // Récupération des éléments
            self.getElements();

            ko.cleanNode($("#kkk")[0]);
            ko.applyBindings(self,$("#kkk")[0]);

            $("img.lazy").lazyload({effect : "fadeIn"});

            initDatatable(self);
            
            if (self.isBig()) {
                $(".row.content input.search").keypress(function(e) {
                   if(e.which == 13) {
                        self.filter=$(this).val();
                        self.refresh();
                   }
                });
                
                $(".row.content button.go").click(function(e) {
                        self.filter=$(".row.content input.search").val();
                        self.refresh();
                });
                
                $(".row.content button.cancel").click(function(e) {
                        self.filter="";
                        self.refresh();
                });
            }
            
            $(".row.content button").tooltip();

            $(".row.content").unblock();

            // Sur clique d'une ligne
            $(".row.content tr").click(function(event) {
                event.stopPropagation();
                id=$(this).attr("data-id");
                element=self.getElement(id)
                element.show();    
            });

            // Si il exsite un parent, on va renseigner le select
            console.log(self.parent);
            if (self.parent) {
                var $select=$("h1.page-header select")
                $select.empty();
                for (e in self.parent.elements) {
                    el=self.parent.elements[e]
                    var $option=$("<option value='"+el.data.id+"'>"+el.data.name+"</option>");
                    if (el.data.id==self.data.id ) $option.attr("selected","selected");
                    $select.append($option); 
                }

                $select.unbind();
                $select.change(function() {
                    var id=$select.find("option:selected").val();  
                    self.parent.getElement(id).show();
                });
            }



            // Callback de fin de construction de la liste
            if (self.onShow) self.onShow();   
            
        }
                            
                            
    }); 
    
    
    
   
}

CItem.prototype.edit = function(data, event,callback) {
   this._edit(data, event,callback); 
}

// Edition d'un element
CItem.prototype._edit = function(data, event,callback) {

    if (event) event.stopPropagation();
    
    var $target=$("#modal")
    var self=this;

    $.ajax({url: (data && data.url) || "api/"+self.api_tag+"/"+self.id}).done(function (content) {
        
        // Suppression du binding en cours
        ko.cleanNode($("#modal")[0]);
     
        // Affiche la boite de dialogue d'édition
        $target.find(".modal-body").html(content);
        $("#myModalLabel").html("Edition");

        // Aply viewModel bindings
        ko.applyBindings(self,$("#modal")[0]);
        
        // callback pour customisation
        if (self.onEdit) self.onEdit();

        if (self.isEditable()) $("#modal button.save").show();
        else $("#modal button.save").hide();
        
        // Validation du formulaire
        $("#modal input,#modal select,#modal textarea").not("[type=submit]").jqBootstrapValidation(); 
        
        // Affiche la boite de dialogue
        EConnect.showModal();
        
        $(".chosen-select").chosen({width: "100%"});
        $("#modal li.search-field").css("width","100%");
        $("#modal li.search-field input").css("width","100%");
        
        // Sauvegarde des modifications
        $target.find(".modal-footer button.save").click(function(e) {
            
            if (!EConnect.validate()) return;
            var $btn=$(this);
            
            $.ajax({url: "api/"+self.api_tag+"/"+self.id,button:$btn,
                    method:"post",data: self.modalData($target)}).done(function(response) {
                
                appViewModel.refreshList();
                if (self.onSave) self.onSave(response);
                
                if (callback) callback();
                
                $btn.button("reset");
                EConnect.closeModal();
            });         
        })

    })
}

// Suppression d'un élémént
CItem.prototype.trash = function(data,event)  {
    if (event) event.stopPropagation();
    var self = this;    
    $.ajax({url: "api/"+self.api_tag+"/"+self.id,method:"delete"});
}

CItem.prototype.refresh = function() {
    this.clear();
    this.show();
}

CItem.prototype.hasParent = function() {
    return this.parent!=undefined;
}

CItem.prototype.getElement = function(id) {
    var elts=this.getElements();
    for (var e in elts){
        var elt=elts[e]
        if (elt.id == id) {return elt;}
    }
    return null
}

CItem.prototype.getSelectedElements = function() {
    var elts=this.getElements();
    var arr=[]
    for (var e in elts){
        var elt=elts[e]
        if (elt.isChecked()) arr.push(elt);
    }
    return arr
}

CItem.prototype.getSelectedElementsId = function() {
    var elts=this.getElements();
    var arr=[]
    for (var e in elts){
        var elt=elts[e]
        if (elt.isChecked()) arr.push(elt.id);
    }
    return arr
}

CItem.prototype.modalData = function($target) {
    
    data={}
    $target.find(".modal-body input").each(function() {
        field=$(this).attr("field");
        if (!field) return;
        console.log($(this).attr("type"));
        if ($(this).attr("type")=="checkbox") {
            data[field]=$(this).prop("checked");
        } else {
            data[field]=$(this).val();
        }
    });
    $target.find(".modal-body textarea").each(function() {
        field=$(this).attr("field");
        if (!field) return;
        data[field]=$(this).val();
    });
    $target.find(".modal-body select").each(function() {
        field=$(this).attr("field");
        if (!field) return;
        data[field]=$(this).find("option:selected").attr("value");
    });
    
    arr=[]
    for(var i=0;i<this.arrAutorisations().length;i++)
    {
        var r=this.arrAutorisations()[i]
        arr.push(r.export())
    }
    data["autorisations"]=JSON.stringify(arr);
    data["context"]=this.chosenContext();
    
    if (this.onModalData) this.onModalData(data)

    return data;   
}




// ===== ==================================================

var EConnect = function ()
{
}


EConnect.modalData =function($target) {

    data={}
    $target.find(".modal-body input").each(function() {
        field=$(this).attr("field");
        if (!field) return;
        data[field]=$(this).val();
    });
    $target.find(".modal-body select").each(function() {
        field=$(this).attr("field");
        if (!field) return;
        data[field]=$(this).find("option:selected").attr("value");
    });

    return data;

}

EConnect.validate = function() {
    
   // Récupération des erreurs du formulaire
   var errors={}
  /* $objs=$("#modal input[required],#modal select,#modal textarea").not("[type=submit]");
   if ($objs.jqBootstrapValidation("hasErrors")) {
     errors = $objs.jqBootstrapValidation("collectErrors");        
   } else*/ 
   // Pour le moment validation que sur les champs required
   {
    
       $("#modal input[required]").each(function() {
            if ($(this).val().length==0) {
              errors[ $(this).attr('name') ] =  "=> paramètre obligatoire"  
            }
       });
   }
    
    // On va vérifier si il y a des erreurs sur le formulaire
    if (Object.keys(errors).length!=0) {
       
        // Liste des erreurs
        var strErrors="<ul>";
        
        for (error in errors) {
            if (error!=undefined)
            strErrors="<li><b>" +error+"</b> "+errors[error]+"</li>"       
        }
        strErrors=strErrors+"</ul>";
        
        $('html, body').animate({scrollTop:0}, 'fast');
        
        $(".alert-danger div").html("Impossible de valider le formulaire<br>"+strErrors);
        $(".alert-danger").fadeIn();
        
        return false;
    }
    
    
    return true;
    
    
    
}

EConnect.showModal = function () {
    
    // Validation du formulaire
    $("#modal input,#modal select,#modal textarea").not("[type=submit]").jqBootstrapValidation(); 
    $("#modal").find(".modal-footer button.save").unbind();
    $("#modal .alert-danger").hide();
    $("#modal").modal();   
}


EConnect.closeModal = function () {
    
    $("#modal").find(".modal-footer button.save").unbind();
    $("#modal").find(".modal-footer button.save").show();
    $("#modal").find(".modal-footer button.save").button("reset");
    $("#modal .alert-danger").hide();
    $("#modal").modal('hide');
    //try { ko.cleanNode($("#modal")[0]);} catch (e) {}
}




// ==========================================================
