var Contexts = CItem.extend({
    initialize : function(data) { 
        this.api_tag="";
        this.api_elementsTag="contexts";
        this.template = "etablissement-elements-template";
        this.class_element="Context";
        this.getElements(); // Récupération des context
        this.hash="contexts"

        this.options = {
            order: [[ 1, "asc" ]],
            pageLength: 200,
        }

        this.libelleListe("Etablissements"); 
        
    }
});


var Context = CItem.extend({
    initialize : function(data) { 
        var self=this;
        this.api_tag="context";
        this.api_elementsTag="users";
        this.template = "users-template";
        this.class_element="User";
        this.libelleListe("Liste des personnes"); 

        this.options = {
            order: [[ 2, "asc" ]],
            pageLength: 200,
        }

        if (self.data.actif==undefined) self.data.actif=false;
        
        self.actif=ko.observable(JSON.parse(self.data.actif));
        
        self.loading   = ko.observable(false);
        self.garStep   = ko.observable(self.data.garStep);
        self.garActif  = ko.observable(self.data.garActif=="1");
        self.garStatus = ko.computed(function() {
            if (!self.actif()) {
                // Etab désactivé
                if (self.garStep() == -1) {
                    return "<span>Désactivé</span><br>"+
                        "<span class='text-muted'>"+ self.data.garStepMsg + "</span>";
                }
                return "<span class='text-muted'>n/a</span>";
            }

            // Etab En cours d'activation
            if (self.garStep() == 0) {
                return "<span>Demande en cours</span><br>"+
                       "<span class='text-muted'>"+ self.data.garStepMsg + "</span>";
            }

            // Tout est OK
            if (self.garStep()== 1) {
                return "<i class='fa fa-check text-success'></i> Intégré au GAR<br>" +
                       "<span class='text-muted'>"+ self.data.garStepMsg + "</span>";
            }

            // Aucune info
            if (!self.data.garStatus) {
                return "";
            }
            

            return "<b class='text-muted'></b> <span class='text-muted'>" + self.data.garStatus + "</span>";


        });

       

    }
});

Context.prototype.urlOfElements = function()  {
   return "api/"+this.api_tag+"/"+this.id+"/"+this.api_elementsTag
}

Context.prototype.show = function(data,event) {
    if (event)  event.stopPropagation();
     
};

Context.prototype.showUsers = function(data,event) {
    if (event)  event.stopPropagation();

    this.api_tag="context";
    this.api_elementsTag="users";
    this.template = "users-template";
    this.class_element="User";
    this.libelleListe("Responsables d'affectation"); 
    this.clear()
    appViewModel.show(this);
    
};

Context.prototype.ressources = function(data,event) {
    if (event) event.stopImmediatePropagation();
    
    this.template   = "context-ressources-template";
    this.api_elementsTag="ressources";
    this.libelleListe("Liste des ressources"); 
    this.class_element="Ressource";
    appViewModel.setHash("contexts/"+this.id+"/ressources");
    this.clear()
    appViewModel.show(this);
    
};


Context.prototype.activate = function(data,event) {

    console.log(event)
    if (event) event.stopImmediatePropagation();
    
    if (!(this.data.activable)) {return;}
    
    var self=this;
    self.loading(true);
    $.ajax({url: "api/context/"+this.id+"/activate",data:{actif:true},type:"POST"}).done(function (content) {
        var resp = JSON.parse(content);
        self.loading(false);
        self.data=resp;
        self.actif(parseInt(resp.actif))
        self.garStep(parseInt(resp.garStep))   
    }).always(function() {
       
    })
}

Context.prototype.desactivate = function(data,event) {

    console.log(event)
    if (event) event.stopImmediatePropagation();
   
    if (!(this.data.activable)) {return;}
   
    
    var self=this;
    self.loading(true);
    $.ajax({url: "api/context/"+this.id+"/activate",data:{actif:false},type:"POST"}).done(function (content) {
        var resp = JSON.parse(content);
        self.loading(false);
        self.data=resp;
        self.actif(parseInt(resp.actif))
        self.garStep(parseInt(resp.garStep))   
    }).always(function() {
       
    })
}
