window.QueryBuilder = (function(exports, ko){    
    
  function Condition(){
    var self = this;

    self.templateName = 'condition-template';

    self.fields = ko.observableArray(QueryBuilder.ATTRIBUTES);
    self.selectedField = ko.observable(QueryBuilder.ATTRIBUTES[0]);
    
    self.comparisons = ko.observableArray(QueryBuilder.COMPARATORS);
    self.selectedComparison = ko.observable(QueryBuilder.COMPARATORS[0]);

    self.value = ko.observable(0);
      
    self.fromJSON = function (json) {
        self.selectedComparison(json.comparator)   
        self.selectedField(json.field)   
        self.value(json.value);
    }
    
    self.toJSON = function () {
        return {type:'condition',comparator:self.selectedComparison(),field:self.selectedField(),value:self.value()}
    };
    
    self.getText = function () {
        
        if (self.selectedComparison()=="contient") {
            return "( {"+self.selectedField()+"} && " + "count(preg_grep("+ '"/'+self.value()+'/"' +"," +"explode('|',{"+self.selectedField()+"})" + "))!=0 )";        
        }
        
         return '( {'+self.selectedField()+'}' + 
        ' ' +
        self.selectedComparison() + 
        ' ' + 
        "'"+self.value()+"' )";
    };

    // the text() function is just an example to show output
    self.text = ko.computed(function(){
         return '<span class="expression-field">{'+self.selectedField()+'}</span>' + 
        ' <span class="expression-operator">' +
        self.selectedComparison() + 
        '</span> ' + 
       "'"+self.value()+"'";
    });
  }
    
    
  //var Condition = exports.Condition;

  function Group(){
    var self = this;

    self.templateName = 'group-template';
    self.children = ko.observableArray();
    self.logicalOperators = ko.observableArray(['ET', 'OU']);
    self.selectedLogicalOperator = ko.observable('ET');

    // give the group a single default condition
    self.children.push(new Condition());

    self.addCondition = function(){
        self.children.push(new Condition());
    };

    self.addGroup = function(){
        self.children.push(new Group());
    };

    self.removeChild = function(child){
        self.children.remove(child);
    };
      
    self.fromJSON = function (json) {
        var self=this
        self.selectedLogicalOperator(json.operator)
        self.children([])
        for (var i = 0; i < json.children.length; i++){
            child=json.children[i]
            if (child.type=="condition")
            {
                var condition=new Condition()
                condition.fromJSON(child)
                self.children.push(condition)
            }
            if (child.templateName=="group")
            {
                var group=new Group()
                group.fromJSON(child)
                self.children.push(group)
            }
        }
    };
      
    self.toJSON = function () {
        arr=[]
        for (var i = 0; i < self.children().length; i++){
            arr.push(self.children()[i].toJSON());
        }
        return {operator:self.selectedLogicalOperator(),children:arr}
    };
    
    self.getText = function () {
          var comp=self.selectedLogicalOperator()
          if (comp=="ET") comp="&&";
          if (comp=="OU") comp="||";
          var result = '(';      
          var op = '';
          for (var i = 0; i < self.children().length; i++){
            var child = self.children()[i];
            result += op + child.getText();
            op = ' ' + comp + ' ';
          }
          return result += ')';       
    };

    // the text() function is just an example to show output
    self.text = ko.computed(function(){
       var result = ' ( ';      
          var op = '';
          for (var i = 0; i < self.children().length; i++){
            var child = self.children()[i];
            result += op + child.text();
            op = ' ' + self.selectedLogicalOperator() + ' ';
          }
          return result += ' ) ';  
  })
  }

  //var Group = exports.Group;

  function ViewModel(parsed) {
    var self = this;
    self.group = ko.observable(new Group());
    if (parsed) self.group().fromJSON( parsed) ;

        // the text() function is just an example to show output
    self.text = ko.computed(function(){
      return self.group().text();
    });
      
    
  }

  exports.ViewModel = ViewModel;
  exports.Group = Group;
  exports.Condition = Condition;
  return exports;

})(window.QueryBuilder || {}, window.ko);